/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Checkout;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;

public class RemoteModule
extends RemoteFolder {
    private String label;
    private ICVSRemoteResource[] referencedModules;
    private Command.LocalOption[] localOptions;
    private boolean expandable;

    public static RemoteModule[] getRemoteModules(ICVSRepositoryLocation repository, CVSTag tag, IProgressMonitor monitor) throws TeamException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(CVSMessages.RemoteModule_getRemoteModules, 100);
        try {
            RemoteModule[] modules;
            Session s = new Session(repository, RemoteModule.getRemoteRootFolder(repository), false);
            s.open(Policy.subMonitorFor(monitor, 10), false);
            try {
                modules = Command.CHECKOUT.getRemoteModules(s, tag, Policy.subMonitorFor(monitor, 90));
            }
            finally {
                s.close();
            }
            RemoteModule[] remoteModuleArray = modules;
            return remoteModuleArray;
        }
        finally {
            monitor.done();
        }
    }

    private static ICVSFolder getRemoteRootFolder(ICVSRepositoryLocation repository) {
        return new RemoteFolder(null, repository, "/", null);
    }

    public static RemoteModule[] createRemoteModules(String[] moduleDefinitionStrings, ICVSRepositoryLocation repository, CVSTag tag) {
        ArrayList<RemoteFolder> referencedFolders;
        String moduleName;
        HashMap<String, RemoteModule> modules = new HashMap<String, RemoteModule>();
        HashMap<String, String[]> referencedModulesTable = new HashMap<String, String[]>();
        HashMap<String, String[]> moduleAliases = new HashMap<String, String[]>();
        int i = 0;
        while (i < moduleDefinitionStrings.length) {
            block41: {
                String next;
                ArrayList<Command.LocalOption> localOptionsList;
                StringTokenizer tokenizer = new StringTokenizer(moduleDefinitionStrings[i]);
                String moduleName2 = tokenizer.nextToken();
                try {
                    localOptionsList = new ArrayList<Command.LocalOption>();
                    next = tokenizer.nextToken();
                    while (next.charAt(0) == '-') {
                        switch (next.charAt(1)) {
                            case 'a': {
                                localOptionsList.add(Checkout.ALIAS);
                                break;
                            }
                            case 'l': {
                                localOptionsList.add(Command.DO_NOT_RECURSE);
                                break;
                            }
                            case 'd': {
                                localOptionsList.add(Checkout.makeDirectoryNameOption(tokenizer.nextToken()));
                                break;
                            }
                            case 'e': 
                            case 'i': 
                            case 'o': 
                            case 't': 
                            case 'u': {
                                tokenizer.nextToken();
                                break;
                            }
                            case 's': {
                                localOptionsList.add(Checkout.makeStatusOption(tokenizer.nextToken()));
                            }
                        }
                        next = tokenizer.nextToken();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    CVSProviderPlugin.log(2, NLS.bind((String)CVSMessages.RemoteModule_invalidDefinition, (Object[])new String[]{moduleDefinitionStrings[i], repository.getLocation(true)}), null);
                    break block41;
                }
                Command.Option[] localOptions = localOptionsList.toArray(new Command.LocalOption[localOptionsList.size()]);
                if (Checkout.ALIAS.isElementOf(localOptions)) {
                    int cfr_ignored_0 = localOptions.length;
                    ArrayList<String> expansions = new ArrayList<String>(10);
                    expansions.add(next);
                    while (tokenizer.hasMoreTokens()) {
                        expansions.add(tokenizer.nextToken());
                    }
                    moduleAliases.put(moduleName2, expansions.toArray(new String[expansions.size()]));
                    modules.put(moduleName2, new RemoteModule(moduleName2, null, repository, null, (Command.LocalOption[])localOptions, tag, true));
                } else {
                    if (next.charAt(0) != '&') {
                        String directory = next;
                        ArrayList<String> files = new ArrayList<String>();
                        while (tokenizer.hasMoreTokens() && next.charAt(0) != '&') {
                            next = tokenizer.nextToken();
                            if (next.charAt(0) == '&') continue;
                            files.add(next);
                        }
                        RemoteModule remoteModule = new RemoteModule(moduleName2, null, repository, directory, (Command.LocalOption[])localOptions, tag, !files.isEmpty());
                        modules.put(moduleName2, remoteModule);
                        if (!files.isEmpty()) {
                            ICVSRemoteResource[] children = new ICVSRemoteResource[files.size()];
                            int j = 0;
                            while (j < children.length) {
                                children[j] = new RemoteFile(remoteModule, 0, (String)files.get(j), null, null, tag);
                                remoteModule.setChildren(children);
                                ++j;
                            }
                        }
                    } else {
                        modules.put(moduleName2, new RemoteModule(moduleName2, null, repository, null, (Command.LocalOption[])localOptions, tag, true));
                    }
                    if (next.charAt(0) == '&') {
                        ArrayList<String> children = new ArrayList<String>(10);
                        children.add(next);
                        while (tokenizer.hasMoreTokens()) {
                            children.add(tokenizer.nextToken());
                        }
                        referencedModulesTable.put(moduleName2, children.toArray(new String[children.size()]));
                    }
                }
            }
            ++i;
        }
        Iterator iter = moduleAliases.keySet().iterator();
        while (iter.hasNext()) {
            moduleName = (String)iter.next();
            RemoteModule module = (RemoteModule)modules.get(moduleName);
            String[] expansion = (String[])moduleAliases.get(moduleName);
            referencedFolders = new ArrayList<RemoteFolder>();
            boolean expandable = true;
            int i2 = 0;
            while (i2 < expansion.length) {
                if (expansion[i2].charAt(0) == '!') {
                    expandable = false;
                } else {
                    Path path = new Path(null, expansion[i2]);
                    if (path.segmentCount() > 1) {
                        expandable = false;
                    } else {
                        RemoteModule child = (RemoteModule)modules.get(expansion[i2]);
                        if (child == null) {
                            referencedFolders.add(new RemoteFolder(null, repository, path.toString(), tag));
                        } else if (child.isAlias()) {
                            expandable = false;
                        } else {
                            referencedFolders.add(child);
                        }
                    }
                }
                ++i2;
            }
            if (expandable) {
                module.setChildren(referencedFolders.toArray(new ICVSRemoteResource[referencedFolders.size()]));
                continue;
            }
            module.setExpandable(false);
        }
        iter = modules.keySet().iterator();
        while (iter.hasNext()) {
            moduleName = (String)iter.next();
            String[] children = (String[])referencedModulesTable.get(moduleName);
            if (children == null) continue;
            RemoteModule module = (RemoteModule)modules.get(moduleName);
            referencedFolders = new ArrayList();
            boolean expandable = true;
            int i3 = 0;
            while (i3 < children.length) {
                RemoteModule child = (RemoteModule)modules.get(children[i3].substring(1));
                if (child == null) {
                    expandable = false;
                } else if (child.isAlias()) {
                    expandable = false;
                } else if (Command.findOption(child.getLocalOptions(), "-d") != null) {
                    expandable = false;
                } else {
                    referencedFolders.add(child);
                }
                ++i3;
            }
            if (expandable) {
                module.setReferencedModules(referencedFolders.toArray(new ICVSRemoteResource[referencedFolders.size()]));
                continue;
            }
            module.setExpandable(false);
        }
        return modules.values().toArray(new RemoteModule[modules.size()]);
    }

    public RemoteModule(String label, RemoteFolder parent, ICVSRepositoryLocation repository, String repositoryRelativePath, Command.LocalOption[] localOptions, CVSTag tag, boolean isStatic) {
        super(parent, label, repository, repositoryRelativePath == null ? "CVSROOT/Emptydir" : repositoryRelativePath, tag, isStatic);
        this.localOptions = localOptions;
        this.label = label;
        this.expandable = true;
    }

    public Command.LocalOption[] getLocalOptions() {
        return this.localOptions;
    }

    public ICVSRemoteResource[] getMembers(CVSTag tagName, IProgressMonitor monitor) throws CVSException {
        ICVSRemoteResource[] allChildren;
        if (!this.expandable) {
            return new ICVSRemoteResource[0];
        }
        ICVSRemoteResource[] physicalChildren = this.folderInfo.getIsStatic() ? this.getChildren() : super.getMembers(tagName, monitor);
        if (this.referencedModules != null && this.referencedModules.length > 0) {
            if (physicalChildren == null) {
                allChildren = this.referencedModules;
            } else {
                allChildren = new ICVSRemoteResource[physicalChildren.length + this.referencedModules.length];
                int i = 0;
                while (i < physicalChildren.length) {
                    allChildren[i] = physicalChildren[i];
                    ++i;
                }
                i = 0;
                while (i < this.referencedModules.length) {
                    allChildren[i + physicalChildren.length] = this.referencedModules[i];
                    ++i;
                }
            }
        } else {
            allChildren = physicalChildren != null ? physicalChildren : new ICVSRemoteResource[]{};
        }
        return allChildren;
    }

    private void setReferencedModules(ICVSRemoteResource[] referencedModules) {
        this.referencedModules = referencedModules;
    }

    public boolean isAlias() {
        return Checkout.ALIAS.isElementOf(this.localOptions);
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    private void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    public ICVSRemoteResource forTag(ICVSRemoteFolder parent, CVSTag tagName) {
        ICVSRemoteResource[] children;
        RemoteModule r = new RemoteModule(this.label, (RemoteFolder)parent, this.getRepository(), this.folderInfo.getRepository(), this.localOptions, tagName, this.folderInfo.getIsStatic());
        r.setExpandable(this.expandable);
        if (this.folderInfo.getIsStatic() && (children = this.getChildren()) != null) {
            ArrayList<ICVSRemoteResource> taggedChildren = new ArrayList<ICVSRemoteResource>(children.length);
            int i = 0;
            while (i < children.length) {
                ICVSRemoteResource resource = children[i];
                taggedChildren.add(((RemoteResource)resource).forTag(r, tagName));
                ++i;
            }
            r.setChildren(taggedChildren.toArray(new ICVSRemoteResource[taggedChildren.size()]));
        }
        if (this.referencedModules != null) {
            ArrayList<ICVSRemoteResource> taggedModules = new ArrayList<ICVSRemoteResource>(this.referencedModules.length);
            int i = 0;
            while (i < this.referencedModules.length) {
                RemoteModule module = (RemoteModule)this.referencedModules[i];
                taggedModules.add(module.forTag(r, tagName));
                ++i;
            }
            r.setReferencedModules(taggedModules.toArray(new ICVSRemoteResource[taggedModules.size()]));
        }
        return r;
    }

    public boolean isDefinedModule() {
        return true;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof RemoteModule) {
            RemoteModule module = (RemoteModule)arg0;
            return this.getName().equals(module.getName()) && super.equals(module);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() | this.getName().hashCode();
    }

    public ICVSResource getChild(String path) throws CVSException {
        if (path.equals(".") || path.length() == 0) {
            return this;
        }
        if (this.referencedModules != null && path.indexOf("/") == -1) {
            int i = 0;
            while (i < this.referencedModules.length) {
                if (this.referencedModules[i].getName().equals(path)) {
                    return this.referencedModules[i];
                }
                ++i;
            }
        }
        return super.getChild(path);
    }
}

