/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;

public class StringLiteral
extends Expression {
    public static final SimplePropertyDescriptor ESCAPED_VALUE_PROPERTY = new SimplePropertyDescriptor(StringLiteral.class, "escapedValue", String.class, true);
    private static final List PROPERTY_DESCRIPTORS;
    private String escapedValue = "\"\"";

    static {
        ArrayList propertyList = new ArrayList(2);
        StringLiteral.createPropertyList(StringLiteral.class, propertyList);
        StringLiteral.addProperty(ESCAPED_VALUE_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = StringLiteral.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    StringLiteral(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return StringLiteral.propertyDescriptors(apiLevel);
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == ESCAPED_VALUE_PROPERTY) {
            if (get) {
                return this.getEscapedValue();
            }
            this.setEscapedValue((String)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    final int getNodeType0() {
        return 45;
    }

    @Override
    ASTNode clone0(AST target) {
        StringLiteral result = new StringLiteral(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setEscapedValue(this.getEscapedValue());
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String getEscapedValue() {
        return this.escapedValue;
    }

    public void setEscapedValue(String token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null");
        }
        Scanner scanner = this.ast.scanner;
        char[] source = token.toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length);
        try {
            int tokenType = scanner.getNextToken();
            switch (tokenType) {
                case 35: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid string literal : >" + token + "<");
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new IllegalArgumentException("Invalid string literal : >" + token + "<");
        }
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = token;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    void internalSetEscapedValue(String token) {
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = token;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    public String getLiteralValue() {
        String s = this.getEscapedValue();
        int len = s.length();
        char zeroth = s.charAt(0);
        char last = s.charAt(len - 1);
        if (len < 2 || zeroth != '\"' && zeroth != '\'' || last != '\"' && last != '\'') {
            throw new IllegalArgumentException();
        }
        Scanner scanner = this.ast.scanner;
        char[] source = s.toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length);
        try {
            int tokenType = scanner.getNextToken();
            switch (tokenType) {
                case 34: 
                case 35: {
                    return scanner.getCurrentStringLiteral();
                }
            }
            throw new IllegalArgumentException();
        }
        catch (InvalidInputException invalidInputException) {
            throw new IllegalArgumentException();
        }
    }

    public void setLiteralValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        int len = value.length();
        StringBuffer b = new StringBuffer(len + 2);
        b.append("\"");
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            switch (c) {
                case '\b': {
                    b.append("\\b");
                    break;
                }
                case '\t': {
                    b.append("\\t");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\f': {
                    b.append("\\f");
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\"': {
                    b.append("\\\"");
                    break;
                }
                case '\'': {
                    b.append("\\'");
                    break;
                }
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                case '\u0000': {
                    b.append("\\0");
                    break;
                }
                case '\u0001': {
                    b.append("\\1");
                    break;
                }
                case '\u0002': {
                    b.append("\\2");
                    break;
                }
                case '\u0003': {
                    b.append("\\3");
                    break;
                }
                case '\u0004': {
                    b.append("\\4");
                    break;
                }
                case '\u0005': {
                    b.append("\\5");
                    break;
                }
                case '\u0006': {
                    b.append("\\6");
                    break;
                }
                case '\u0007': {
                    b.append("\\7");
                    break;
                }
                default: {
                    b.append(c);
                }
            }
            ++i;
        }
        b.append("\"");
        this.setEscapedValue(b.toString());
    }

    @Override
    int memSize() {
        int size = 44 + StringLiteral.stringSize(this.escapedValue);
        return size;
    }

    @Override
    int treeSize() {
        return this.memSize();
    }
}

