/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.codeassist.ISearchRequestor;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessBindingRequestor;

public class CancelableNameEnvironment
extends SearchableEnvironment {
    public IProgressMonitor monitor;

    public CancelableNameEnvironment(JavaProject project, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        super(project, owner);
        this.monitor = monitor;
    }

    public CancelableNameEnvironment(JavaProject project, IRestrictedAccessBindingRequestor scope, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaScriptModelException {
        super(project, scope, owner);
        this.monitor = monitor;
    }

    private void checkCanceled() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            if (NameLookup.VERBOSE) {
                System.out.println(Thread.currentThread() + " CANCELLING LOOKUP ");
            }
            throw new AbortCompilation(true, (RuntimeException)new OperationCanceledException());
        }
    }

    @Override
    public void findPackages(char[] prefix, ISearchRequestor requestor) {
        this.checkCanceled();
        super.findPackages(prefix, requestor);
    }

    @Override
    public NameEnvironmentAnswer findType(char[] name, char[][] packageName, ITypeRequestor requestor) {
        this.checkCanceled();
        return super.findType(name, packageName, requestor);
    }

    @Override
    public NameEnvironmentAnswer findBinding(char[] typeName, char[][] packageName, int type, ITypeRequestor requestor, boolean returnMultiple, String excludePath) {
        this.checkCanceled();
        return super.findBinding(typeName, packageName, type, requestor, returnMultiple, excludePath);
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] compoundTypeName, ITypeRequestor requestor) {
        this.checkCanceled();
        return super.findType(compoundTypeName, requestor);
    }

    @Override
    public void findTypes(char[] prefix, boolean findMembers, boolean camelCaseMatch, int searchFor, ISearchRequestor storage) {
        this.checkCanceled();
        super.findTypes(prefix, findMembers, camelCaseMatch, searchFor, storage);
    }
}

