/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.jdt.internal.debug.ui.jres.JREDescriptor;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JREsComboBlock {
    public static final String PROPERTY_JRE = "PROPERTY_JRE";
    private Composite fControl;
    private List<Object> fVMs = new ArrayList<Object>();
    private Combo fCombo;
    private Button fManageButton;
    private ListenerList fListeners = new ListenerList();
    private boolean fDefaultFirst;
    private JREDescriptor fDefaultDescriptor = null;
    private JREDescriptor fSpecificDescriptor = null;
    private Button fDefaultButton = null;
    private Button fSpecificButton = null;
    private String fTitle = null;
    private Button fEnvironmentsButton = null;
    private Combo fEnvironmentsCombo = null;
    private Button fManageEnvironmentsButton = null;
    private IPath fErrorPath;
    private List<Object> fEnvironments = new ArrayList<Object>();
    private IStatus fStatus = OK_STATUS;
    private static IStatus OK_STATUS = new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, "", null);

    public JREsComboBlock(boolean defaultFirst) {
        this.fDefaultFirst = defaultFirst;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private void firePropertyChange() {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROPERTY_JRE, null, (Object)this.getPath());
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            listener.propertyChange(event);
            ++i;
        }
    }

    public void createControl(Composite ancestor) {
        this.fControl = SWTFactory.createComposite((Composite)ancestor, (int)1, (int)1, (int)1808);
        if (this.fTitle == null) {
            this.fTitle = JREMessages.JREsComboBlock_3;
        }
        Group group = SWTFactory.createGroup((Composite)this.fControl, (String)this.fTitle, (int)1, (int)1, (int)768);
        Composite comp = SWTFactory.createComposite((Composite)group, (Font)group.getFont(), (int)3, (int)1, (int)1808, (int)0, (int)0);
        if (this.fDefaultFirst) {
            this.createDefaultJREControls(comp);
        }
        this.createEEControls(comp);
        this.createAlternateJREControls(comp);
        if (!this.fDefaultFirst) {
            this.createDefaultJREControls(comp);
        }
    }

    private void createEEControls(Composite comp) {
        this.fEnvironmentsButton = SWTFactory.createRadioButton((Composite)comp, (String)JREMessages.JREsComboBlock_4);
        this.fEnvironmentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JREsComboBlock.this.fEnvironmentsButton.getSelection()) {
                    JREsComboBlock.this.fCombo.setEnabled(false);
                    if (JREsComboBlock.this.fEnvironmentsCombo.getText().length() == 0 && !JREsComboBlock.this.fEnvironments.isEmpty()) {
                        JREsComboBlock.this.fEnvironmentsCombo.select(0);
                    }
                    JREsComboBlock.this.fEnvironmentsCombo.setEnabled(true);
                    if (JREsComboBlock.this.fEnvironments.isEmpty()) {
                        JREsComboBlock.this.setError(JREMessages.JREsComboBlock_5);
                    } else {
                        JREsComboBlock.this.setStatus(OK_STATUS);
                    }
                    JREsComboBlock.this.firePropertyChange();
                }
            }
        });
        this.fEnvironmentsCombo = SWTFactory.createCombo((Composite)comp, (int)12, (int)1, null);
        this.fEnvironmentsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JREsComboBlock.this.setPath(JavaRuntime.newJREContainerPath((IExecutionEnvironment)JREsComboBlock.this.getEnvironment()));
                JREsComboBlock.this.firePropertyChange();
            }
        });
        this.fManageEnvironmentsButton = SWTFactory.createPushButton((Composite)comp, (String)JREMessages.JREsComboBlock_14, null);
        this.fManageEnvironmentsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JREsComboBlock.this.showPrefPage("org.eclipse.jdt.debug.ui.jreProfiles");
            }
        });
        this.fillWithWorkspaceProfiles();
    }

    private void createAlternateJREControls(Composite comp) {
        String text = JREMessages.JREsComboBlock_1;
        if (this.fSpecificDescriptor != null) {
            text = this.fSpecificDescriptor.getDescription();
        }
        this.fSpecificButton = SWTFactory.createRadioButton((Composite)comp, (String)text, (int)1);
        this.fSpecificButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JREsComboBlock.this.fSpecificButton.getSelection()) {
                    JREsComboBlock.this.fCombo.setEnabled(true);
                    if (JREsComboBlock.this.fCombo.getText().length() == 0 && !JREsComboBlock.this.fVMs.isEmpty()) {
                        JREsComboBlock.this.fCombo.select(0);
                    }
                    if (JREsComboBlock.this.fVMs.isEmpty()) {
                        JREsComboBlock.this.setError(JREMessages.JREsComboBlock_0);
                    } else {
                        JREsComboBlock.this.setStatus(OK_STATUS);
                    }
                    JREsComboBlock.this.fEnvironmentsCombo.setEnabled(false);
                    JREsComboBlock.this.firePropertyChange();
                }
            }
        });
        this.fCombo = SWTFactory.createCombo((Composite)comp, (int)12, (int)1, null);
        ControlAccessibleListener.addListener((Control)this.fCombo, this.fSpecificButton.getText());
        this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JREsComboBlock.this.setStatus(OK_STATUS);
                JREsComboBlock.this.firePropertyChange();
            }
        });
        this.fManageButton = SWTFactory.createPushButton((Composite)comp, (String)JREMessages.JREsComboBlock_2, null);
        this.fManageButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JREsComboBlock.this.showPrefPage("org.eclipse.jdt.debug.ui.preferences.VMPreferencePage");
            }
        });
        this.fillWithWorkspaceJREs();
    }

    private void createDefaultJREControls(Composite comp) {
        if (this.fDefaultDescriptor != null) {
            this.fDefaultButton = SWTFactory.createRadioButton((Composite)comp, (String)this.fDefaultDescriptor.getDescription(), (int)3);
            this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (JREsComboBlock.this.fDefaultButton.getSelection()) {
                        JREsComboBlock.this.setUseDefaultJRE();
                        JREsComboBlock.this.setStatus(OK_STATUS);
                        JREsComboBlock.this.firePropertyChange();
                    }
                }
            });
        }
    }

    private void showPrefPage(String id) {
        IVMInstall prevJRE = this.getJRE();
        IExecutionEnvironment prevEnv = this.getEnvironment();
        JDIDebugUIPlugin.showPreferencePage(id);
        this.fillWithWorkspaceJREs();
        this.fillWithWorkspaceProfiles();
        this.restoreCombo(this.fVMs, prevJRE, this.fCombo);
        this.restoreCombo(this.fEnvironments, prevEnv, this.fEnvironmentsCombo);
        this.setDefaultJREDescriptor(this.fDefaultDescriptor);
        if (this.isDefaultJRE()) {
            this.setUseDefaultJRE();
        }
        this.setPath(this.getPath());
        this.firePropertyChange();
    }

    private void restoreCombo(List<Object> elements, Object element, Combo combo) {
        int index = -1;
        if (element != null) {
            index = elements.indexOf(element);
        }
        if (index >= 0) {
            combo.select(index);
        } else {
            combo.select(0);
        }
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setJREs(List<VMStandin> jres) {
        this.fVMs.clear();
        this.fVMs.addAll(jres);
        Collections.sort(this.fVMs, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                IVMInstall left = (IVMInstall)o1;
                IVMInstall right = (IVMInstall)o2;
                return left.getName().compareToIgnoreCase(right.getName());
            }

            @Override
            public boolean equals(Object obj) {
                return obj == this;
            }
        });
        String[] names = new String[this.fVMs.size()];
        Iterator<Object> iter = this.fVMs.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IVMInstall vm = (IVMInstall)iter.next();
            names[i] = vm.getName();
            ++i;
        }
        this.fCombo.setItems(names);
        this.fCombo.setVisibleItemCount(Math.min(names.length, 20));
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    private void selectJRE(IVMInstall vm) {
        int index;
        this.fSpecificButton.setSelection(true);
        this.fDefaultButton.setSelection(false);
        this.fEnvironmentsButton.setSelection(false);
        this.fCombo.setEnabled(true);
        this.fEnvironmentsCombo.setEnabled(false);
        if (vm != null && (index = this.fVMs.indexOf(vm)) >= 0) {
            this.fCombo.select(index);
        }
        this.firePropertyChange();
    }

    private void selectEnvironment(IExecutionEnvironment env) {
        int index;
        this.fSpecificButton.setSelection(false);
        this.fDefaultButton.setSelection(false);
        this.fCombo.setEnabled(false);
        this.fEnvironmentsButton.setSelection(true);
        this.fEnvironmentsCombo.setEnabled(true);
        if (env != null && (index = this.fEnvironments.indexOf(env)) >= 0) {
            this.fEnvironmentsCombo.select(index);
        }
        this.firePropertyChange();
    }

    public IVMInstall getJRE() {
        int index = this.fCombo.getSelectionIndex();
        if (index >= 0) {
            return (IVMInstall)this.fVMs.get(index);
        }
        return null;
    }

    private IExecutionEnvironment getEnvironment() {
        int index = this.fEnvironmentsCombo.getSelectionIndex();
        if (index >= 0) {
            return (IExecutionEnvironment)this.fEnvironments.get(index);
        }
        return null;
    }

    protected void fillWithWorkspaceJREs() {
        ArrayList<VMStandin> standins = new ArrayList<VMStandin>();
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstallType type = types[i];
            IVMInstall[] installs = type.getVMInstalls();
            int j = 0;
            while (j < installs.length) {
                IVMInstall install = installs[j];
                standins.add(new VMStandin(install));
                ++j;
            }
            ++i;
        }
        this.setJREs(standins);
    }

    protected void fillWithWorkspaceProfiles() {
        this.fEnvironments.clear();
        IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        int i = 0;
        while (i < environments.length) {
            this.fEnvironments.add(environments[i]);
            ++i;
        }
        String[] names = new String[this.fEnvironments.size()];
        Iterator<Object> iter = this.fEnvironments.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            IExecutionEnvironment env = (IExecutionEnvironment)iter.next();
            IPath path = JavaRuntime.newJREContainerPath((IExecutionEnvironment)env);
            IVMInstall install = JavaRuntime.getVMInstall((IPath)path);
            names[i2] = install != null ? NLS.bind((String)JREMessages.JREsComboBlock_15, (Object[])new String[]{env.getId(), install.getName()}) : NLS.bind((String)JREMessages.JREsComboBlock_16, (Object[])new String[]{env.getId()});
            ++i2;
        }
        this.fEnvironmentsCombo.setItems(names);
        this.fEnvironmentsCombo.setVisibleItemCount(Math.min(names.length, 20));
    }

    public void setDefaultJREDescriptor(JREDescriptor descriptor) {
        this.fDefaultDescriptor = descriptor;
        this.setButtonTextFromDescriptor(this.fDefaultButton, descriptor);
    }

    private void setButtonTextFromDescriptor(Button button, JREDescriptor descriptor) {
        if (button != null) {
            String currentText = button.getText();
            String newText = descriptor.getDescription();
            if (!newText.equals(currentText)) {
                button.setText(newText);
                this.fControl.layout();
            }
        }
    }

    public void setSpecificJREDescriptor(JREDescriptor descriptor) {
        this.fSpecificDescriptor = descriptor;
        this.setButtonTextFromDescriptor(this.fSpecificButton, descriptor);
    }

    public boolean isDefaultJRE() {
        if (this.fDefaultButton != null) {
            return this.fDefaultButton.getSelection();
        }
        return false;
    }

    private void setUseDefaultJRE() {
        if (this.fDefaultDescriptor != null) {
            this.fDefaultButton.setSelection(true);
            this.fSpecificButton.setSelection(false);
            this.fEnvironmentsButton.setSelection(false);
            this.fCombo.setEnabled(false);
            this.fEnvironmentsCombo.setEnabled(false);
            this.firePropertyChange();
        }
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public void refresh() {
        this.setDefaultJREDescriptor(this.fDefaultDescriptor);
    }

    public IPath getPath() {
        if (!this.getStatus().isOK() && this.fErrorPath != null) {
            return this.fErrorPath;
        }
        if (this.fEnvironmentsButton.getSelection()) {
            int index = this.fEnvironmentsCombo.getSelectionIndex();
            if (index >= 0) {
                IExecutionEnvironment env = (IExecutionEnvironment)this.fEnvironments.get(index);
                return JavaRuntime.newJREContainerPath((IExecutionEnvironment)env);
            }
            return null;
        }
        if (this.fSpecificButton.getSelection()) {
            int index = this.fCombo.getSelectionIndex();
            if (index >= 0) {
                IVMInstall vm = (IVMInstall)this.fVMs.get(index);
                return JavaRuntime.newJREContainerPath((IVMInstall)vm);
            }
            return null;
        }
        return JavaRuntime.newDefaultJREContainerPath();
    }

    public void setPath(IPath containerPath) {
        this.fErrorPath = null;
        this.setStatus(OK_STATUS);
        if (JavaRuntime.newDefaultJREContainerPath().equals((Object)containerPath)) {
            this.setUseDefaultJRE();
        } else {
            String envId = JavaRuntime.getExecutionEnvironmentId((IPath)containerPath);
            if (envId != null) {
                IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
                IExecutionEnvironment environment = manager.getEnvironment(envId);
                if (environment == null) {
                    this.fErrorPath = containerPath;
                    this.selectEnvironment(environment);
                    this.setError(NLS.bind((String)JREMessages.JREsComboBlock_6, (Object[])new String[]{envId}));
                } else {
                    this.selectEnvironment(environment);
                    IVMInstall[] installs = environment.getCompatibleVMs();
                    if (installs.length == 0) {
                        this.setError(NLS.bind((String)JREMessages.JREsComboBlock_7, (Object[])new String[]{environment.getId()}));
                    }
                }
            } else {
                IVMInstall install = JavaRuntime.getVMInstall((IPath)containerPath);
                if (install == null) {
                    this.selectJRE(install);
                    this.fErrorPath = containerPath;
                    String installTypeId = JavaRuntime.getVMInstallTypeId((IPath)containerPath);
                    if (installTypeId == null) {
                        this.setError(JREMessages.JREsComboBlock_8);
                    } else {
                        IVMInstallType installType = JavaRuntime.getVMInstallType((String)installTypeId);
                        if (installType == null) {
                            this.setError(NLS.bind((String)JREMessages.JREsComboBlock_9, (Object[])new String[]{installTypeId}));
                        } else {
                            String installName = JavaRuntime.getVMInstallName((IPath)containerPath);
                            if (installName == null) {
                                this.setError(NLS.bind((String)JREMessages.JREsComboBlock_10, (Object[])new String[]{installType.getName()}));
                            } else {
                                this.setError(NLS.bind((String)JREMessages.JREsComboBlock_11, (Object[])new String[]{installName, installType.getName()}));
                            }
                        }
                    }
                } else {
                    this.selectJRE(install);
                    File location = install.getInstallLocation();
                    if (location == null) {
                        this.setError(JREMessages.JREsComboBlock_12);
                    } else if (!location.exists()) {
                        this.setError(JREMessages.JREsComboBlock_13);
                    }
                }
            }
        }
    }

    private void setError(String message) {
        this.setStatus((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, message, null));
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    private void setStatus(IStatus status) {
        this.fStatus = status;
    }
}

