/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.ModelProviderEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.Messages;

public class ExternalFeatureModelManager {
    private ListenerList fListeners = new ListenerList();
    private IFeatureModel[] fModels;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IFeatureModel createModel(File manifest) throws CoreException {
        ExternalFeatureModel externalFeatureModel;
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation(manifest.getParent());
        InputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(manifest));
            model.load(stream, false);
            externalFeatureModel = model;
            if (stream == null) return externalFeatureModel;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.TargetFeature_FileDoesNotExist, (Object)manifest)));
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            stream.close();
            return externalFeatureModel;
        }
        catch (IOException iOException) {}
        return externalFeatureModel;
    }

    public void addModelProviderListener(IModelProviderListener listener) {
        this.fListeners.add((Object)listener);
    }

    private void fireModelProviderEvent(IModelProviderEvent e) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IModelProviderListener listener = (IModelProviderListener)listeners[i];
            listener.modelsChanged(e);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        IFeatureModel[] oldModels = null;
        ExternalFeatureModelManager externalFeatureModelManager = this;
        synchronized (externalFeatureModelManager) {
            oldModels = this.fModels != null ? this.fModels : new IFeatureModel[]{};
            long startTime = System.currentTimeMillis();
            this.fModels = this.getExternalModels();
            if (PDECore.DEBUG_MODEL) {
                System.out.println("Time to load features from target platform (ms): " + (System.currentTimeMillis() - startTime));
                System.out.println("External features loaded: " + this.fModels.length);
            }
        }
        this.notifyListeners(oldModels, this.fModels);
    }

    private IFeatureModel[] getExternalModels() {
        if (PDECore.getDefault().getModelManager().isCancelled()) {
            return new IFeatureModel[0];
        }
        ITargetDefinition target = null;
        try {
            target = TargetPlatformHelper.getWorkspaceTargetResolved(null);
        }
        catch (CoreException e) {
            PDECore.log(e);
            return new IFeatureModel[0];
        }
        if (target == null) {
            return new IFeatureModel[0];
        }
        ArrayList<IFeatureModel> result = new ArrayList<IFeatureModel>();
        TargetFeature[] features = target.getAllFeatures();
        if (features != null) {
            int i = 0;
            while (i < features.length) {
                String location = features[i].getLocation();
                File manifest = new File(location, "feature.xml");
                if (manifest.exists() && manifest.isFile()) {
                    try {
                        IFeatureModel model = ExternalFeatureModelManager.createModel(manifest);
                        if (model != null && model.isLoaded()) {
                            result.add(model);
                        }
                    }
                    catch (CoreException e) {
                        PDECore.log(e);
                    }
                }
                ++i;
            }
        }
        return result.toArray(new IFeatureModel[result.size()]);
    }

    private void notifyListeners(IFeatureModel[] oldModels, IFeatureModel[] newFeatureModels) {
        if (oldModels.length > 0 || newFeatureModels.length > 0) {
            int type = 0;
            if (oldModels.length > 0) {
                type |= 2;
            }
            if (newFeatureModels.length > 0) {
                type |= 1;
            }
            ModelProviderEvent replacedFeatures = new ModelProviderEvent(this, type, newFeatureModels, oldModels, null);
            this.fireModelProviderEvent(replacedFeatures);
        }
    }

    public void removeModelProviderListener(IModelProviderListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public IFeatureModel[] getModels() {
        return this.fModels;
    }

    public static TargetFeature[] createFeatures(String platformHome, ArrayList<?> additionalLocations, IProgressMonitor monitor) {
        if (platformHome != null && platformHome.length() > 0) {
            URL[] featureURLs = PluginPathFinder.getFeaturePaths(platformHome);
            if (additionalLocations.size() == 0) {
                return ExternalFeatureModelManager.createFeatures(featureURLs, monitor);
            }
            File[] dirs = new File[additionalLocations.size()];
            int i = 0;
            while (i < dirs.length) {
                String directory = additionalLocations.get(i).toString();
                File dir = new File(directory, "features");
                if (!dir.exists()) {
                    dir = new File(directory);
                }
                dirs[i] = dir;
                ++i;
            }
            URL[] newUrls = PluginPathFinder.scanLocations(dirs);
            URL[] result = new URL[featureURLs.length + newUrls.length];
            System.arraycopy(featureURLs, 0, result, 0, featureURLs.length);
            System.arraycopy(newUrls, 0, result, featureURLs.length, newUrls.length);
            return ExternalFeatureModelManager.createFeatures(result, monitor);
        }
        return new TargetFeature[0];
    }

    private static TargetFeature[] createFeatures(URL[] featurePaths, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", featurePaths.length);
        HashMap<String, TargetFeature> uniqueFeatures = new HashMap<String, TargetFeature>();
        int i = 0;
        while (i < featurePaths.length) {
            File manifest = new File(featurePaths[i].getFile(), "feature.xml");
            if (!manifest.exists() || !manifest.isFile()) {
                monitor.worked(1);
            } else {
                try {
                    TargetFeature model = new TargetFeature(manifest);
                    uniqueFeatures.put(String.valueOf(model.getId()) + "_" + model.getVersion(), model);
                }
                catch (CoreException coreException) {}
                monitor.worked(1);
            }
            ++i;
        }
        Collection models = uniqueFeatures.values();
        return models.toArray(new TargetFeature[models.size()]);
    }
}

