/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.InlineLocalVariableDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NecessaryParenthesesChecker;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.TempAssignmentFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class InlineTempRefactoring
extends Refactoring {
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    private VariableDeclaration fVariableDeclaration;
    private SimpleName[] fReferences;
    private CompilationUnit fASTRoot;

    public InlineTempRefactoring(ICompilationUnit unit, CompilationUnit node, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fASTRoot = node;
        this.fVariableDeclaration = null;
    }

    public InlineTempRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        this(unit, null, selectionStart, selectionLength);
    }

    public InlineTempRefactoring(VariableDeclaration decl) {
        this.fVariableDeclaration = decl;
        ASTNode astRoot = decl.getRoot();
        Assert.isTrue((boolean)(astRoot instanceof CompilationUnit));
        this.fASTRoot = (CompilationUnit)astRoot;
        Assert.isTrue((boolean)(this.fASTRoot.getJavaElement() instanceof ICompilationUnit));
        this.fSelectionStart = decl.getStartPosition();
        this.fSelectionLength = decl.getLength();
        this.fCu = (ICompilationUnit)this.fASTRoot.getJavaElement();
    }

    public InlineTempRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null, null, 0, 0);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public RefactoringStatus checkIfTempSelected() {
        VariableDeclaration decl = this.getVariableDeclaration();
        if (decl == null) {
            return CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.getASTRoot(), RefactoringCoreMessages.InlineTempRefactoring_select_temp);
        }
        if (decl.getParent() instanceof FieldDeclaration) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTemRefactoring_error_message_fieldsCannotBeInlined);
        }
        return new RefactoringStatus();
    }

    private CompilationUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, null);
        }
        return this.fASTRoot;
    }

    public VariableDeclaration getVariableDeclaration() {
        if (this.fVariableDeclaration == null) {
            this.fVariableDeclaration = TempDeclarationFinder.findTempDeclaration(this.getASTRoot(), this.fSelectionStart, this.fSelectionLength);
        }
        return this.fVariableDeclaration;
    }

    public String getName() {
        return RefactoringCoreMessages.InlineTempRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 1);
            RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            VariableDeclaration declaration = this.getVariableDeclaration();
            result.merge(this.checkSelection(declaration));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkInitializer(declaration));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkInitializer(VariableDeclaration decl) {
        if (decl.getInitializer().getNodeType() == 33) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTemRefactoring_error_message_nulLiteralsCannotBeInlined);
        }
        return null;
    }

    private RefactoringStatus checkSelection(VariableDeclaration decl) {
        ASTNode parent = decl.getParent();
        if (parent instanceof MethodDeclaration) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_method_parameter);
        }
        if (parent instanceof CatchClause) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_exceptions_declared);
        }
        if (parent instanceof VariableDeclarationExpression && parent.getLocationInParent() == ForStatement.INITIALIZERS_PROPERTY) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_for_initializers);
        }
        if (parent instanceof VariableDeclarationExpression && parent.getLocationInParent() == TryStatement.RESOURCES_PROPERTY) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_resource_in_try_with_resources);
        }
        if (decl.getInitializer() == null) {
            String message = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_not_initialized, BasicElementLabels.getJavaElementName(decl.getName().getIdentifier()));
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        return this.checkAssignments(decl);
    }

    private RefactoringStatus checkAssignments(VariableDeclaration decl) {
        TempAssignmentFinder assignmentFinder = new TempAssignmentFinder(decl);
        this.getASTRoot().accept((ASTVisitor)assignmentFinder);
        if (!assignmentFinder.hasAssignments()) {
            return new RefactoringStatus();
        }
        ASTNode firstAssignment = assignmentFinder.getFirstAssignment();
        int start = firstAssignment.getStartPosition();
        int length = firstAssignment.getLength();
        SourceRange range = new SourceRange(start, length);
        RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)this.fCu, (ISourceRange)range);
        String message = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_assigned_more_once, BasicElementLabels.getJavaElementName(decl.getName().getIdentifier()));
        return RefactoringStatus.createFatalErrorStatus((String)message, (RefactoringStatusContext)context);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 1);
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.InlineTempRefactoring_preview, 2);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaProject javaProject = this.fCu.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            IVariableBinding binding = this.getVariableDeclaration().resolveBinding();
            String text = null;
            IMethodBinding method = binding.getDeclaringMethod();
            text = method != null ? BindingLabelProvider.getBindingLabel((IBinding)method, JavaElementLabels.ALL_FULLY_QUALIFIED) : BasicElementLabels.getJavaElementName("{...}");
            String description = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(binding.getName()));
            String header = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED), text});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.InlineTempRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            InlineLocalVariableDescriptor descriptor = RefactoringSignatureDescriptorFactory.createInlineLocalVariableDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)0);
            arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCu));
            arguments.put("selection", String.valueOf(String.valueOf(this.fSelectionStart)) + ' ' + String.valueOf(this.fSelectionLength));
            CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite(this.fCu, this.fASTRoot);
            this.inlineTemp(cuRewrite);
            this.removeTemp(cuRewrite);
            CompilationUnitChange result = cuRewrite.createChange(RefactoringCoreMessages.InlineTempRefactoring_inline, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            result.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor));
            CompilationUnitChange compilationUnitChange = result;
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    private void inlineTemp(CompilationUnitRewrite cuRewrite) throws JavaModelException {
        SimpleName[] references = this.getReferences();
        TextEditGroup groupDesc = cuRewrite.createGroupDescription(RefactoringCoreMessages.InlineTempRefactoring_inline_edit_name);
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        int i = 0;
        while (i < references.length) {
            SimpleName curr = references[i];
            Expression initializerCopy = this.getInitializerSource(cuRewrite, curr);
            rewrite.replace((ASTNode)curr, (ASTNode)initializerCopy, groupDesc);
            ++i;
        }
    }

    private void removeTemp(CompilationUnitRewrite cuRewrite) {
        VariableDeclaration variableDeclaration = this.getVariableDeclaration();
        TextEditGroup groupDesc = cuRewrite.createGroupDescription(RefactoringCoreMessages.InlineTempRefactoring_remove_edit_name);
        ASTNode parent = variableDeclaration.getParent();
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        TightSourceRangeComputer sourceRangeComputer = new TightSourceRangeComputer();
        rewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)sourceRangeComputer);
        if (parent instanceof VariableDeclarationStatement && ((VariableDeclarationStatement)parent).fragments().size() == 1) {
            sourceRangeComputer.addTightSourceNode(parent);
            rewrite.remove(parent, groupDesc);
        } else {
            sourceRangeComputer.addTightSourceNode((ASTNode)variableDeclaration);
            rewrite.remove((ASTNode)variableDeclaration, groupDesc);
        }
    }

    private Expression getInitializerSource(CompilationUnitRewrite rewrite, SimpleName reference) throws JavaModelException {
        Expression copy = this.getModifiedInitializerSource(rewrite, reference);
        if (NecessaryParenthesesChecker.needsParentheses(copy, reference.getParent(), reference.getLocationInParent())) {
            ParenthesizedExpression parentExpr = rewrite.getAST().newParenthesizedExpression();
            parentExpr.setExpression(copy);
            return parentExpr;
        }
        return copy;
    }

    private Expression getModifiedInitializerSource(CompilationUnitRewrite rewrite, SimpleName reference) throws JavaModelException {
        ITypeBinding explicitCast;
        ITypeBinding[] typeArguments;
        VariableDeclaration varDecl = this.getVariableDeclaration();
        Expression initializer = varDecl.getInitializer();
        ASTNode referenceContext = reference.getParent();
        if (Invocations.isResolvedTypeInferredFromExpectedType(initializer) && !(referenceContext instanceof VariableDeclarationFragment) && !(referenceContext instanceof SingleVariableDeclaration) && !(referenceContext instanceof Assignment) && (typeArguments = Invocations.getInferredTypeArguments(initializer)) != null) {
            String newSource = this.createParameterizedInvocation(initializer, typeArguments, rewrite);
            return (Expression)rewrite.getASTRewrite().createStringPlaceholder(newSource, initializer.getNodeType());
        }
        Expression copy = (Expression)rewrite.getASTRewrite().createCopyTarget((ASTNode)initializer);
        AST ast = rewrite.getAST();
        if (NecessaryParenthesesChecker.needsParentheses(initializer, reference.getParent(), reference.getLocationInParent())) {
            ParenthesizedExpression parenthesized = ast.newParenthesizedExpression();
            parenthesized.setExpression(copy);
            copy = parenthesized;
        }
        if ((explicitCast = ASTNodes.getExplicitCast(initializer, (Expression)reference)) != null) {
            CastExpression cast = ast.newCastExpression();
            if (NecessaryParenthesesChecker.needsParentheses(copy, (ASTNode)cast, (StructuralPropertyDescriptor)CastExpression.EXPRESSION_PROPERTY)) {
                ParenthesizedExpression parenthesized = ast.newParenthesizedExpression();
                parenthesized.setExpression(copy);
                copy = parenthesized;
            }
            cast.setExpression(copy);
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)reference, rewrite.getImportRewrite());
            cast.setType(rewrite.getImportRewrite().addImport(explicitCast, ast, (ImportRewrite.ImportRewriteContext)context));
            copy = cast;
        } else if (initializer instanceof ArrayInitializer && ASTNodes.getDimensions(varDecl) > 0) {
            ArrayType newType = (ArrayType)ASTNodeFactory.newType(ast, varDecl);
            ArrayCreation newArrayCreation = ast.newArrayCreation();
            newArrayCreation.setType(newType);
            newArrayCreation.setInitializer((ArrayInitializer)copy);
            return newArrayCreation;
        }
        return copy;
    }

    private String createParameterizedInvocation(Expression invocation, ITypeBinding[] typeArguments, CompilationUnitRewrite cuRewrite) throws JavaModelException {
        MethodInvocation methodInvocation;
        Object expression;
        ASTRewrite rewrite = ASTRewrite.create((AST)invocation.getAST());
        ListRewrite typeArgsRewrite = Invocations.getInferredTypeArgumentsRewrite(rewrite, invocation);
        int i = 0;
        while (i < typeArguments.length) {
            Type typeArgumentNode = cuRewrite.getImportRewrite().addImport(typeArguments[i], cuRewrite.getAST());
            typeArgsRewrite.insertLast((ASTNode)typeArgumentNode, null);
            ++i;
        }
        if (invocation instanceof MethodInvocation && (expression = (methodInvocation = (MethodInvocation)invocation).getExpression()) == null) {
            IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
            expression = methodBinding != null && Modifier.isStatic((int)methodBinding.getModifiers()) ? cuRewrite.getAST().newName(cuRewrite.getImportRewrite().addImport(methodBinding.getDeclaringClass().getTypeDeclaration())) : invocation.getAST().newThisExpression();
            rewrite.set((ASTNode)invocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, expression, null);
        }
        Document document = new Document(this.fCu.getBuffer().getContents());
        RangeMarker marker = new RangeMarker(invocation.getStartPosition(), invocation.getLength());
        IJavaProject project = this.fCu.getJavaProject();
        TextEdit[] rewriteEdits = rewrite.rewriteAST((IDocument)document, project.getOptions(true)).removeChildren();
        marker.addChildren(rewriteEdits);
        try {
            marker.apply((IDocument)document, 2);
            String rewrittenInitializer = document.get(marker.getOffset(), marker.getLength());
            IRegion region = document.getLineInformation(document.getLineOfOffset(marker.getOffset()));
            int oldIndent = Strings.computeIndentUnits(document.get(region.getOffset(), region.getLength()), project);
            return Strings.changeIndent(rewrittenInitializer, oldIndent, project, "", TextUtilities.getDefaultLineDelimiter((IDocument)document));
        }
        catch (MalformedTreeException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        return this.fCu.getBuffer().getText(invocation.getStartPosition(), invocation.getLength());
    }

    public SimpleName[] getReferences() {
        if (this.fReferences != null) {
            return this.fReferences;
        }
        TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer(this.getVariableDeclaration(), false);
        analyzer.perform();
        this.fReferences = analyzer.getReferenceNodes();
        return this.fReferences;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        int length;
        int offset;
        String selection = arguments.getAttribute("selection");
        if (selection != null) {
            offset = -1;
            length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 5) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.inline.temp");
            }
            this.fCu = (ICompilationUnit)element;
            if (this.checkIfTempSelected().hasFatalError()) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.inline.temp");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        return new RefactoringStatus();
    }
}

