/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.filters.EmptyInnerPackageFilter;
import org.eclipse.jdt.internal.ui.jarpackager.IJarPackageWizardPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageWizard;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.jarpackager.SealPackagesFilter;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.MainMethodSearchEngine;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.LibraryFilter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JarManifestWizardPage
extends WizardPage
implements IJarPackageWizardPage {
    private UntypedListener fUntypedListener = new UntypedListener();
    private JarPackageData fJarPackage;
    private IType[] fMainTypes;
    private Composite fManifestGroup;
    private Button fGenerateManifestRadioButton;
    private Button fSaveManifestCheckbox;
    private Button fReuseManifestCheckbox;
    private Text fNewManifestFileText;
    private Label fNewManifestFileLabel;
    private Button fNewManifestFileBrowseButton;
    private Button fUseManifestRadioButton;
    private Text fManifestFileText;
    private Label fManifestFileLabel;
    private Button fManifestFileBrowseButton;
    private Label fSealingHeaderLabel;
    private Button fSealJarRadioButton;
    private Label fSealJarLabel;
    private Button fSealedPackagesDetailsButton;
    private Button fSealPackagesRadioButton;
    private Label fSealPackagesLabel;
    private Button fUnSealedPackagesDetailsButton;
    private Label fMainClassHeaderLabel;
    private Label fMainClassLabel;
    private Text fMainClassText;
    private Button fMainClassBrowseButton;
    private static final String PAGE_NAME = "JarManifestWizardPage";
    private static final String STORE_GENERATE_MANIFEST = "JarManifestWizardPage.GENERATE_MANIFEST";
    private static final String STORE_SAVE_MANIFEST = "JarManifestWizardPage.SAVE_MANIFEST";
    private static final String STORE_REUSE_MANIFEST = "JarManifestWizardPage.REUSE_MANIFEST";
    private static final String STORE_MANIFEST_LOCATION = "JarManifestWizardPage.MANIFEST_LOCATION";
    private static final String STORE_SEAL_JAR = "JarManifestWizardPage.SEAL_JAR";

    public JarManifestWizardPage(JarPackageData jarPackage) {
        super(PAGE_NAME);
        this.setTitle(JarPackagerMessages.JarManifestWizardPage_title);
        this.setDescription(JarPackagerMessages.JarManifestWizardPage_description);
        this.fJarPackage = jarPackage;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createLabel(composite, JarPackagerMessages.JarManifestWizardPage_manifestSource_label, false);
        this.createManifestGroup(composite);
        this.createSpacer(composite);
        this.fSealingHeaderLabel = this.createLabel(composite, JarPackagerMessages.JarManifestWizardPage_sealingHeader_label, false);
        this.createSealingGroup(composite);
        this.createSpacer(composite);
        this.fMainClassHeaderLabel = this.createLabel(composite, JarPackagerMessages.JarManifestWizardPage_mainClassHeader_label, false);
        this.createMainClassGroup(composite);
        this.setEqualButtonSizes();
        this.restoreWidgetValues();
        this.setControl((Control)composite);
        this.update();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.jar_manifest_wizard_page_context");
    }

    protected void createManifestGroup(Composite parent) {
        this.fManifestGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.fManifestGroup.setLayout((Layout)layout);
        this.fManifestGroup.setLayoutData((Object)new GridData(784));
        this.fGenerateManifestRadioButton = new Button(this.fManifestGroup, 16400);
        this.fGenerateManifestRadioButton.setText(JarPackagerMessages.JarManifestWizardPage_genetateManifest_text);
        this.fGenerateManifestRadioButton.addListener(13, (Listener)this.fUntypedListener);
        Composite saveOptions = new Composite(this.fManifestGroup, 0);
        GridLayout saveOptionsLayout = new GridLayout();
        saveOptionsLayout.marginWidth = 0;
        saveOptions.setLayout((Layout)saveOptionsLayout);
        GridData data = new GridData(784);
        data.horizontalIndent = LayoutUtil.getIndent();
        saveOptions.setLayoutData((Object)data);
        this.fSaveManifestCheckbox = new Button(saveOptions, 16416);
        this.fSaveManifestCheckbox.setText(JarPackagerMessages.JarManifestWizardPage_saveManifest_text);
        this.fSaveManifestCheckbox.addListener(4, (Listener)this.fUntypedListener);
        this.fReuseManifestCheckbox = new Button(saveOptions, 16416);
        this.fReuseManifestCheckbox.setText(JarPackagerMessages.JarManifestWizardPage_reuseManifest_text);
        this.fReuseManifestCheckbox.addListener(4, (Listener)this.fUntypedListener);
        this.createNewManifestFileGroup(saveOptions);
        this.fUseManifestRadioButton = new Button(this.fManifestGroup, 16400);
        this.fUseManifestRadioButton.setText(JarPackagerMessages.JarManifestWizardPage_useManifest_text);
        this.fUseManifestRadioButton.setLayoutData((Object)new GridData(768));
        Composite existingManifestGroup = new Composite(this.fManifestGroup, 0);
        GridLayout existingManifestLayout = new GridLayout();
        existingManifestLayout.marginWidth = 0;
        existingManifestGroup.setLayout((Layout)existingManifestLayout);
        data = new GridData(784);
        data.horizontalIndent = LayoutUtil.getIndent();
        existingManifestGroup.setLayoutData((Object)data);
        this.createManifestFileGroup(existingManifestGroup);
    }

    protected void createNewManifestFileGroup(Composite parent) {
        Composite manifestFileGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.numColumns = 3;
        manifestFileGroup.setLayout((Layout)layout);
        manifestFileGroup.setLayoutData((Object)new GridData(784));
        this.fNewManifestFileLabel = new Label(manifestFileGroup, 0);
        this.fNewManifestFileLabel.setText(JarPackagerMessages.JarManifestWizardPage_newManifestFile_text);
        this.fNewManifestFileText = new Text(manifestFileGroup, 2052);
        this.fNewManifestFileText.addListener(24, (Listener)this.fUntypedListener);
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(40);
        this.fNewManifestFileText.setLayoutData((Object)data);
        this.fNewManifestFileBrowseButton = new Button(manifestFileGroup, 8);
        this.fNewManifestFileBrowseButton.setText(JarPackagerMessages.JarManifestWizardPage_newManifestFileBrowseButton_text);
        this.fNewManifestFileBrowseButton.setLayoutData((Object)new GridData(256));
        this.fNewManifestFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JarManifestWizardPage.this.handleNewManifestFileBrowseButtonPressed();
            }
        });
    }

    protected void createManifestFileGroup(Composite parent) {
        Composite manifestFileGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        manifestFileGroup.setLayout((Layout)layout);
        manifestFileGroup.setLayoutData((Object)new GridData(784));
        this.fManifestFileLabel = new Label(manifestFileGroup, 0);
        this.fManifestFileLabel.setText(JarPackagerMessages.JarManifestWizardPage_manifestFile_text);
        this.fManifestFileText = new Text(manifestFileGroup, 2052);
        this.fManifestFileText.addListener(24, (Listener)this.fUntypedListener);
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(40);
        this.fManifestFileText.setLayoutData((Object)data);
        this.fManifestFileBrowseButton = new Button(manifestFileGroup, 8);
        this.fManifestFileBrowseButton.setText(JarPackagerMessages.JarManifestWizardPage_manifestFileBrowse_text);
        this.fManifestFileBrowseButton.setLayoutData((Object)new GridData(256));
        this.fManifestFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JarManifestWizardPage.this.handleManifestFileBrowseButtonPressed();
            }
        });
    }

    protected void createSealingGroup(Composite parent) {
        Composite sealingGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing += 3;
        sealingGroup.setLayout((Layout)layout);
        sealingGroup.setLayoutData((Object)new GridData(272));
        this.createSealJarGroup(sealingGroup);
        this.createSealPackagesGroup(sealingGroup);
    }

    protected void createSealJarGroup(Composite sealGroup) {
        this.fSealJarRadioButton = new Button(sealGroup, 16);
        this.fSealJarRadioButton.setText(JarPackagerMessages.JarManifestWizardPage_sealJar_text);
        this.fSealJarRadioButton.addListener(13, (Listener)this.fUntypedListener);
        this.fSealJarLabel = new Label(sealGroup, 131072);
        this.fSealJarLabel.setLayoutData((Object)new GridData(768));
        this.fSealJarLabel.setText("");
        this.fUnSealedPackagesDetailsButton = new Button(sealGroup, 8);
        this.fUnSealedPackagesDetailsButton.setLayoutData((Object)new GridData(256));
        this.fUnSealedPackagesDetailsButton.setText(JarPackagerMessages.JarManifestWizardPage_unsealPackagesButton_text);
        this.fUnSealedPackagesDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JarManifestWizardPage.this.handleUnSealPackagesDetailsButtonPressed();
            }
        });
    }

    protected void createSealPackagesGroup(Composite sealGroup) {
        this.fSealPackagesRadioButton = new Button(sealGroup, 16);
        this.fSealPackagesRadioButton.setText(JarPackagerMessages.JarManifestWizardPage_sealPackagesButton_text);
        this.fSealPackagesLabel = new Label(sealGroup, 131072);
        this.fSealPackagesLabel.setLayoutData((Object)new GridData(768));
        this.fSealPackagesLabel.setText("");
        this.fSealedPackagesDetailsButton = new Button(sealGroup, 8);
        this.fSealedPackagesDetailsButton.setLayoutData((Object)new GridData(256));
        this.fSealedPackagesDetailsButton.setText(JarPackagerMessages.JarManifestWizardPage_sealedPackagesDetailsButton_text);
        this.fSealedPackagesDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JarManifestWizardPage.this.handleSealPackagesDetailsButtonPressed();
            }
        });
    }

    protected void createMainClassGroup(Composite parent) {
        Composite mainClassGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        mainClassGroup.setLayout((Layout)layout);
        mainClassGroup.setLayoutData((Object)new GridData(272));
        this.fMainClassLabel = new Label(mainClassGroup, 0);
        this.fMainClassLabel.setText(JarPackagerMessages.JarManifestWizardPage_mainClass_label);
        this.fMainClassText = new Text(mainClassGroup, 2052);
        this.fMainClassText.addListener(24, (Listener)this.fUntypedListener);
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(40);
        this.fMainClassText.setLayoutData((Object)data);
        this.fMainClassText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                JarManifestWizardPage.this.fJarPackage.setManifestMainClass(JarManifestWizardPage.this.findMainMethodByName(JarManifestWizardPage.this.fMainClassText.getText()));
                JarManifestWizardPage.this.update();
            }
        });
        this.fMainClassBrowseButton = new Button(mainClassGroup, 8);
        this.fMainClassBrowseButton.setText(JarPackagerMessages.JarManifestWizardPage_mainClassBrowseButton_text);
        this.fMainClassBrowseButton.setLayoutData((Object)new GridData(256));
        this.fMainClassBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JarManifestWizardPage.this.handleMainClassBrowseButtonPressed();
            }
        });
    }

    private void update() {
        this.updateModel();
        this.updateEnableState();
        this.updatePageCompletion();
    }

    protected void handleNewManifestFileBrowseButtonPressed() {
        SaveAsDialog dialog = new SaveAsDialog(this.getContainer().getShell());
        dialog.create();
        dialog.getShell().setText(JarPackagerMessages.JarManifestWizardPage_saveAsDialog_title);
        dialog.setMessage(JarPackagerMessages.JarManifestWizardPage_saveAsDialog_message);
        dialog.setOriginalFile(this.createFileHandle(this.fJarPackage.getManifestLocation()));
        if (dialog.open() == 0) {
            this.fJarPackage.setManifestLocation(dialog.getResult());
            this.fNewManifestFileText.setText(dialog.getResult().toString());
        }
    }

    protected void handleManifestFileBrowseButtonPressed() {
        ElementTreeSelectionDialog dialog = this.createWorkspaceFileSelectionDialog(JarPackagerMessages.JarManifestWizardPage_manifestSelectionDialog_title, JarPackagerMessages.JarManifestWizardPage_manifestSelectionDialog_message);
        if (this.fJarPackage.isManifestAccessible()) {
            dialog.setInitialSelections((Object[])new IResource[]{this.fJarPackage.getManifestFile()});
        }
        if (dialog.open() == 0) {
            Object[] resources = dialog.getResult();
            if (resources.length != 1) {
                this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_onlyOneManifestMustBeSelected);
            } else {
                this.setErrorMessage("");
                this.fJarPackage.setManifestLocation(((IResource)resources[0]).getFullPath());
                this.fManifestFileText.setText(this.fJarPackage.getManifestLocation().toString());
            }
        }
    }

    private IType findMainMethodByName(String name) {
        if (this.fMainTypes == null) {
            List<IResource> resources = JarPackagerUtil.asResources(this.fJarPackage.getElements());
            if (resources == null) {
                this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_noResourceSelected);
                return null;
            }
            IJavaSearchScope searchScope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(resources.toArray(new IResource[resources.size()]), true);
            MainMethodSearchEngine engine = new MainMethodSearchEngine();
            try {
                this.fMainTypes = engine.searchMainMethods((IRunnableContext)this.getContainer(), searchScope, 0);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        int i = 0;
        while (i < this.fMainTypes.length) {
            if (this.fMainTypes[i].getFullyQualifiedName().equals(name)) {
                return this.fMainTypes[i];
            }
            ++i;
        }
        return null;
    }

    protected void handleMainClassBrowseButtonPressed() {
        List<IResource> resources = JarPackagerUtil.asResources(this.fJarPackage.getElements());
        if (resources == null) {
            this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_noResourceSelected);
            return;
        }
        IJavaSearchScope searchScope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(resources.toArray(new IResource[resources.size()]), true);
        SelectionDialog dialog = JavaUI.createMainTypeDialog(this.getContainer().getShell(), (IRunnableContext)this.getContainer(), searchScope, 0, false, "");
        dialog.setTitle(JarPackagerMessages.JarManifestWizardPage_mainTypeSelectionDialog_title);
        dialog.setMessage(JarPackagerMessages.JarManifestWizardPage_mainTypeSelectionDialog_message);
        if (this.fJarPackage.getManifestMainClass() != null) {
            dialog.setInitialSelections(new Object[]{this.fJarPackage.getManifestMainClass()});
        }
        if (dialog.open() == 0) {
            this.fJarPackage.setManifestMainClass((IType)dialog.getResult()[0]);
            this.fMainClassText.setText(JarPackagerUtil.getMainClassName(this.fJarPackage));
        } else if (!this.fJarPackage.isMainClassValid((IRunnableContext)this.getContainer())) {
            this.fJarPackage.setManifestMainClass(null);
            this.fMainClassText.setText(JarPackagerUtil.getMainClassName(this.fJarPackage));
        }
    }

    protected void handleSealPackagesDetailsButtonPressed() {
        SelectionDialog dialog = this.createPackageDialog(this.getPackagesForSelectedResources());
        dialog.setTitle(JarPackagerMessages.JarManifestWizardPage_sealedPackagesSelectionDialog_title);
        dialog.setMessage(JarPackagerMessages.JarManifestWizardPage_sealedPackagesSelectionDialog_message);
        dialog.setInitialSelections((Object[])this.fJarPackage.getPackagesToSeal());
        if (dialog.open() == 0) {
            this.fJarPackage.setPackagesToSeal(this.getPackagesFromDialog(dialog));
        }
        this.updateSealingInfo();
    }

    protected void handleUnSealPackagesDetailsButtonPressed() {
        SelectionDialog dialog = this.createPackageDialog(this.getPackagesForSelectedResources());
        dialog.setTitle(JarPackagerMessages.JarManifestWizardPage_unsealedPackagesSelectionDialog_title);
        dialog.setMessage(JarPackagerMessages.JarManifestWizardPage_unsealedPackagesSelectionDialog_message);
        dialog.setInitialSelections((Object[])this.fJarPackage.getPackagesToUnseal());
        if (dialog.open() == 0) {
            this.fJarPackage.setPackagesToUnseal(this.getPackagesFromDialog(dialog));
        }
        this.updateSealingInfo();
    }

    protected void updateEnableState() {
        boolean generate = this.fGenerateManifestRadioButton.getSelection();
        boolean save = generate && this.fSaveManifestCheckbox.getSelection();
        this.fSaveManifestCheckbox.setEnabled(generate);
        this.fReuseManifestCheckbox.setEnabled(this.fJarPackage.isDescriptionSaved() && save);
        this.fNewManifestFileText.setEnabled(save);
        this.fNewManifestFileLabel.setEnabled(save);
        this.fNewManifestFileBrowseButton.setEnabled(save);
        this.fManifestFileText.setEnabled(!generate);
        this.fManifestFileLabel.setEnabled(!generate);
        this.fManifestFileBrowseButton.setEnabled(!generate);
        this.fSealingHeaderLabel.setEnabled(generate);
        boolean sealState = this.fSealJarRadioButton.getSelection();
        this.fSealJarRadioButton.setEnabled(generate);
        this.fSealJarLabel.setEnabled(generate);
        this.fUnSealedPackagesDetailsButton.setEnabled(sealState && generate);
        this.fSealPackagesRadioButton.setEnabled(generate);
        this.fSealPackagesLabel.setEnabled(generate);
        this.fSealedPackagesDetailsButton.setEnabled(!sealState && generate);
        this.fMainClassHeaderLabel.setEnabled(generate);
        this.fMainClassLabel.setEnabled(generate);
        this.fMainClassText.setEnabled(generate);
        this.fMainClassBrowseButton.setEnabled(generate);
        this.updateSealingInfo();
    }

    protected void updateSealingInfo() {
        if (this.fJarPackage.isJarSealed()) {
            this.fSealPackagesLabel.setText("");
            int i = this.fJarPackage.getPackagesToUnseal().length;
            if (i == 0) {
                this.fSealJarLabel.setText(JarPackagerMessages.JarManifestWizardPage_jarSealed);
            } else if (i == 1) {
                this.fSealJarLabel.setText(JarPackagerMessages.JarManifestWizardPage_jarSealedExceptOne);
            } else {
                this.fSealJarLabel.setText(Messages.format(JarPackagerMessages.JarManifestWizardPage_jarSealedExceptSome, new Integer(i)));
            }
        } else {
            this.fSealJarLabel.setText("");
            int i = this.fJarPackage.getPackagesToSeal().length;
            if (i == 0) {
                this.fSealPackagesLabel.setText(JarPackagerMessages.JarManifestWizardPage_nothingSealed);
            } else if (i == 1) {
                this.fSealPackagesLabel.setText(JarPackagerMessages.JarManifestWizardPage_onePackageSealed);
            } else {
                this.fSealPackagesLabel.setText(Messages.format(JarPackagerMessages.JarManifestWizardPage_somePackagesSealed, new Integer(i)));
            }
        }
    }

    public boolean isPageComplete() {
        boolean isPageComplete = true;
        this.setMessage(null);
        if (!this.fJarPackage.areGeneratedFilesExported()) {
            return true;
        }
        if (this.fJarPackage.isManifestGenerated() && this.fJarPackage.isManifestSaved()) {
            if (this.fJarPackage.getManifestLocation().toString().length() == 0) {
                isPageComplete = false;
            } else {
                IPath location = this.fJarPackage.getManifestLocation();
                if (!location.toString().startsWith("/")) {
                    this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_manifestPathMustBeAbsolute);
                    return false;
                }
                IResource resource = this.findResource(location);
                if (resource != null && resource.getType() != 1) {
                    this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_manifestMustNotBeExistingContainer);
                    return false;
                }
                resource = this.findResource(location.removeLastSegments(1));
                if (resource == null || resource.getType() == 1) {
                    this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_manifestContainerDoesNotExist);
                    return false;
                }
            }
        }
        if (!this.fJarPackage.isManifestGenerated()) {
            if (this.fJarPackage.isManifestAccessible()) {
                Manifest manifest = null;
                try {
                    manifest = this.fJarPackage.getManifestProvider().create(this.fJarPackage);
                }
                catch (CoreException coreException) {}
                if (manifest != null && manifest.getMainAttributes().getValue(Attributes.Name.MANIFEST_VERSION) == null) {
                    this.setMessage(JarPackagerMessages.JarManifestWizardPage_warning_noManifestVersion, 2);
                }
            } else {
                if (this.fJarPackage.getManifestLocation().toString().length() == 0) {
                    this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_noManifestFile);
                } else {
                    this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_invalidManifestFile);
                }
                return false;
            }
        }
        Set<IJavaElement> selectedPackages = this.getPackagesForSelectedResources();
        if (this.fJarPackage.isJarSealed() && !selectedPackages.containsAll(Arrays.asList(this.fJarPackage.getPackagesToUnseal()))) {
            this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_unsealedPackagesNotInSelection);
            return false;
        }
        if (!this.fJarPackage.isJarSealed() && !selectedPackages.containsAll(Arrays.asList(this.fJarPackage.getPackagesToSeal()))) {
            this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_sealedPackagesNotInSelection);
            return false;
        }
        if (!this.fJarPackage.isMainClassValid((IRunnableContext)this.getContainer()) || this.fJarPackage.getManifestMainClass() == null && this.fMainClassText.getText().length() > 0) {
            this.setErrorMessage(JarPackagerMessages.JarManifestWizardPage_error_invalidMainClass);
            return false;
        }
        this.setErrorMessage(null);
        return isPageComplete;
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        this.fMainTypes = null;
        this.updateEnableState();
        if (this.getContainer() != null) {
            this.updatePageCompletion();
        }
    }

    @Override
    public void finish() {
        this.saveWidgetValues();
    }

    public final void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_GENERATE_MANIFEST, this.fJarPackage.isManifestGenerated());
            settings.put(STORE_SAVE_MANIFEST, this.fJarPackage.isManifestSaved());
            settings.put(STORE_REUSE_MANIFEST, this.fJarPackage.isManifestReused());
            settings.put(STORE_MANIFEST_LOCATION, this.fJarPackage.getManifestLocation().toString());
            settings.put(STORE_SEAL_JAR, this.fJarPackage.isJarSealed());
        }
        this.internalSaveWidgetValues();
    }

    protected void internalSaveWidgetValues() {
    }

    protected void restoreWidgetValues() {
        if (!((JarPackageWizard)this.getWizard()).isInitializingFromJarPackage()) {
            this.initializeJarPackage();
        }
        if (this.fJarPackage.isManifestGenerated()) {
            this.fGenerateManifestRadioButton.setSelection(true);
        } else {
            this.fUseManifestRadioButton.setSelection(true);
        }
        this.fSaveManifestCheckbox.setSelection(this.fJarPackage.isManifestSaved());
        this.fReuseManifestCheckbox.setSelection(this.fJarPackage.isManifestReused());
        this.fManifestFileText.setText(this.fJarPackage.getManifestLocation().toString());
        this.fNewManifestFileText.setText(this.fJarPackage.getManifestLocation().toString());
        if (this.fJarPackage.isJarSealed()) {
            this.fSealJarRadioButton.setSelection(true);
        } else {
            this.fSealPackagesRadioButton.setSelection(true);
        }
        this.fMainClassText.setText(JarPackagerUtil.getMainClassName(this.fJarPackage));
    }

    protected void initializeJarPackage() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fJarPackage.setGenerateManifest(settings.getBoolean(STORE_GENERATE_MANIFEST));
            this.fJarPackage.setSaveManifest(settings.getBoolean(STORE_SAVE_MANIFEST));
            this.fJarPackage.setReuseManifest(settings.getBoolean(STORE_REUSE_MANIFEST));
            String pathStr = settings.get(STORE_MANIFEST_LOCATION);
            if (pathStr == null) {
                pathStr = "";
            }
            this.fJarPackage.setManifestLocation((IPath)new Path(pathStr));
            this.fJarPackage.setSealJar(settings.getBoolean(STORE_SEAL_JAR));
        }
    }

    protected void updateModel() {
        if (this.getControl() == null) {
            return;
        }
        this.fJarPackage.setGenerateManifest(this.fGenerateManifestRadioButton.getSelection());
        this.fJarPackage.setSaveManifest(this.fSaveManifestCheckbox.getSelection());
        this.fJarPackage.setReuseManifest(this.fJarPackage.isManifestSaved() && this.fReuseManifestCheckbox.getSelection());
        String path = this.fJarPackage.isManifestGenerated() ? this.fNewManifestFileText.getText() : this.fManifestFileText.getText();
        if (path == null) {
            path = "";
        }
        this.fJarPackage.setManifestLocation((IPath)new Path(path));
        this.fJarPackage.setSealJar(this.fSealJarRadioButton.getSelection());
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.isPageComplete();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setErrorMessage(null);
        }
    }

    protected IFile createFileHandle(IPath filePath) {
        if (filePath.isValidPath(filePath.toString()) && filePath.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFile(filePath);
        }
        return null;
    }

    protected Label createLabel(Composite parent, String text, boolean bold) {
        Label label = new Label(parent, 0);
        if (bold) {
            label.setFont(JFaceResources.getBannerFont());
        }
        label.setText(text);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected void setSize(Control control, int width, int height) {
        GridData gd = new GridData(3);
        gd.widthHint = width;
        gd.heightHint = height;
        control.setLayoutData((Object)gd);
    }

    protected void setEqualButtonSizes() {
        int width = SWTUtil.getButtonWidthHint(this.fManifestFileBrowseButton);
        int width2 = SWTUtil.getButtonWidthHint(this.fNewManifestFileBrowseButton);
        width = Math.max(width, width2);
        width2 = SWTUtil.getButtonWidthHint(this.fSealedPackagesDetailsButton);
        width = Math.max(width, width2);
        width2 = SWTUtil.getButtonWidthHint(this.fUnSealedPackagesDetailsButton);
        width = Math.max(width, width2);
        width2 = SWTUtil.getButtonWidthHint(this.fMainClassBrowseButton);
        width = Math.max(width, width2);
        this.setSize((Control)this.fManifestFileBrowseButton, width, -1);
        this.setSize((Control)this.fNewManifestFileBrowseButton, width, -1);
        this.setSize((Control)this.fSealedPackagesDetailsButton, width, -1);
        this.setSize((Control)this.fUnSealedPackagesDetailsButton, width, -1);
        this.setSize((Control)this.fMainClassBrowseButton, width, -1);
    }

    protected void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    protected IResource findResource(IPath path) {
        IWorkspace workspace = JavaPlugin.getWorkspace();
        IStatus result = workspace.validatePath(path.toString(), 15);
        if (result.isOK() && workspace.getRoot().exists(path)) {
            return workspace.getRoot().findMember(path);
        }
        return null;
    }

    protected IPath getPathFromString(String text) {
        return new Path(text).makeAbsolute();
    }

    protected SelectionDialog createPackageDialog(Set<IJavaElement> packageFragments) {
        ArrayList<IPackageFragment> packages = new ArrayList<IPackageFragment>(packageFragments.size());
        for (IPackageFragment iPackageFragment : packageFragments) {
            int kind;
            boolean containsJavaElements = false;
            try {
                kind = iPackageFragment.getKind();
                containsJavaElements = iPackageFragment.getChildren().length > 0;
            }
            catch (JavaModelException ex) {
                ExceptionHandler.handle((CoreException)((Object)ex), this.getContainer().getShell(), JarPackagerMessages.JarManifestWizardPage_error_jarPackageWizardError_title, Messages.format(JarPackagerMessages.JarManifestWizardPage_error_jarPackageWizardError_message, JavaElementLabels.getElementLabel((IJavaElement)iPackageFragment, JavaElementLabels.ALL_DEFAULT)));
                continue;
            }
            if (kind == 2 || !containsJavaElements) continue;
            packages.add(iPackageFragment);
        }
        StandardJavaElementContentProvider cp = new StandardJavaElementContentProvider(){

            public boolean hasChildren(Object element) {
                return !(element instanceof IPackageFragment) && super.hasChildren(element);
            }
        };
        DecoratingLabelProvider decoratingLabelProvider = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (ILabelDecorator)new ProblemsLabelDecorator(null));
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getContainer().getShell(), (ILabelProvider)decoratingLabelProvider, (ITreeContentProvider)cp);
        dialog.setDoubleClickSelects(false);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot()));
        dialog.addFilter((ViewerFilter)new EmptyInnerPackageFilter());
        dialog.addFilter((ViewerFilter)new LibraryFilter());
        dialog.addFilter((ViewerFilter)new SealPackagesFilter(packages));
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                StatusInfo res = new StatusInfo();
                int i = 0;
                while (i < selection.length) {
                    if (!(selection[i] instanceof IPackageFragment)) {
                        res.setError(JarPackagerMessages.JarManifestWizardPage_error_mustContainPackages);
                        return res;
                    }
                    ++i;
                }
                res.setOK();
                return res;
            }
        });
        return dialog;
    }

    protected IPackageFragment[] getPackagesFromDialog(SelectionDialog dialog) {
        if (dialog.getReturnCode() == 0 && dialog.getResult().length > 0) {
            return Arrays.asList(dialog.getResult()).toArray(new IPackageFragment[dialog.getResult().length]);
        }
        return new IPackageFragment[0];
    }

    protected ElementTreeSelectionDialog createWorkspaceFileSelectionDialog(String title, String message) {
        int labelFlags = 272;
        DecoratingLabelProvider provider = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(labelFlags), (ILabelDecorator)new ProblemsLabelDecorator(null));
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)provider, (ITreeContentProvider)new StandardJavaElementContentProvider());
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setAllowMultiple(false);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                StatusInfo res = new StatusInfo();
                if (selection.length == 1 && selection[0] instanceof IFile) {
                    res.setOK();
                } else {
                    res.setError("");
                }
                return res;
            }
        });
        dialog.addFilter((ViewerFilter)new EmptyInnerPackageFilter());
        dialog.addFilter((ViewerFilter)new LibraryFilter());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setStatusLineAboveButtons(true);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot()));
        return dialog;
    }

    private Set<IJavaElement> getPackagesForSelectedResources() {
        HashSet<IJavaElement> packages = new HashSet<IJavaElement>();
        int n = this.fJarPackage.getElements().length;
        int i = 0;
        while (i < n) {
            Object element = this.fJarPackage.getElements()[i];
            if (element instanceof ICompilationUnit) {
                packages.add(((ICompilationUnit)element).getParent());
            }
            ++i;
        }
        return packages;
    }

    private class UntypedListener
    implements Listener {
        private UntypedListener() {
        }

        public void handleEvent(Event e) {
            if (JarManifestWizardPage.this.getControl() == null) {
                return;
            }
            JarManifestWizardPage.this.update();
        }
    }
}

