/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.scm.spi;

import java.io.File;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.scm.MavenProjectScmInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScmHandler
implements Comparable<ScmHandler>,
IExecutableExtension {
    private static final Logger log = LoggerFactory.getLogger(ScmHandler.class);
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_PRIORITY = "priority";
    private String type;
    private int priority;

    public String getType() {
        return this.type;
    }

    public int getPriority() {
        return this.priority;
    }

    public InputStream open(String url, String revision) throws CoreException {
        return null;
    }

    public abstract void checkoutProject(MavenProjectScmInfo var1, File var2, IProgressMonitor var3) throws CoreException, InterruptedException;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        String handlerClass = config.getAttribute(propertyName);
        String type = config.getAttribute(ATTR_TYPE);
        String priority = config.getAttribute(ATTR_PRIORITY);
        this.type = type;
        if (priority != null) {
            try {
                this.priority = Integer.parseInt(priority);
            }
            catch (Exception ex) {
                log.error("Unable to parse priority for " + handlerClass, (Throwable)ex);
            }
        }
    }

    @Override
    public int compareTo(ScmHandler o) {
        if (o != null) {
            ScmHandler handler = o;
            int res = this.getType().compareTo(handler.getType());
            if (res == 0) {
                res = this.getPriority() - handler.getPriority();
            }
            return res;
        }
        return -1;
    }

    public int hashCode() {
        int result = 31 + this.priority;
        return 31 * result + (this.type == null ? 0 : this.type.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScmHandler other = (ScmHandler)obj;
        if (this.priority != other.priority) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

