/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.core.jaxrslibraryregistry.internal;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.ws.jaxrs.core.internal.JAXRSCorePlugin;
import org.eclipse.jst.ws.jaxrs.core.internal.Messages;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.ArchiveFile;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.JAXRSLibrary;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.JAXRSLibraryRegistryFactory;
import org.eclipse.jst.ws.jaxrs.core.internal.jaxrsibraryregistry.PluginProvidedJAXRSLibrary;
import org.eclipse.jst.ws.jaxrs.core.jaxrslibraryregistry.internal.InvalidArchiveFilesCreationException;
import org.eclipse.jst.ws.jaxrs.core.jaxrslibraryregistry.internal.JAXRSLibraryArchiveFilesDelegate;
import org.eclipse.osgi.util.NLS;

public final class PluginProvidedJAXRSLibraryCreationHelper {
    private IConfigurationElement config_element;
    public static final String NAME = "name";
    public static final String IS_IMPL = "isImplementation";
    public static final String DELEGATE = "archiveFilesDelegate";

    public PluginProvidedJAXRSLibraryCreationHelper(IConfigurationElement JAXRSLibrary2) {
        this.config_element = JAXRSLibrary2;
    }

    public JAXRSLibrary create() {
        PluginProvidedJAXRSLibrary newLib = JAXRSLibraryRegistryFactory.eINSTANCE.createPluginProvidedJAXRSLibrary();
        newLib.setPluginID(this.getPluginID());
        newLib.setName(this.config_element.getAttribute(NAME));
        try {
            this.addArchives(newLib);
            return newLib;
        }
        catch (Exception e) {
            JAXRSCorePlugin.log(e, NLS.bind((String)Messages.PluginProvidedJAXRSLibraryCreationHelper_ErrorCreating, (Object)newLib.getName()));
            return null;
        }
    }

    private void addArchives(JAXRSLibrary newLib) throws InvalidArchiveFilesCreationException, CoreException {
        JAXRSLibraryArchiveFilesDelegate jarCol = null;
        ArchiveFile jar = null;
        jarCol = (JAXRSLibraryArchiveFilesDelegate)this.config_element.createExecutableExtension(DELEGATE);
        if (jarCol != null) {
            jarCol.setConfigurationElement(this.config_element);
            Collection jars = jarCol.getArchiveFiles();
            if (jars == null) {
                return;
            }
            for (Object aJar : jars) {
                if (aJar instanceof ArchiveFile) {
                    jar = (ArchiveFile)aJar;
                    if (newLib.containsArchiveFile(jar.getSourceLocation())) continue;
                    newLib.getArchiveFiles().add((Object)jar);
                    continue;
                }
                throw new InvalidArchiveFilesCreationException(NLS.bind((String)Messages.PluginProvidedJAXRSLibraryCreationHelper_ErrorMultipleDefinition, (Object)jar.getSourceLocation(), (Object)this.config_element.getName()));
            }
        }
    }

    private String getPluginID() {
        return this.config_element.getDeclaringExtension().getContributor().getName();
    }
}

