/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.transport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFPacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.JSON;
import org.eclipse.wst.jsdt.debug.transport.packet.Response;

public class CFResponsePacket
extends CFPacket
implements Response {
    public static final String RESPONSE = "response";
    public static final int CODE_OK = 0;
    public static final int CODE_MALFORMED_PACKET = 1;
    public static final int CODE_MALFORMED_REQUEST = 2;
    public static final int CODE_COMMAND_NOT_IMPLEMENTED = 3;
    public static final int CODE_INVALID_ARGUMENTS = 4;
    public static final int CODE_UNEXPECTED_EXCEPTION = 5;
    public static final int CODE_COMMAND_FAILED = 6;
    public static final int CODE_INVALID_STATE = 7;
    static final Map failed_attributes = new HashMap();
    public static final CFResponsePacket FAILED;
    private String command;
    private int requestSequence;
    private Map body = Collections.synchronizedMap(new HashMap());
    private volatile int code = 0;
    private volatile boolean running = true;
    private volatile String message;
    private Map stackTrace = Collections.synchronizedMap(new HashMap());

    static {
        Integer value = new Integer(-1);
        failed_attributes.put("seq", value);
        failed_attributes.put("type", RESPONSE);
        failed_attributes.put("requestSeq", value);
        failed_attributes.put("command", "failed");
        HashMap<String, Object> status = new HashMap<String, Object>();
        failed_attributes.put("status", status);
        status.put("code", new Integer(5));
        status.put("running", Boolean.FALSE);
        status.put("message", "failed");
        FAILED = new CFResponsePacket(failed_attributes);
    }

    public CFResponsePacket(int requestSequence, String command) {
        super(RESPONSE, null);
        if (command == null) {
            throw new IllegalArgumentException("The command string for a response packet cannot be null");
        }
        this.requestSequence = requestSequence;
        this.command = command.intern();
    }

    public CFResponsePacket(Map json) {
        super(json);
        Object status;
        Number packetRequestSeq = (Number)json.get("requestSeq");
        this.requestSequence = packetRequestSeq.intValue();
        String packetCommand = (String)json.get("command");
        this.command = packetCommand.intern();
        Object bdy = json.get("body");
        if (bdy instanceof Map) {
            Map packetBody = (Map)bdy;
            this.body.putAll(packetBody);
        }
        if ((status = json.get("status")) != null && status instanceof Map) {
            Boolean runningObj;
            Map packetStatus = (Map)status;
            Object codeObj = packetStatus.get("code");
            if (codeObj != null) {
                this.code = ((Number)codeObj).intValue();
            }
            if ((runningObj = (Boolean)packetStatus.get("running")) != null) {
                this.running = runningObj;
            }
            this.message = (String)packetStatus.get("message");
            this.stackTrace = (Map)packetStatus.get("stackTrace");
        }
    }

    public int getRequestSequence() {
        return this.requestSequence;
    }

    public String getCommand() {
        return this.command;
    }

    public Map getBody() {
        return this.body;
    }

    public boolean isSuccess() {
        return this.code == 0;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(Map stackTrace) {
        this.stackTrace = stackTrace;
    }

    @Override
    public Map toJSON() {
        Map json = super.toJSON();
        json.put("requestSeq", new Integer(this.requestSequence));
        json.put("command", this.command);
        if (this.body != null && this.body.size() > 0) {
            json.put("body", this.body);
        }
        HashMap<String, Object> status = new HashMap<String, Object>();
        json.put("status", status);
        status.put("running", new Boolean(this.running));
        status.put("code", new Integer(this.code));
        if (this.message != null) {
            status.put("message", this.message);
        }
        if (this.stackTrace != null) {
            status.put("stackTrace", this.stackTrace);
        }
        return json;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Map json = this.toJSON();
        buffer.append("CFResponsePacket: ");
        JSON.writeValue(json, buffer);
        return buffer.toString();
    }
}

