/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.TypeName;
import org.eclipse.jpt.jaxb.core.context.XmlJavaTypeAdapter;
import org.eclipse.jpt.jaxb.core.context.java.JavaType;
import org.eclipse.jpt.jaxb.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaTypeXmlJavaTypeAdapter;
import org.eclipse.jpt.jaxb.core.internal.context.java.JavaTypeName;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRootElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTransientAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTypeAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaType
extends AbstractJavaContextNode
implements JavaType {
    protected final JavaResourceAbstractType resourceType;
    protected final TypeName typeName;
    protected JavaTypeMapping mapping;
    protected boolean defaultMapped = false;
    protected XmlJavaTypeAdapter xmlJavaTypeAdapter;

    protected AbstractJavaType(JaxbContextNode parent, JavaResourceAbstractType resourceType) {
        super(parent);
        this.resourceType = resourceType;
        this.typeName = this.buildTypeName();
        this.initMapping();
        this.initXmlJavaTypeAdapter();
    }

    @Override
    public IResource getResource() {
        return this.resourceType.getFile();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncMapping();
        this.syncXmlJavaTypeAdapter();
    }

    @Override
    public void update() {
        super.update();
        this.updateMapping();
        this.updateXmlJavaTypeAdapter();
    }

    @Override
    public JavaTypeMapping getMapping() {
        return this.mapping;
    }

    protected void setMapping_(JavaTypeMapping newMapping) {
        JavaTypeMapping old = this.mapping;
        this.mapping = newMapping;
        this.firePropertyChanged("mapping", old, newMapping);
    }

    protected abstract JavaTypeMapping buildMapping();

    protected void initMapping() {
        if (this.isDefaultMapped() || this.isSpecifiedMapped()) {
            this.mapping = this.buildMapping();
        }
    }

    protected void syncMapping() {
        if (this.mapping != null) {
            this.mapping.synchronizeWithResourceModel();
        }
    }

    protected void updateMapping() {
        boolean isMapped;
        boolean bl = isMapped = this.isDefaultMapped() || this.isSpecifiedMapped();
        if (isMapped) {
            if (this.mapping != null) {
                this.mapping.update();
            } else {
                this.setMapping_(this.buildMapping());
            }
        } else if (this.mapping != null) {
            this.setMapping_(null);
        }
    }

    protected boolean isSpecifiedMapped() {
        return this.getXmlTypeAnnotation() != null || this.getXmlRootElementAnnotation() != null || this.getXmlTransientAnnotation() != null;
    }

    protected XmlTypeAnnotation getXmlTypeAnnotation() {
        return (XmlTypeAnnotation)this.getJavaResourceType().getAnnotation("javax.xml.bind.annotation.XmlType");
    }

    protected XmlRootElementAnnotation getXmlRootElementAnnotation() {
        return (XmlRootElementAnnotation)this.getJavaResourceType().getAnnotation("javax.xml.bind.annotation.XmlRootElement");
    }

    protected XmlTransientAnnotation getXmlTransientAnnotation() {
        return (XmlTransientAnnotation)this.getJavaResourceType().getAnnotation("javax.xml.bind.annotation.XmlTransient");
    }

    @Override
    public boolean isDefaultMapped() {
        return this.defaultMapped;
    }

    @Override
    public void setDefaultMapped(boolean newValue) {
        boolean old = this.defaultMapped;
        this.defaultMapped = newValue;
        this.firePropertyChanged("defaultMapped", old, newValue);
    }

    @Override
    public XmlJavaTypeAdapter getXmlJavaTypeAdapter() {
        return this.xmlJavaTypeAdapter;
    }

    protected void setXmlJavaTypeAdapter_(XmlJavaTypeAdapter xmlJavaTypeAdapter) {
        XmlJavaTypeAdapter oldXmlJavaTypeAdapter = this.xmlJavaTypeAdapter;
        this.xmlJavaTypeAdapter = xmlJavaTypeAdapter;
        this.firePropertyChanged("xmlJavaTypeAdapter", oldXmlJavaTypeAdapter, xmlJavaTypeAdapter);
    }

    @Override
    public XmlJavaTypeAdapter addXmlJavaTypeAdapter() {
        if (this.xmlJavaTypeAdapter != null) {
            throw new IllegalStateException();
        }
        XmlJavaTypeAdapterAnnotation annotation = (XmlJavaTypeAdapterAnnotation)this.getJavaResourceType().addAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        XmlJavaTypeAdapter xmlJavaTypeAdapter = this.buildXmlJavaTypeAdapter(annotation);
        this.setXmlJavaTypeAdapter_(xmlJavaTypeAdapter);
        return xmlJavaTypeAdapter;
    }

    @Override
    public void removeXmlJavaTypeAdapter() {
        if (this.xmlJavaTypeAdapter == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceType().removeAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        this.setXmlJavaTypeAdapter_(null);
    }

    protected XmlJavaTypeAdapterAnnotation getXmlJavaTypeAdapterAnnotation() {
        if (this.getJavaResourceType().getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter") > 0) {
            return (XmlJavaTypeAdapterAnnotation)this.getJavaResourceType().getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        }
        return null;
    }

    protected XmlJavaTypeAdapter buildXmlJavaTypeAdapter(XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation) {
        return new GenericJavaTypeXmlJavaTypeAdapter(this, xmlJavaTypeAdapterAnnotation);
    }

    protected void initXmlJavaTypeAdapter() {
        XmlJavaTypeAdapterAnnotation annotation = this.getXmlJavaTypeAdapterAnnotation();
        if (annotation != null) {
            this.xmlJavaTypeAdapter = this.buildXmlJavaTypeAdapter(annotation);
        }
    }

    protected void syncXmlJavaTypeAdapter() {
        XmlJavaTypeAdapterAnnotation annotation = this.getXmlJavaTypeAdapterAnnotation();
        if (annotation != null) {
            if (this.xmlJavaTypeAdapter != null) {
                this.xmlJavaTypeAdapter.synchronizeWithResourceModel();
            } else {
                this.setXmlJavaTypeAdapter_(this.buildXmlJavaTypeAdapter(annotation));
            }
        } else {
            this.setXmlJavaTypeAdapter_(null);
        }
    }

    protected void updateXmlJavaTypeAdapter() {
        if (this.xmlJavaTypeAdapter != null) {
            this.xmlJavaTypeAdapter.update();
        }
    }

    @Override
    public JavaResourceAbstractType getJavaResourceType() {
        return this.resourceType;
    }

    protected TypeName buildTypeName() {
        return new JavaTypeName(this.resourceType);
    }

    @Override
    public TypeName getTypeName() {
        return this.typeName;
    }

    @Override
    public JaxbPackage getJaxbPackage() {
        return this.getContextRoot().getPackage(this.getTypeName().getPackageName());
    }

    @Override
    public JaxbPackageInfo getJaxbPackageInfo() {
        JaxbPackage pkg = this.getJaxbPackage();
        return pkg == null ? null : pkg.getPackageInfo();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        if (this.mapping != null && !IterableTools.isEmpty(result = this.mapping.getCompletionProposals(pos))) {
            return result;
        }
        if (this.xmlJavaTypeAdapter != null && !IterableTools.isEmpty(result = this.xmlJavaTypeAdapter.getCompletionProposals(pos))) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getJavaResourceType().getNameTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        IFile file = this.resourceType.getFile();
        if (file != null && file.getProject().equals((Object)this.getJaxbProject().getProject()) && this.resourceType instanceof SourceModel) {
            if (this.mapping != null) {
                this.mapping.validate(messages, reporter);
            }
            if (this.xmlJavaTypeAdapter != null) {
                this.xmlJavaTypeAdapter.validate(messages, reporter);
            }
        }
    }
}

