/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jpt.common.utility.collection.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedQueue<E>
implements Queue<E>,
Cloneable,
Serializable {
    private LinkedList<E> elements;
    private static final long serialVersionUID = 1L;

    public LinkedQueue() {
        this.elements = new LinkedList();
    }

    public LinkedQueue(Collection<? extends E> c) {
        this.elements = new LinkedList<E>(c);
    }

    @Override
    public void enqueue(E element) {
        this.elements.addLast(element);
    }

    @Override
    public E dequeue() {
        return this.elements.removeFirst();
    }

    @Override
    public E peek() {
        return this.elements.getFirst();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public LinkedQueue<E> clone() {
        try {
            LinkedList list;
            LinkedQueue clone = (LinkedQueue)super.clone();
            clone.elements = list = (LinkedList)this.elements.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.elements.toString();
    }
}

