/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.collection.Queue;
import org.eclipse.jpt.common.utility.collection.Stack;
import org.eclipse.jpt.common.utility.internal.collection.ArrayStack;
import org.eclipse.jpt.common.utility.internal.collection.EmptyStack;
import org.eclipse.jpt.common.utility.internal.collection.LinkedStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTools {
    public static <S extends Stack<? super E>, E> S pushAll(S stack, Iterable<? extends E> iterable) {
        return StackTools.pushAll(stack, iterable.iterator());
    }

    public static <S extends Stack<? super E>, E> S pushAll(S stack, Iterator<? extends E> iterator) {
        while (iterator.hasNext()) {
            stack.push(iterator.next());
        }
        return stack;
    }

    public static <S extends Stack<? super E>, E> S pushAll(S stack, E ... array) {
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            stack.push(element);
            ++n2;
        }
        return stack;
    }

    public static <S extends Stack<? super E>, E> S pushAll(S stack, Queue<? extends E> queue) {
        while (!queue.isEmpty()) {
            stack.push(queue.dequeue());
        }
        return stack;
    }

    public static <S extends Stack<? super E>, E> S pushAll(S stack1, Stack<? extends E> stack2) {
        while (!stack2.isEmpty()) {
            stack1.push(stack2.pop());
        }
        return stack1;
    }

    public static <E> ArrayList<E> popAll(Stack<? extends E> stack) {
        return StackTools.popAllTo(stack, new ArrayList());
    }

    public static <C extends Collection<? super E>, E> C popAllTo(Stack<? extends E> stack, C collection) {
        while (!stack.isEmpty()) {
            collection.add(stack.pop());
        }
        return collection;
    }

    public static <Q extends Queue<? super E>, E> Q popAllTo(Stack<? extends E> stack, Q queue) {
        while (!stack.isEmpty()) {
            queue.enqueue(stack.pop());
        }
        return queue;
    }

    public static <S extends Stack<? super E>, E> S popAllTo(Stack<? extends E> stack1, S stack2) {
        while (!stack1.isEmpty()) {
            stack2.push(stack1.pop());
        }
        return stack2;
    }

    public static <E> ArrayStack<E> stack(Iterable<? extends E> iterable) {
        return StackTools.arrayStack(iterable);
    }

    public static <E> ArrayStack<E> stack(Iterable<? extends E> iterable, int iterableSize) {
        return StackTools.arrayStack(iterable, iterableSize);
    }

    public static <E> ArrayStack<E> stack(Iterator<? extends E> iterator) {
        return StackTools.arrayStack(iterator);
    }

    public static <E> ArrayStack<E> stack(Iterator<? extends E> iterator, int iteratorSize) {
        return StackTools.arrayStack(iterator, iteratorSize);
    }

    public static <E> ArrayStack<E> stack(E ... array) {
        return StackTools.arrayStack(array);
    }

    public static <E> ArrayStack<E> arrayStack(Iterable<? extends E> iterable) {
        return StackTools.arrayStack(iterable.iterator());
    }

    public static <E> ArrayStack<E> arrayStack(Iterable<? extends E> iterable, int iterableSize) {
        return StackTools.arrayStack(iterable.iterator(), iterableSize);
    }

    public static <E> ArrayStack<E> arrayStack(Iterator<? extends E> iterator) {
        return StackTools.pushAll(new ArrayStack(), iterator);
    }

    public static <E> ArrayStack<E> arrayStack(Iterator<? extends E> iterator, int iteratorSize) {
        return StackTools.pushAll(new ArrayStack(iteratorSize), iterator);
    }

    public static <E> ArrayStack<E> arrayStack(E ... array) {
        return StackTools.pushAll(new ArrayStack(array.length), array);
    }

    public static <E> LinkedStack<E> linkedStack(Iterable<? extends E> iterable) {
        return StackTools.linkedStack(iterable.iterator());
    }

    public static <E> LinkedStack<E> linkedStack(Iterator<? extends E> iterator) {
        return StackTools.pushAll(new LinkedStack(), iterator);
    }

    public static <E> LinkedStack<E> linkedStack(E ... array) {
        return StackTools.pushAll(new LinkedStack(), array);
    }

    public static <E> Stack<E> emptyStack() {
        return EmptyStack.instance();
    }

    private StackTools() {
        throw new UnsupportedOperationException();
    }
}

