/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.StatefulCommandContext;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.LinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSingleUseQueueingCommandContext<E extends StatefulCommandContext>
implements StatefulCommandContext {
    protected final E commandContext;
    private State state;
    private LinkedQueue<Command> queue = new LinkedQueue();

    protected AbstractSingleUseQueueingCommandContext(E commandContext) {
        if (commandContext == null) {
            throw new NullPointerException();
        }
        this.commandContext = commandContext;
        this.state = State.PRE_START;
    }

    @Override
    public synchronized void start() {
        if (this.state != State.PRE_START) {
            throw this.buildISE();
        }
        this.commandContext.start();
        while (!this.queue.isEmpty()) {
            this.commandContext.execute(this.queue.dequeue());
        }
        this.state = State.ACTIVE;
    }

    @Override
    public void execute(Command command) {
        if (this.commandIsToBeExecuted(command)) {
            this.commandContext.execute(command);
        }
    }

    private synchronized boolean commandIsToBeExecuted(Command command) {
        switch (this.state) {
            case ACTIVE: {
                return true;
            }
            case PRE_START: 
            case SUSPENDED: {
                this.queue.enqueue(command);
                return false;
            }
            case DEAD: {
                return false;
            }
        }
        throw this.buildISE();
    }

    public synchronized void suspend() {
        if (this.state != State.ACTIVE) {
            throw this.buildISE();
        }
        this.state = State.SUSPENDED;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void resume() {
        if (this.state == State.SUSPENDED) ** GOTO lbl4
        throw this.buildISE();
lbl-1000:
        // 1 sources

        {
            this.commandContext.execute(this.queue.dequeue());
lbl4:
            // 2 sources

            ** while (!this.queue.isEmpty())
        }
lbl5:
        // 1 sources

        this.state = State.ACTIVE;
    }

    @Override
    public synchronized void stop() throws InterruptedException {
        switch (this.state) {
            case ACTIVE: {
                break;
            }
            case SUSPENDED: {
                while (!this.queue.isEmpty()) {
                    this.queue.dequeue();
                }
                break;
            }
            default: {
                throw this.buildISE();
            }
        }
        this.commandContext.stop();
        this.state = State.DEAD;
    }

    private IllegalStateException buildISE() {
        return new IllegalStateException(String.valueOf((Object)this.state));
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (Object)this.state);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        PRE_START,
        ACTIVE,
        SUSPENDED,
        DEAD;

    }
}

