/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.reference.SynchronizedObject;

public class RepeatingCommandState {
    private final SynchronizedObject<State> state = new SynchronizedObject<State>(State.STOPPED, this);

    public synchronized void start() {
        switch (this.state.getValue()) {
            case STOPPED: {
                this.state.setValue(State.READY);
                break;
            }
            default: {
                throw this.buildISE();
            }
        }
    }

    public synchronized boolean isReadyToStartExecutionCycle() {
        switch (this.state.getValue()) {
            case STOPPED: {
                return false;
            }
            case READY: {
                this.state.setValue(State.PRE_EXECUTION);
                return true;
            }
            case PRE_EXECUTION: {
                return false;
            }
            case EXECUTING: {
                this.state.setValue(State.REPEAT);
                return false;
            }
            case REPEAT: {
                return false;
            }
            case STOPPING: {
                return false;
            }
        }
        throw this.buildISE();
    }

    public synchronized boolean wasStoppedBeforeFirstExecutionCouldStart() {
        switch (this.state.getValue()) {
            case STOPPED: {
                return true;
            }
            case PRE_EXECUTION: {
                this.state.setValue(State.EXECUTING);
                return false;
            }
        }
        throw this.buildISE();
    }

    public synchronized boolean isRepeat() {
        switch (this.state.getValue()) {
            case STOPPED: 
            case READY: 
            case PRE_EXECUTION: {
                throw this.buildISE();
            }
            case EXECUTING: {
                this.state.setValue(State.READY);
                return false;
            }
            case REPEAT: {
                this.state.setValue(State.EXECUTING);
                return true;
            }
            case STOPPING: {
                this.state.setValue(State.STOPPED);
                return false;
            }
        }
        throw this.buildISE();
    }

    public boolean isQuiesced() {
        return this.state.getValue() != State.REPEAT;
    }

    public synchronized void stop() throws InterruptedException {
        switch (this.state.getValue()) {
            case READY: 
            case PRE_EXECUTION: {
                this.state.setValue(State.STOPPED);
                break;
            }
            case EXECUTING: 
            case REPEAT: {
                this.state.setValue(State.STOPPING);
                this.waitUntilStopped();
                break;
            }
            default: {
                throw this.buildISE();
            }
        }
    }

    private void waitUntilStopped() throws InterruptedException {
        this.state.waitUntilValueIs(State.STOPPED);
    }

    private IllegalStateException buildISE() {
        return new IllegalStateException("state: " + this.state);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.state);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        STOPPED,
        READY,
        PRE_EXECUTION,
        EXECUTING,
        REPEAT,
        STOPPING;

    }
}

