/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.InterruptibleCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalInterruptibleCommand
implements InterruptibleCommand {
    private final ThreadLocal<InterruptibleCommand> threadLocal;
    private final InterruptibleCommand defaultCommand;

    public ThreadLocalInterruptibleCommand(InterruptibleCommand defaultCommand) {
        if (defaultCommand == null) {
            throw new NullPointerException();
        }
        this.defaultCommand = defaultCommand;
        this.threadLocal = this.buildThreadLocal();
    }

    private ThreadLocal<InterruptibleCommand> buildThreadLocal() {
        return new ThreadLocal<InterruptibleCommand>();
    }

    @Override
    public void execute() throws InterruptedException {
        this.get().execute();
    }

    private InterruptibleCommand get() {
        InterruptibleCommand command = this.threadLocal.get();
        return command != null ? command : this.defaultCommand;
    }

    public void set(InterruptibleCommand command) {
        this.threadLocal.set(command);
    }

    public String toString() {
        return this.get().toString();
    }
}

