/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.jdbc.ResultSetRowTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetIterator<E> {
    private final ResultSet resultSet;
    private final ResultSetRowTransformer<? extends E> transformer;
    private E next;
    private boolean done;

    public ResultSetIterator(ResultSet resultSet, ResultSetRowTransformer<? extends E> transformer) throws SQLException {
        if (resultSet == null || transformer == null) {
            throw new NullPointerException();
        }
        this.resultSet = resultSet;
        this.transformer = transformer;
        this.done = false;
        this.next = this.buildNext();
    }

    private E buildNext() throws SQLException {
        if (this.resultSet.next()) {
            return this.transformer.transform(this.resultSet);
        }
        this.resultSet.close();
        this.done = true;
        return null;
    }

    public boolean hasNext() {
        return !this.done;
    }

    public E next() throws SQLException {
        if (this.done) {
            throw new NoSuchElementException();
        }
        E temp = this.next;
        this.next = this.buildNext();
        return temp;
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.resultSet);
    }
}

