/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.exception.DefaultExceptionHandler;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSupport {
    protected final Model source;
    private AspectListenerListPair<?>[] aspectListenerListPairs = EMPTY_ASPECT_LISTENER_LIST_PAIR_ARRAY;
    private static final AspectListenerListPair<?>[] EMPTY_ASPECT_LISTENER_LIST_PAIR_ARRAY = new AspectListenerListPair[0];
    private final ExceptionHandler exceptionHandler;
    protected static final Class<ChangeListener> CHANGE_LISTENER_CLASS = ChangeListener.class;
    protected static final Class<StateChangeListener> STATE_CHANGE_LISTENER_CLASS = StateChangeListener.class;
    protected static final Class<PropertyChangeListener> PROPERTY_CHANGE_LISTENER_CLASS = PropertyChangeListener.class;
    protected static final Class<CollectionChangeListener> COLLECTION_CHANGE_LISTENER_CLASS = CollectionChangeListener.class;
    protected static final Class<ListChangeListener> LIST_CHANGE_LISTENER_CLASS = ListChangeListener.class;

    public ChangeSupport(Model source) {
        this(source, DefaultExceptionHandler.instance());
    }

    public ChangeSupport(Model source, ExceptionHandler exceptionHandler) {
        if (source == null) {
            throw new NullPointerException();
        }
        if (exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.exceptionHandler = exceptionHandler;
    }

    protected synchronized <L extends EventListener> void addListener(Class<L> listenerClass, String aspectName, L listener) {
        ListenerList<L> aspectListenerList = this.getListenerList(listenerClass, aspectName);
        if (aspectListenerList == null) {
            this.aspectListenerListPairs = ArrayTools.add(this.aspectListenerListPairs, new SimpleAspectListenerListPair<L>(listenerClass, aspectName, listener));
        } else {
            aspectListenerList.add(listener);
        }
    }

    protected synchronized <L extends EventListener> void addListener(Class<L> listenerClass, L listener) {
        ListenerList<L> listenerList = this.getListenerList(listenerClass);
        if (listenerList == null) {
            this.aspectListenerListPairs = ArrayTools.add(this.aspectListenerListPairs, new NullAspectListenerListPair<L>(listenerClass, listener));
        } else {
            listenerList.add(listener);
        }
    }

    protected synchronized <L extends EventListener> void removeListener(Class<L> listenerClass, String aspectName, L listener) {
        ListenerList<L> aspectListenerList = this.getListenerList(listenerClass, aspectName);
        if (aspectListenerList == null) {
            throw new IllegalArgumentException("unregistered listener: " + listener);
        }
        aspectListenerList.remove(listener);
    }

    protected synchronized <L extends EventListener> void removeListener(Class<L> listenerClass, L listener) {
        ListenerList<L> listenerList = this.getListenerList(listenerClass);
        if (listenerList == null) {
            throw new IllegalArgumentException("unregistered listener: " + listener);
        }
        listenerList.remove(listener);
    }

    protected <L extends EventListener> ListenerList<L> getListenerList(Class<L> listenerClass, String aspectName) {
        if (aspectName == null) {
            throw new NullPointerException();
        }
        return this.getListenerList_(listenerClass, aspectName);
    }

    protected <L extends EventListener> ListenerList<L> getListenerList(Class<L> listenerClass) {
        return this.getListenerList_(listenerClass, null);
    }

    protected synchronized <L extends EventListener> ListenerList<L> getListenerList_(Class<L> listenerClass, String aspectName) {
        AspectListenerListPair<?>[] aspectListenerListPairArray = this.aspectListenerListPairs;
        int n = this.aspectListenerListPairs.length;
        int n2 = 0;
        while (n2 < n) {
            AspectListenerListPair<?> pair = aspectListenerListPairArray[n2];
            if (pair.matches(listenerClass, aspectName)) {
                ListenerList aspectListenerList = pair.listenerList;
                return aspectListenerList;
            }
            ++n2;
        }
        return null;
    }

    protected <L extends EventListener> boolean hasAnyListeners(Class<L> listenerClass, String aspectName) {
        ListenerList<L> aspectListenerList = this.getListenerList(listenerClass, aspectName);
        if (aspectListenerList != null && !aspectListenerList.isEmpty()) {
            return true;
        }
        return this.hasAnyChangeListeners();
    }

    protected <L extends EventListener> boolean hasNoListeners(Class<L> listenerClass, String aspectName) {
        return !this.hasAnyListeners(listenerClass, aspectName);
    }

    protected <L extends EventListener> boolean hasAnyListeners(Class<L> listenerClass) {
        ListenerList<L> aspectListenerList = this.getListenerList(listenerClass);
        if (aspectListenerList != null && !aspectListenerList.isEmpty()) {
            return true;
        }
        return listenerClass == this.getChangeListenerClass() ? false : this.hasAnyChangeListeners();
    }

    protected <L extends EventListener> boolean hasNoListeners(Class<L> listenerClass) {
        return !this.hasAnyListeners(listenerClass);
    }

    protected <L extends ChangeListener> Class<L> getChangeListenerClass() {
        return CHANGE_LISTENER_CLASS;
    }

    public void addChangeListener(ChangeListener listener) {
        this.addListener(this.getChangeListenerClass(), listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.removeListener(this.getChangeListenerClass(), listener);
    }

    public boolean hasAnyChangeListeners() {
        return this.hasAnyListeners(this.getChangeListenerClass());
    }

    private Iterable<ChangeListener> getChangeListeners() {
        return this.getListenerList(CHANGE_LISTENER_CLASS);
    }

    private boolean hasChangeListener(ChangeListener listener) {
        return IterableTools.contains(this.getChangeListeners(), listener);
    }

    public void addStateChangeListener(StateChangeListener listener) {
        this.addListener(STATE_CHANGE_LISTENER_CLASS, listener);
    }

    public void removeStateChangeListener(StateChangeListener listener) {
        this.removeListener(STATE_CHANGE_LISTENER_CLASS, listener);
    }

    public boolean hasAnyStateChangeListeners() {
        return this.hasAnyListeners(STATE_CHANGE_LISTENER_CLASS);
    }

    private Iterable<StateChangeListener> getStateChangeListeners() {
        return this.getListenerList(STATE_CHANGE_LISTENER_CLASS);
    }

    private boolean hasStateChangeListener(StateChangeListener listener) {
        return IterableTools.contains(this.getStateChangeListeners(), listener);
    }

    public void fireStateChanged(StateChangeEvent event) {
        Iterable<ChangeListener> changeListeners;
        Iterable<StateChangeListener> listeners = this.getStateChangeListeners();
        if (listeners != null) {
            for (StateChangeListener listener : listeners) {
                if (!this.hasStateChangeListener(listener)) continue;
                try {
                    listener.stateChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                try {
                    listener.stateChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public void fireStateChanged() {
        Iterable<ChangeListener> changeListeners;
        StateChangeEvent event = null;
        Iterable<StateChangeListener> listeners = this.getStateChangeListeners();
        if (listeners != null) {
            for (StateChangeListener listener : listeners) {
                if (!this.hasStateChangeListener(listener)) continue;
                if (event == null) {
                    event = new StateChangeEvent(this.source);
                }
                try {
                    listener.stateChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new StateChangeEvent(this.source);
                }
                try {
                    listener.stateChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.addListener(PROPERTY_CHANGE_LISTENER_CLASS, propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.removeListener(PROPERTY_CHANGE_LISTENER_CLASS, propertyName, listener);
    }

    public boolean hasAnyPropertyChangeListeners(String propertyName) {
        return this.hasAnyListeners(PROPERTY_CHANGE_LISTENER_CLASS, propertyName);
    }

    private Iterable<PropertyChangeListener> getPropertyChangeListeners(String propertyName) {
        return this.getListenerList(PROPERTY_CHANGE_LISTENER_CLASS, propertyName);
    }

    private boolean hasPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        return IterableTools.contains(this.getPropertyChangeListeners(propertyName), listener);
    }

    public boolean firePropertyChanged(PropertyChangeEvent event) {
        if (ObjectTools.notEquals(event.getOldValue(), event.getNewValue())) {
            this.firePropertyChanged_(event);
            return true;
        }
        return false;
    }

    protected void firePropertyChanged_(PropertyChangeEvent event) {
        Iterable<ChangeListener> changeListeners;
        String propertyName = event.getPropertyName();
        Iterable<PropertyChangeListener> listeners = this.getPropertyChangeListeners(propertyName);
        if (listeners != null) {
            for (PropertyChangeListener listener : listeners) {
                if (!this.hasPropertyChangeListener(propertyName, listener)) continue;
                try {
                    listener.propertyChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                try {
                    listener.propertyChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        if (ObjectTools.notEquals(oldValue, newValue)) {
            this.firePropertyChanged_(propertyName, oldValue, newValue);
            return true;
        }
        return false;
    }

    protected void firePropertyChanged_(String propertyName, Object oldValue, Object newValue) {
        Iterable<ChangeListener> changeListeners;
        PropertyChangeEvent event = null;
        Iterable<PropertyChangeListener> listeners = this.getPropertyChangeListeners(propertyName);
        if (listeners != null) {
            for (PropertyChangeListener listener : listeners) {
                if (!this.hasPropertyChangeListener(propertyName, listener)) continue;
                if (event == null) {
                    event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
                }
                try {
                    listener.propertyChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
                }
                try {
                    listener.propertyChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean firePropertyChanged(String propertyName, int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.firePropertyChanged_(propertyName, oldValue, newValue);
            return true;
        }
        return false;
    }

    protected void firePropertyChanged_(String propertyName, int oldValue, int newValue) {
        Iterable<ChangeListener> changeListeners;
        PropertyChangeEvent event = null;
        Iterable<PropertyChangeListener> listeners = this.getPropertyChangeListeners(propertyName);
        if (listeners != null) {
            for (PropertyChangeListener listener : listeners) {
                if (!this.hasPropertyChangeListener(propertyName, listener)) continue;
                if (event == null) {
                    event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
                }
                try {
                    listener.propertyChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
                }
                try {
                    listener.propertyChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean firePropertyChanged(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.firePropertyChanged_(propertyName, oldValue, newValue);
            return true;
        }
        return false;
    }

    protected void firePropertyChanged_(String propertyName, boolean oldValue, boolean newValue) {
        Iterable<ChangeListener> changeListeners;
        PropertyChangeEvent event = null;
        Iterable<PropertyChangeListener> listeners = this.getPropertyChangeListeners(propertyName);
        if (listeners != null) {
            for (PropertyChangeListener listener : listeners) {
                if (!this.hasPropertyChangeListener(propertyName, listener)) continue;
                if (event == null) {
                    event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
                }
                try {
                    listener.propertyChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
                }
                try {
                    listener.propertyChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.addListener(COLLECTION_CHANGE_LISTENER_CLASS, collectionName, listener);
    }

    public void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.removeListener(COLLECTION_CHANGE_LISTENER_CLASS, collectionName, listener);
    }

    public boolean hasAnyCollectionChangeListeners(String collectionName) {
        return this.hasAnyListeners(COLLECTION_CHANGE_LISTENER_CLASS, collectionName);
    }

    private Iterable<CollectionChangeListener> getCollectionChangeListeners(String collectionName) {
        return this.getListenerList(COLLECTION_CHANGE_LISTENER_CLASS, collectionName);
    }

    private boolean hasCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        return IterableTools.contains(this.getCollectionChangeListeners(collectionName), listener);
    }

    public boolean fireItemsAdded(CollectionAddEvent event) {
        if (event.getItemsSize() != 0) {
            this.fireItemsAdded_(event);
            return true;
        }
        return false;
    }

    protected void fireItemsAdded_(CollectionAddEvent event) {
        Iterable<ChangeListener> changeListeners;
        String collectionName = event.getCollectionName();
        Iterable<CollectionChangeListener> listeners = this.getCollectionChangeListeners(collectionName);
        if (listeners != null) {
            for (CollectionChangeListener listener : listeners) {
                if (!this.hasCollectionChangeListener(collectionName, listener)) continue;
                try {
                    listener.itemsAdded(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                try {
                    listener.itemsAdded(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean fireItemsAdded(String collectionName, Collection<?> addedItems) {
        if (!addedItems.isEmpty()) {
            this.fireItemsAdded_(collectionName, addedItems);
            return true;
        }
        return false;
    }

    protected void fireItemsAdded_(String collectionName, Collection<?> addedItems) {
        Iterable<ChangeListener> changeListeners;
        CollectionAddEvent event = null;
        Iterable<CollectionChangeListener> listeners = this.getCollectionChangeListeners(collectionName);
        if (listeners != null) {
            for (CollectionChangeListener listener : listeners) {
                if (!this.hasCollectionChangeListener(collectionName, listener)) continue;
                if (event == null) {
                    event = new CollectionAddEvent(this.source, collectionName, addedItems);
                }
                try {
                    listener.itemsAdded(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new CollectionAddEvent(this.source, collectionName, addedItems);
                }
                try {
                    listener.itemsAdded(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public void fireItemAdded(String collectionName, Object addedItem) {
        Iterable<ChangeListener> changeListeners;
        CollectionAddEvent event = null;
        Iterable<CollectionChangeListener> listeners = this.getCollectionChangeListeners(collectionName);
        if (listeners != null) {
            for (CollectionChangeListener listener : listeners) {
                if (!this.hasCollectionChangeListener(collectionName, listener)) continue;
                if (event == null) {
                    event = new CollectionAddEvent(this.source, collectionName, addedItem);
                }
                try {
                    listener.itemsAdded(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new CollectionAddEvent(this.source, collectionName, addedItem);
                }
                try {
                    listener.itemsAdded(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean fireItemsRemoved(CollectionRemoveEvent event) {
        if (event.getItemsSize() != 0) {
            this.fireItemsRemoved_(event);
            return true;
        }
        return false;
    }

    protected void fireItemsRemoved_(CollectionRemoveEvent event) {
        Iterable<ChangeListener> changeListeners;
        String collectionName = event.getCollectionName();
        Iterable<CollectionChangeListener> listeners = this.getCollectionChangeListeners(collectionName);
        if (listeners != null) {
            for (CollectionChangeListener listener : listeners) {
                if (!this.hasCollectionChangeListener(collectionName, listener)) continue;
                try {
                    listener.itemsRemoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                try {
                    listener.itemsRemoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean fireItemsRemoved(String collectionName, Collection<?> removedItems) {
        if (!removedItems.isEmpty()) {
            this.fireItemsRemoved_(collectionName, removedItems);
            return true;
        }
        return false;
    }

    protected void fireItemsRemoved_(String collectionName, Collection<?> removedItems) {
        Iterable<ChangeListener> changeListeners;
        CollectionRemoveEvent event = null;
        Iterable<CollectionChangeListener> listeners = this.getCollectionChangeListeners(collectionName);
        if (listeners != null) {
            for (CollectionChangeListener listener : listeners) {
                if (!this.hasCollectionChangeListener(collectionName, listener)) continue;
                if (event == null) {
                    event = new CollectionRemoveEvent(this.source, collectionName, removedItems);
                }
                try {
                    listener.itemsRemoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new CollectionRemoveEvent(this.source, collectionName, removedItems);
                }
                try {
                    listener.itemsRemoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public void fireItemRemoved(String collectionName, Object removedItem) {
        Iterable<ChangeListener> changeListeners;
        CollectionRemoveEvent event = null;
        Iterable<CollectionChangeListener> listeners = this.getCollectionChangeListeners(collectionName);
        if (listeners != null) {
            for (CollectionChangeListener listener : listeners) {
                if (!this.hasCollectionChangeListener(collectionName, listener)) continue;
                if (event == null) {
                    event = new CollectionRemoveEvent(this.source, collectionName, removedItem);
                }
                try {
                    listener.itemsRemoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new CollectionRemoveEvent(this.source, collectionName, removedItem);
                }
                try {
                    listener.itemsRemoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public void fireCollectionCleared(CollectionClearEvent event) {
        Iterable<ChangeListener> changeListeners;
        String collectionName = event.getCollectionName();
        Iterable<CollectionChangeListener> listeners = this.getCollectionChangeListeners(collectionName);
        if (listeners != null) {
            for (CollectionChangeListener listener : listeners) {
                if (!this.hasCollectionChangeListener(collectionName, listener)) continue;
                try {
                    listener.collectionCleared(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                try {
                    listener.collectionCleared(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public void fireCollectionCleared(String collectionName) {
        Iterable<ChangeListener> changeListeners;
        CollectionClearEvent event = null;
        Iterable<CollectionChangeListener> listeners = this.getCollectionChangeListeners(collectionName);
        if (listeners != null) {
            for (CollectionChangeListener listener : listeners) {
                if (!this.hasCollectionChangeListener(collectionName, listener)) continue;
                if (event == null) {
                    event = new CollectionClearEvent(this.source, collectionName);
                }
                try {
                    listener.collectionCleared(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new CollectionClearEvent(this.source, collectionName);
                }
                try {
                    listener.collectionCleared(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public void fireCollectionChanged(CollectionChangeEvent event) {
        Iterable<ChangeListener> changeListeners;
        String collectionName = event.getCollectionName();
        Iterable<CollectionChangeListener> listeners = this.getCollectionChangeListeners(collectionName);
        if (listeners != null) {
            for (CollectionChangeListener listener : listeners) {
                if (!this.hasCollectionChangeListener(collectionName, listener)) continue;
                try {
                    listener.collectionChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                try {
                    listener.collectionChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public void fireCollectionChanged(String collectionName, Collection<?> collection) {
        Iterable<ChangeListener> changeListeners;
        CollectionChangeEvent event = null;
        Iterable<CollectionChangeListener> listeners = this.getCollectionChangeListeners(collectionName);
        if (listeners != null) {
            for (CollectionChangeListener listener : listeners) {
                if (!this.hasCollectionChangeListener(collectionName, listener)) continue;
                if (event == null) {
                    event = new CollectionChangeEvent(this.source, collectionName, collection);
                }
                try {
                    listener.collectionChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new CollectionChangeEvent(this.source, collectionName, collection);
                }
                try {
                    listener.collectionChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public <E> boolean addItemToCollection(E item, Collection<E> collection, String collectionName) {
        if (collection.add(item)) {
            this.fireItemAdded(collectionName, item);
            return true;
        }
        return false;
    }

    public <E> boolean addItemsToCollection(E[] items, Collection<E> collection, String collectionName) {
        return items.length != 0 && this.addItemsToCollection_(IteratorTools.iterator(items), collection, collectionName);
    }

    public <E> boolean addItemsToCollection(Collection<? extends E> items, Collection<E> collection, String collectionName) {
        return !items.isEmpty() && this.addItemsToCollection_(items.iterator(), collection, collectionName);
    }

    public <E> boolean addItemsToCollection(Iterable<? extends E> items, Collection<E> collection, String collectionName) {
        return this.addItemsToCollection(items.iterator(), collection, collectionName);
    }

    public <E> boolean addItemsToCollection(Iterator<? extends E> items, Collection<E> collection, String collectionName) {
        return items.hasNext() && this.addItemsToCollection_(items, collection, collectionName);
    }

    protected <E> boolean addItemsToCollection_(Iterator<? extends E> items, Collection<E> collection, String collectionName) {
        ArrayList<E> addedItems = null;
        while (items.hasNext()) {
            E item = items.next();
            if (!collection.add(item)) continue;
            if (addedItems == null) {
                addedItems = new ArrayList<E>();
            }
            addedItems.add(item);
        }
        if (addedItems != null) {
            this.fireItemsAdded_(collectionName, addedItems);
            return true;
        }
        return false;
    }

    public boolean removeItemFromCollection(Object item, Collection<?> collection, String collectionName) {
        if (collection.remove(item)) {
            this.fireItemRemoved(collectionName, item);
            return true;
        }
        return false;
    }

    public boolean removeItemsFromCollection(Object[] items, Collection<?> collection, String collectionName) {
        return items.length != 0 && !collection.isEmpty() && this.removeItemsFromCollection_(IteratorTools.iterator(items), collection, collectionName);
    }

    public boolean removeItemsFromCollection(Collection<?> items, Collection<?> collection, String collectionName) {
        return !items.isEmpty() && !collection.isEmpty() && this.removeItemsFromCollection_(items.iterator(), collection, collectionName);
    }

    public boolean removeItemsFromCollection(Iterable<?> items, Collection<?> collection, String collectionName) {
        return this.removeItemsFromCollection(items.iterator(), collection, collectionName);
    }

    public boolean removeItemsFromCollection(Iterator<?> items, Collection<?> collection, String collectionName) {
        return items.hasNext() && !collection.isEmpty() && this.removeItemsFromCollection_(items, collection, collectionName);
    }

    protected boolean removeItemsFromCollection_(Iterator<?> items, Collection<?> collection, String collectionName) {
        HashBag<?> removedItems = CollectionTools.collection(items);
        removedItems.retainAll(collection);
        boolean changed = collection.removeAll(removedItems);
        if (!removedItems.isEmpty()) {
            this.fireItemsRemoved_(collectionName, removedItems);
        }
        return changed;
    }

    public boolean retainItemsInCollection(Object[] items, Collection<?> collection, String collectionName) {
        if (collection.isEmpty()) {
            return false;
        }
        if (items.length == 0) {
            return this.clearCollection_(collection, collectionName);
        }
        return this.retainItemsInCollection_(IteratorTools.iterator(items), collection, collectionName);
    }

    public boolean retainItemsInCollection(Collection<?> items, Collection<?> collection, String collectionName) {
        if (collection.isEmpty()) {
            return false;
        }
        if (items.isEmpty()) {
            return this.clearCollection_(collection, collectionName);
        }
        return this.retainItemsInCollection_(items.iterator(), collection, collectionName);
    }

    public boolean retainItemsInCollection(Iterable<?> items, Collection<?> collection, String collectionName) {
        return this.retainItemsInCollection(items.iterator(), collection, collectionName);
    }

    public boolean retainItemsInCollection(Iterator<?> items, Collection<?> collection, String collectionName) {
        if (collection.isEmpty()) {
            return false;
        }
        if (!items.hasNext()) {
            return this.clearCollection_(collection, collectionName);
        }
        return this.retainItemsInCollection_(items, collection, collectionName);
    }

    protected boolean retainItemsInCollection_(Iterator<?> items, Collection<?> collection, String collectionName) {
        HashBag<?> retainedItems = CollectionTools.collection(items);
        HashBag<?> removedItems = CollectionTools.collection(collection);
        removedItems.removeAll(retainedItems);
        boolean changed = collection.retainAll(retainedItems);
        if (!removedItems.isEmpty()) {
            this.fireItemsRemoved_(collectionName, removedItems);
        }
        return changed;
    }

    public boolean clearCollection(Collection<?> collection, String collectionName) {
        if (collection.isEmpty()) {
            return false;
        }
        return this.clearCollection_(collection, collectionName);
    }

    protected boolean clearCollection_(Collection<?> collection, String collectionName) {
        collection.clear();
        this.fireCollectionCleared(collectionName);
        return true;
    }

    public <E> boolean synchronizeCollection(Collection<E> newCollection, Collection<E> collection, String collectionName) {
        if (newCollection.isEmpty()) {
            return this.clearCollection(collection, collectionName);
        }
        if (collection.isEmpty()) {
            return this.addItemsToCollection_(newCollection.iterator(), collection, collectionName);
        }
        return this.synchronizeCollection_(newCollection, collection, collectionName);
    }

    public <E> boolean synchronizeCollection(Iterable<E> newCollection, Collection<E> collection, String collectionName) {
        return this.synchronizeCollection(newCollection.iterator(), collection, collectionName);
    }

    public <E> boolean synchronizeCollection(Iterator<E> newCollection, Collection<E> collection, String collectionName) {
        if (!newCollection.hasNext()) {
            return this.clearCollection(collection, collectionName);
        }
        if (collection.isEmpty()) {
            return this.addItemsToCollection_(newCollection, collection, collectionName);
        }
        return this.synchronizeCollection_(CollectionTools.collection(newCollection), collection, collectionName);
    }

    protected <E> boolean synchronizeCollection_(Collection<E> newCollection, Collection<E> collection, String collectionName) {
        boolean changed = false;
        HashBag<E> removeItems = new HashBag<E>(collection);
        removeItems.removeAll(newCollection);
        changed |= this.removeItemsFromCollection((Collection<?>)removeItems, (Collection<?>)collection, collectionName);
        HashBag<E> addItems = new HashBag<E>(newCollection);
        addItems.removeAll(collection);
        return changed |= this.addItemsToCollection((Collection<? extends E>)addItems, collection, collectionName);
    }

    public void addListChangeListener(String listName, ListChangeListener listener) {
        this.addListener(LIST_CHANGE_LISTENER_CLASS, listName, listener);
    }

    public void removeListChangeListener(String listName, ListChangeListener listener) {
        this.removeListener(LIST_CHANGE_LISTENER_CLASS, listName, listener);
    }

    public boolean hasAnyListChangeListeners(String listName) {
        return this.hasAnyListeners(LIST_CHANGE_LISTENER_CLASS, listName);
    }

    private Iterable<ListChangeListener> getListChangeListeners(String listName) {
        return this.getListenerList(LIST_CHANGE_LISTENER_CLASS, listName);
    }

    private boolean hasListChangeListener(String listName, ListChangeListener listener) {
        return IterableTools.contains(this.getListChangeListeners(listName), listener);
    }

    public boolean fireItemsAdded(ListAddEvent event) {
        if (event.getItemsSize() != 0) {
            this.fireItemsAdded_(event);
            return true;
        }
        return false;
    }

    protected void fireItemsAdded_(ListAddEvent event) {
        Iterable<ChangeListener> changeListeners;
        String listName = event.getListName();
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                try {
                    listener.itemsAdded(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                try {
                    listener.itemsAdded(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean fireItemsAdded(String listName, int index, List<?> addedItems) {
        if (!addedItems.isEmpty()) {
            this.fireItemsAdded_(listName, index, addedItems);
            return true;
        }
        return false;
    }

    protected void fireItemsAdded_(String listName, int index, List<?> addedItems) {
        Iterable<ChangeListener> changeListeners;
        ListAddEvent event = null;
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                if (event == null) {
                    event = new ListAddEvent(this.source, listName, index, addedItems);
                }
                try {
                    listener.itemsAdded(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new ListAddEvent(this.source, listName, index, addedItems);
                }
                try {
                    listener.itemsAdded(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public void fireItemAdded(String listName, int index, Object addedItem) {
        Iterable<ChangeListener> changeListeners;
        ListAddEvent event = null;
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                if (event == null) {
                    event = new ListAddEvent(this.source, listName, index, addedItem);
                }
                try {
                    listener.itemsAdded(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new ListAddEvent(this.source, listName, index, addedItem);
                }
                try {
                    listener.itemsAdded(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean fireItemsRemoved(ListRemoveEvent event) {
        if (event.getItemsSize() != 0) {
            this.fireItemsRemoved_(event);
            return true;
        }
        return false;
    }

    protected void fireItemsRemoved_(ListRemoveEvent event) {
        Iterable<ChangeListener> changeListeners;
        String listName = event.getListName();
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                try {
                    listener.itemsRemoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                try {
                    listener.itemsRemoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean fireItemsRemoved(String listName, int index, List<?> removedItems) {
        if (!removedItems.isEmpty()) {
            this.fireItemsRemoved_(listName, index, removedItems);
            return true;
        }
        return false;
    }

    protected void fireItemsRemoved_(String listName, int index, List<?> removedItems) {
        Iterable<ChangeListener> changeListeners;
        ListRemoveEvent event = null;
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                if (event == null) {
                    event = new ListRemoveEvent(this.source, listName, index, removedItems);
                }
                try {
                    listener.itemsRemoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new ListRemoveEvent(this.source, listName, index, removedItems);
                }
                try {
                    listener.itemsRemoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public void fireItemRemoved(String listName, int index, Object removedItem) {
        Iterable<ChangeListener> changeListeners;
        ListRemoveEvent event = null;
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                if (event == null) {
                    event = new ListRemoveEvent(this.source, listName, index, removedItem);
                }
                try {
                    listener.itemsRemoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new ListRemoveEvent(this.source, listName, index, removedItem);
                }
                try {
                    listener.itemsRemoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean fireItemsReplaced(ListReplaceEvent event) {
        if (event.getItemsSize() != 0 && IterableTools.elementsAreDifferent(event.getNewItems(), event.getOldItems())) {
            this.fireItemsReplaced_(event);
            return true;
        }
        return false;
    }

    protected void fireItemsReplaced_(ListReplaceEvent event) {
        Iterable<ChangeListener> changeListeners;
        String listName = event.getListName();
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                try {
                    listener.itemsReplaced(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                try {
                    listener.itemsReplaced(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean fireItemsReplaced(String listName, int index, List<?> newItems, List<?> oldItems) {
        if (!newItems.isEmpty() && IterableTools.elementsAreDifferent(newItems, oldItems)) {
            this.fireItemsReplaced_(listName, index, newItems, oldItems);
            return true;
        }
        return false;
    }

    protected void fireItemsReplaced_(String listName, int index, List<?> newItems, List<?> oldItems) {
        Iterable<ChangeListener> changeListeners;
        ListReplaceEvent event = null;
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                if (event == null) {
                    event = new ListReplaceEvent(this.source, listName, index, newItems, oldItems);
                }
                try {
                    listener.itemsReplaced(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new ListReplaceEvent(this.source, listName, index, newItems, oldItems);
                }
                try {
                    listener.itemsReplaced(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean fireItemReplaced(String listName, int index, Object newItem, Object oldItem) {
        if (ObjectTools.notEquals(newItem, oldItem)) {
            this.fireItemReplaced_(listName, index, newItem, oldItem);
            return true;
        }
        return false;
    }

    protected void fireItemReplaced_(String listName, int index, Object newItem, Object oldItem) {
        Iterable<ChangeListener> changeListeners;
        ListReplaceEvent event = null;
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                if (event == null) {
                    event = new ListReplaceEvent(this.source, listName, index, newItem, oldItem);
                }
                try {
                    listener.itemsReplaced(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new ListReplaceEvent(this.source, listName, index, newItem, oldItem);
                }
                try {
                    listener.itemsReplaced(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean fireItemsMoved(ListMoveEvent event) {
        if (event.getTargetIndex() != event.getSourceIndex()) {
            this.fireItemsMoved_(event);
            return true;
        }
        return false;
    }

    protected void fireItemsMoved_(ListMoveEvent event) {
        Iterable<ChangeListener> changeListeners;
        String listName = event.getListName();
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                try {
                    listener.itemsMoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                try {
                    listener.itemsMoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean fireItemsMoved(String listName, int targetIndex, int sourceIndex, int length) {
        if (targetIndex != sourceIndex) {
            this.fireItemsMoved_(listName, targetIndex, sourceIndex, length);
            return true;
        }
        return false;
    }

    protected void fireItemsMoved_(String listName, int targetIndex, int sourceIndex, int length) {
        Iterable<ChangeListener> changeListeners;
        ListMoveEvent event = null;
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                if (event == null) {
                    event = new ListMoveEvent(this.source, listName, targetIndex, sourceIndex, length);
                }
                try {
                    listener.itemsMoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new ListMoveEvent(this.source, listName, targetIndex, sourceIndex, length);
                }
                try {
                    listener.itemsMoved(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public boolean fireItemMoved(String listName, int targetIndex, int sourceIndex) {
        if (targetIndex != sourceIndex) {
            this.fireItemMoved_(listName, targetIndex, sourceIndex);
            return true;
        }
        return false;
    }

    protected void fireItemMoved_(String listName, int targetIndex, int sourceIndex) {
        this.fireItemsMoved_(listName, targetIndex, sourceIndex, 1);
    }

    public void fireListCleared(ListClearEvent event) {
        Iterable<ChangeListener> changeListeners;
        String listName = event.getListName();
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                try {
                    listener.listCleared(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                try {
                    listener.listCleared(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public void fireListCleared(String listName) {
        Iterable<ChangeListener> changeListeners;
        ListClearEvent event = null;
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                if (event == null) {
                    event = new ListClearEvent(this.source, listName);
                }
                try {
                    listener.listCleared(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new ListClearEvent(this.source, listName);
                }
                try {
                    listener.listCleared(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public void fireListChanged(ListChangeEvent event) {
        Iterable<ChangeListener> changeListeners;
        String listName = event.getListName();
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                try {
                    listener.listChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                try {
                    listener.listChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public void fireListChanged(String listName, List<?> list) {
        Iterable<ChangeListener> changeListeners;
        ListChangeEvent event = null;
        Iterable<ListChangeListener> listeners = this.getListChangeListeners(listName);
        if (listeners != null) {
            for (ListChangeListener listener : listeners) {
                if (!this.hasListChangeListener(listName, listener)) continue;
                if (event == null) {
                    event = new ListChangeEvent(this.source, listName, list);
                }
                try {
                    listener.listChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
        if ((changeListeners = this.getChangeListeners()) != null) {
            for (ChangeListener listener : changeListeners) {
                if (!this.hasChangeListener(listener)) continue;
                if (event == null) {
                    event = new ListChangeEvent(this.source, listName, list);
                }
                try {
                    listener.listChanged(event);
                }
                catch (Throwable t) {
                    this.exceptionHandler.handleException(t);
                }
            }
        }
    }

    public <E> void addItemToList(int index, E item, List<E> list, String listName) {
        list.add(index, item);
        this.fireItemAdded(listName, index, item);
    }

    public <E> boolean addItemToList(E item, List<E> list, String listName) {
        if (list.add(item)) {
            this.fireItemAdded(listName, list.size() - 1, item);
            return true;
        }
        return false;
    }

    public <E> boolean addItemsToList(int index, E[] items, List<E> list, String listName) {
        return items.length != 0 && this.addItemsToList_(index, Arrays.asList(items), list, listName);
    }

    public <E> boolean addItemsToList(int index, Collection<? extends E> items, List<E> list, String listName) {
        return !items.isEmpty() && this.addItemsToList_(index, this.convertToList(items), list, listName);
    }

    protected <E> boolean addItemsToList_(int index, List<? extends E> items, List<E> list, String listName) {
        if (list.addAll(index, items)) {
            this.fireItemsAdded(listName, index, items);
            return true;
        }
        return false;
    }

    public <E> boolean addItemsToList(int index, Iterable<? extends E> items, List<E> list, String listName) {
        return this.addItemsToList(index, items.iterator(), list, listName);
    }

    public <E> boolean addItemsToList(int index, Iterator<? extends E> items, List<E> list, String listName) {
        if (!items.hasNext()) {
            return false;
        }
        ArrayList<? extends E> addedItems = ListTools.list(items);
        if (list.addAll(index, addedItems)) {
            this.fireItemsAdded(listName, index, addedItems);
            return true;
        }
        return false;
    }

    public <E> boolean addItemsToList(E[] items, List<E> list, String listName) {
        return items.length != 0 && this.addItemsToList_(Arrays.asList(items), list, listName);
    }

    public <E> boolean addItemsToList(Collection<? extends E> items, List<E> list, String listName) {
        return !items.isEmpty() && this.addItemsToList_(this.convertToList(items), list, listName);
    }

    protected <E> List<? extends E> convertToList(Collection<? extends E> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList<E>(collection);
    }

    protected <E> boolean addItemsToList_(List<? extends E> items, List<E> list, String listName) {
        int index = list.size();
        if (list.addAll(items)) {
            this.fireItemsAdded(listName, index, items);
            return true;
        }
        return false;
    }

    public <E> boolean addItemsToList(Iterable<? extends E> items, List<E> list, String listName) {
        return this.addItemsToList(items.iterator(), list, listName);
    }

    public <E> boolean addItemsToList(Iterator<? extends E> items, List<E> list, String listName) {
        if (!items.hasNext()) {
            return false;
        }
        return this.addItemsToList_(items, list, listName);
    }

    protected <E> boolean addItemsToList_(Iterator<? extends E> items, List<E> list, String listName) {
        ArrayList<? extends E> addedItems = ListTools.list(items);
        int index = list.size();
        if (list.addAll(addedItems)) {
            this.fireItemsAdded(listName, index, addedItems);
            return true;
        }
        return false;
    }

    public <E> E removeItemFromList(int index, List<E> list, String listName) {
        E item = list.remove(index);
        this.fireItemRemoved(listName, index, item);
        return item;
    }

    public boolean removeItemFromList(Object item, List<?> list, String listName) {
        int index = list.indexOf(item);
        if (index == -1) {
            return false;
        }
        list.remove(index);
        this.fireItemRemoved(listName, index, item);
        return true;
    }

    public <E> List<E> removeItemsFromList(int index, List<E> list, String listName) {
        return this.removeRangeFromList(index, list.size(), list, listName);
    }

    public <E> List<E> removeItemsFromList(int index, int length, List<E> list, String listName) {
        return this.removeRangeFromList(index, index + length, list, listName);
    }

    public <E> List<E> removeRangeFromList(int beginIndex, int endIndex, List<E> list, String listName) {
        if (beginIndex == endIndex) {
            return Collections.emptyList();
        }
        return this.removeRangeFromList_(beginIndex, endIndex, list, listName);
    }

    protected <E> List<E> removeRangeFromList_(int beginIndex, int endIndex, List<E> list, String listName) {
        List<E> subList = list.subList(beginIndex, endIndex);
        ArrayList<E> removedItems = new ArrayList<E>(subList);
        subList.clear();
        this.fireItemsRemoved(listName, beginIndex, removedItems);
        return removedItems;
    }

    public boolean removeItemsFromList(Object[] items, List<?> list, String listName) {
        return items.length != 0 && !list.isEmpty() && this.removeItemsFromList_(IteratorTools.iterator(items), list, listName);
    }

    public boolean removeItemsFromList(Collection<?> items, List<?> list, String listName) {
        return !items.isEmpty() && !list.isEmpty() && this.removeItemsFromList_(items.iterator(), list, listName);
    }

    public boolean removeItemsFromList(Iterable<?> items, List<?> list, String listName) {
        return this.removeItemsFromList(items.iterator(), list, listName);
    }

    public boolean removeItemsFromList(Iterator<?> items, List<?> list, String listName) {
        return items.hasNext() && !list.isEmpty() && this.removeItemsFromList_(items, list, listName);
    }

    protected boolean removeItemsFromList_(Iterator<?> items, List<?> list, String listName) {
        boolean changed = false;
        while (items.hasNext()) {
            changed |= this.removeItemFromList(items.next(), list, listName);
        }
        return changed;
    }

    public boolean retainItemsInList(Object[] items, List<?> list, String listName) {
        if (list.isEmpty()) {
            return false;
        }
        if (items.length == 0) {
            return this.clearList_(list, listName);
        }
        return this.retainItemsInList_(IteratorTools.iterator(items), list, listName);
    }

    public boolean retainItemsInList(Collection<?> items, List<?> list, String listName) {
        if (list.isEmpty()) {
            return false;
        }
        if (items.isEmpty()) {
            return this.clearList_(list, listName);
        }
        return this.retainItemsInList_(items.iterator(), list, listName);
    }

    public boolean retainItemsInList(Iterable<?> items, List<?> list, String listName) {
        return this.retainItemsInList(items.iterator(), list, listName);
    }

    public boolean retainItemsInList(Iterator<?> items, List<?> list, String listName) {
        if (list.isEmpty()) {
            return false;
        }
        if (!items.hasNext()) {
            return this.clearList_(list, listName);
        }
        return this.retainItemsInList_(items, list, listName);
    }

    protected boolean retainItemsInList_(Iterator<?> items, List<?> list, String listName) {
        HashBag<?> retainedItems = CollectionTools.collection(items);
        HashBag<?> removedItems = CollectionTools.collection(list);
        removedItems.removeAll(retainedItems);
        return this.removeItemsFromList((Collection<?>)removedItems, list, listName);
    }

    public <E> E setItemInList(int index, E item, List<E> list, String listName) {
        E oldItem = list.set(index, item);
        this.fireItemReplaced(listName, index, item, oldItem);
        return oldItem;
    }

    public <E> int replaceItemInList(E oldItem, E newItem, List<E> list, String listName) {
        if (list.isEmpty()) {
            return -1;
        }
        int index = list.indexOf(oldItem);
        if (index != -1 && ObjectTools.notEquals(oldItem, newItem)) {
            list.set(index, newItem);
            this.fireItemReplaced_(listName, index, newItem, oldItem);
        }
        return index;
    }

    public <E> List<E> setItemsInList(int index, E[] items, List<E> list, String listName) {
        if (items.length == 0) {
            return Collections.emptyList();
        }
        return this.setItemsInList_(index, Arrays.asList(items), list, listName);
    }

    public <E> List<E> setItemsInList(int index, List<? extends E> items, List<E> list, String listName) {
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        return this.setItemsInList_(index, items, list, listName);
    }

    protected <E> List<E> setItemsInList_(int index, List<? extends E> items, List<E> list, String listName) {
        List<E> subList = list.subList(index, index + items.size());
        ArrayList<E> oldItems = new ArrayList<E>(subList);
        int i = 0;
        while (i < items.size()) {
            E newItem = items.get(i);
            E oldItem = subList.set(i, newItem);
            this.fireItemReplaced(listName, index + i, newItem, oldItem);
            ++i;
        }
        return oldItems;
    }

    public <E> boolean moveItemsInList(int targetIndex, int sourceIndex, int length, List<E> list, String listName) {
        if (targetIndex == sourceIndex || length == 0) {
            return false;
        }
        ListTools.move(list, targetIndex, sourceIndex, length);
        this.fireItemsMoved(listName, targetIndex, sourceIndex, length);
        return true;
    }

    public <E> boolean moveItemInList(int targetIndex, E item, List<E> list, String listName) {
        return this.moveItemInList(targetIndex, list.indexOf(item), list, listName);
    }

    public <E> boolean moveItemInList(int targetIndex, int sourceIndex, List<E> list, String listName) {
        if (targetIndex == sourceIndex) {
            return false;
        }
        if (ObjectTools.equals(list.get(targetIndex), list.get(sourceIndex))) {
            return false;
        }
        ListTools.move(list, targetIndex, sourceIndex);
        this.fireItemMoved_(listName, targetIndex, sourceIndex);
        return true;
    }

    public boolean clearList(List<?> list, String listName) {
        return !list.isEmpty() && this.clearList_(list, listName);
    }

    protected boolean clearList_(List<?> list, String listName) {
        list.clear();
        this.fireListCleared(listName);
        return true;
    }

    public <E> boolean synchronizeList(List<E> newList, List<E> list, String listName) {
        if (newList.isEmpty()) {
            return this.clearList(list, listName);
        }
        if (list.isEmpty()) {
            return this.addItemsToList_(newList, list, listName);
        }
        return this.synchronizeList_(newList, list, listName);
    }

    public <E> boolean synchronizeList(Iterable<? extends E> newList, List<E> list, String listName) {
        return this.synchronizeList(newList.iterator(), list, listName);
    }

    public <E> boolean synchronizeList(Iterator<? extends E> newList, List<E> list, String listName) {
        if (!newList.hasNext()) {
            return this.clearList(list, listName);
        }
        if (list.isEmpty()) {
            return this.addItemsToList_(newList, list, listName);
        }
        return this.synchronizeList_(ListTools.list(newList), list, listName);
    }

    protected <E> boolean synchronizeList_(List<? extends E> newList, List<E> oldList, String listName) {
        int newSize = newList.size();
        int oldSize = oldList.size();
        boolean changed = false;
        int min = Math.min(newSize, oldSize);
        int i = 0;
        while (i < min) {
            E oldItem;
            E newItem = newList.get(i);
            if (ObjectTools.notEquals(newItem, oldItem = oldList.set(i, newItem))) {
                changed = true;
                this.fireItemReplaced_(listName, i, newItem, oldItem);
            }
            ++i;
        }
        if (newSize == oldSize) {
            return changed;
        }
        if (newSize < oldSize) {
            this.removeRangeFromList_(newSize, oldSize, oldList, listName);
            return true;
        }
        this.addItemsToList_(newList.subList(oldSize, newSize), oldList, listName);
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, this);
        sb.append('(');
        int len = sb.length();
        this.toString(sb);
        if (sb.length() == len) {
            sb.deleteCharAt(len - 1);
        } else {
            sb.append(')');
        }
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.source);
        sb.append(" : ");
        StringBuilderTools.append(sb, this.aspectListenerListPairs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AspectListenerListPair<L extends EventListener> {
        final ListenerList<L> listenerList;

        AspectListenerListPair(Class<L> listenerClass, L listener) {
            this.listenerList = new ListenerList<L>(listenerClass, listener);
        }

        abstract String getAspectName();

        boolean matches(Class<? extends EventListener> listenerClass, String aspectName) {
            return this.listenerList.getListenerType() == listenerClass;
        }

        boolean matches(Class<? extends EventListener> listenerClass) {
            return this.matches(listenerClass, null);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getAspectName());
            sb.append(" => ");
            this.listenerList.toString(sb);
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullAspectListenerListPair<L extends EventListener>
    extends AspectListenerListPair<L> {
        NullAspectListenerListPair(Class<L> listenerClass, L listener) {
            super(listenerClass, listener);
        }

        @Override
        boolean matches(Class<? extends EventListener> listenerClass, String aspectName) {
            return aspectName == null && super.matches(listenerClass, null);
        }

        @Override
        String getAspectName() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleAspectListenerListPair<L extends EventListener>
    extends AspectListenerListPair<L> {
        final String aspectName;

        SimpleAspectListenerListPair(Class<L> listenerClass, String aspectName, L listener) {
            super(listenerClass, listener);
            if (aspectName == null) {
                throw new NullPointerException();
            }
            this.aspectName = aspectName;
        }

        @Override
        boolean matches(Class<? extends EventListener> listenerClass, String aspectName) {
            return this.aspectName.equals(aspectName) && super.matches(listenerClass, aspectName);
        }

        @Override
        String getAspectName() {
            return this.aspectName;
        }
    }
}

