/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.EventListener;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterator.EmptyListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AspectListValueModelAdapter<S, E>
extends AspectAdapter<S, List<E>>
implements ListValueModel<E> {
    protected AspectListValueModelAdapter(PropertyValueModel<? extends S> subjectModel) {
        super(subjectModel);
    }

    @Override
    public ListIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.subject == null ? EmptyListIterator.instance() : this.listIterator_();
    }

    protected ListIterator<E> listIterator_() {
        return this.getListIterable().iterator();
    }

    protected ListIterable<E> getListIterable() {
        throw new RuntimeException("This method was not overridden.");
    }

    @Override
    public E get(int index) {
        return IteratorTools.get(this.listIterator(), index);
    }

    @Override
    public int size() {
        return this.subject == null ? 0 : this.size_();
    }

    protected int size_() {
        return IteratorTools.size(this.listIterator());
    }

    @Override
    public Object[] toArray() {
        return this.subject == null ? ObjectTools.EMPTY_OBJECT_ARRAY : this.toArray_();
    }

    protected Object[] toArray_() {
        return ArrayTools.array(this.listIterator(), this.size());
    }

    @Override
    protected List<E> getAspectValue() {
        return this.buildValueList();
    }

    @Override
    protected Class<? extends EventListener> getListenerClass() {
        return ListChangeListener.class;
    }

    @Override
    protected String getListenerAspectName() {
        return "list values";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("list values");
    }

    @Override
    protected void fireAspectChanged(List<E> oldValue, List<E> newValue) {
        this.fireListChanged("list values", newValue);
    }

    protected void aspectChanged() {
        this.fireListChanged("list values", this.buildValueList());
    }

    protected List<E> buildValueList() {
        return ListTools.list(this.iterator());
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.buildValueList());
    }
}

