/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.internal.model.value.AbstractPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListPropertyValueModelAdapter<T>
extends AbstractPropertyValueModelAdapter<T> {
    protected final ListValueModel<?> listModel;
    protected final ListChangeListener listListener;

    protected ListPropertyValueModelAdapter(ListValueModel<?> listModel) {
        if (listModel == null) {
            throw new NullPointerException();
        }
        this.listModel = listModel;
        this.listListener = this.buildListListener();
    }

    protected ListChangeListener buildListListener() {
        return new ListListener();
    }

    @Override
    protected void engageModel_() {
        this.listModel.addListChangeListener("list values", this.listListener);
    }

    @Override
    protected void disengageModel_() {
        this.listModel.removeListChangeListener("list values", this.listListener);
    }

    protected void itemsAdded(ListAddEvent event) {
        this.propertyChanged();
    }

    protected void itemsRemoved(ListRemoveEvent event) {
        this.propertyChanged();
    }

    protected void itemsReplaced(ListReplaceEvent event) {
        this.propertyChanged();
    }

    protected void itemsMoved(ListMoveEvent event) {
        this.propertyChanged();
    }

    protected void listCleared(ListClearEvent event) {
        this.propertyChanged();
    }

    protected void listChanged(ListChangeEvent event) {
        this.propertyChanged();
    }

    protected class ListListener
    extends ListChangeAdapter {
        protected ListListener() {
        }

        public void itemsAdded(ListAddEvent event) {
            ListPropertyValueModelAdapter.this.itemsAdded(event);
        }

        public void itemsRemoved(ListRemoveEvent event) {
            ListPropertyValueModelAdapter.this.itemsRemoved(event);
        }

        public void itemsReplaced(ListReplaceEvent event) {
            ListPropertyValueModelAdapter.this.itemsReplaced(event);
        }

        public void itemsMoved(ListMoveEvent event) {
            ListPropertyValueModelAdapter.this.itemsMoved(event);
        }

        public void listCleared(ListClearEvent event) {
            ListPropertyValueModelAdapter.this.listCleared(event);
        }

        public void listChanged(ListChangeEvent event) {
            ListPropertyValueModelAdapter.this.listChanged(event);
        }
    }
}

