/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.internal.model.value.PropertyValueModelWrapper;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullCheckPropertyValueModelWrapper<V>
extends PropertyValueModelWrapper<V>
implements PropertyValueModel<V> {
    private final V nullValue;

    public NullCheckPropertyValueModelWrapper(PropertyValueModel<? extends V> valueModel, V nullValue) {
        super(valueModel);
        if (nullValue == null) {
            throw new NullPointerException();
        }
        this.nullValue = nullValue;
    }

    @Override
    public V getValue() {
        return this.convertValue(this.valueModel.getValue());
    }

    @Override
    protected void wrappedValueChanged(V oldValue, V newValue) {
        this.firePropertyChanged("value", this.convertValue(oldValue), this.convertValue(newValue));
    }

    private V convertValue(V value) {
        return value != null ? value : this.nullValue;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.getValue());
    }
}

