/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.transformer;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.jpt.common.utility.Association;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.factory.Factory;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.exception.DefaultExceptionHandler;
import org.eclipse.jpt.common.utility.internal.transformer.CastingTransformerWrapper;
import org.eclipse.jpt.common.utility.internal.transformer.CloneTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.ClosureTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.CommandTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.ConditionalTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.DisabledTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.DowncastingTransformerWrapper;
import org.eclipse.jpt.common.utility.internal.transformer.FactoryTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.FieldTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.InstantiationTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.IsNotNullTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.IsNullTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.IterableTransformerWrapper;
import org.eclipse.jpt.common.utility.internal.transformer.MapTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.MethodTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.NotBooleanTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.NullCheckTransformerWrapper;
import org.eclipse.jpt.common.utility.internal.transformer.NullOutputTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.ObjectToStringTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.PassThruTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.PredicateTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.SafeTransformerWrapper;
import org.eclipse.jpt.common.utility.internal.transformer.StaticOutputTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.StringToBooleanTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.StringToIntegerTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.SwitchTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.ThreadLocalTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerChain;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerWrapper;
import org.eclipse.jpt.common.utility.internal.transformer.UpcastingTransformerWrapper;
import org.eclipse.jpt.common.utility.internal.transformer.XMLStringDecoder;
import org.eclipse.jpt.common.utility.internal.transformer.XMLStringEncoder;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransformerTools {
    public static final char[] XML_PREDEFINED_ENTITIES = new char[]{'\"', '&', '\'', '<', '>'};
    public static final Transformer[] EMPTY_ARRAY = new Transformer[0];

    public static <I, O> Transformer<I, O> adapt(Closure<? super I> closure) {
        return new ClosureTransformer(closure);
    }

    public static <I, O> Transformer<I, O> adapt(Command command) {
        return new CommandTransformer(command);
    }

    public static <I, O> Transformer<I, O> adapt(Factory<? extends O> factory) {
        return new FactoryTransformer(factory);
    }

    public static <I> Transformer<I, String> stringFromObjectTransformer() {
        return TransformerTools.objectToStringTransformer(String.valueOf(null));
    }

    public static <I> Transformer<I, String> objectToStringTransformer() {
        return TransformerTools.objectToStringTransformer(null);
    }

    public static <I> Transformer<I, String> objectToStringTransformer(String nullString) {
        return TransformerTools.nullCheck(TransformerTools.<I>objectToStringTransformer_(), nullString);
    }

    public static <I> Transformer<I, String> objectToStringTransformer_() {
        return ObjectToStringTransformer.instance();
    }

    public static Transformer<Boolean, Boolean> notBooleanTransformer(Boolean nullBoolean) {
        return TransformerTools.nullCheck(TransformerTools.notBooleanTransformer(), nullBoolean);
    }

    public static Transformer<Boolean, Boolean> notBooleanTransformer() {
        return NotBooleanTransformer.instance();
    }

    public static <I> Transformer<I, Boolean> isNotNullTransformer() {
        return IsNotNullTransformer.instance();
    }

    public static <I> Transformer<I, Boolean> isNullTransformer() {
        return IsNullTransformer.instance();
    }

    public static <I> Transformer<I, Boolean> adapt(Predicate<? super I> predicate) {
        return TransformerTools.adapt(predicate, null);
    }

    public static <I> Transformer<I, Boolean> adapt(Predicate<? super I> predicate, Boolean nullBoolean) {
        return TransformerTools.nullCheck(TransformerTools.adapt_(predicate), nullBoolean);
    }

    public static <I> Transformer<I, Boolean> adapt_(Predicate<? super I> predicate) {
        return new PredicateTransformer<I>(predicate);
    }

    public static Transformer<String, Boolean> stringToBooleanTransformer() {
        return TransformerTools.stringToBooleanTransformer(null);
    }

    public static Transformer<String, Boolean> stringToBooleanTransformer(Boolean nullBoolean) {
        return TransformerTools.nullCheck(TransformerTools.stringToBooleanTransformer_(), nullBoolean);
    }

    public static Transformer<String, Boolean> stringToBooleanTransformer_() {
        return StringToBooleanTransformer.instance();
    }

    public static Transformer<String, Integer> stringToIntegerTransformer() {
        return TransformerTools.stringToIntegerTransformer(null);
    }

    public static Transformer<String, Integer> stringToIntegerTransformer(Integer nullInteger) {
        return TransformerTools.nullCheck(TransformerTools.stringToIntegerTransformer_(), nullInteger);
    }

    public static Transformer<String, Integer> stringToIntegerTransformer_() {
        return StringToIntegerTransformer.instance();
    }

    public static Transformer<String, String> xmlStringDecoder() {
        return XMLStringDecoder.instance();
    }

    public static Transformer<String, String> xmlStringEncoder() {
        return TransformerTools.xmlStringEncoder(XML_PREDEFINED_ENTITIES);
    }

    public static Transformer<String, String> xmlStringEncoder(char[] chars) {
        return new XMLStringEncoder(chars);
    }

    public static <I, O> ThreadLocalTransformer<I, O> threadLocalTransformer() {
        return TransformerTools.threadLocalTransformer(NullOutputTransformer.instance());
    }

    public static <I, O> ThreadLocalTransformer<I, O> threadLocalTransformer(Transformer<? super I, ? extends O> defaultTransformer) {
        return new ThreadLocalTransformer<I, O>(defaultTransformer);
    }

    public static <I> Transformer<I, Iterator<? extends I>> toIterator(Transformer<? super I, ? extends Iterable<? extends I>> transformer) {
        return new IterableTransformerWrapper<I>(transformer);
    }

    public static <I, O> Transformer<I, O> nullCheck(Transformer<? super I, ? extends O> transformer) {
        return TransformerTools.nullCheck(transformer, null);
    }

    public static <I, O> Transformer<I, O> nullCheck(Transformer<? super I, ? extends O> transformer, O nullOutput) {
        return new NullCheckTransformerWrapper<I, O>(transformer, nullOutput);
    }

    public static <I, O> TransformerWrapper<I, O> wrap(Transformer<? super I, ? extends O> transformer) {
        return new TransformerWrapper<I, O>(transformer);
    }

    public static <I, X, O> Transformer<I, O> cast(Transformer<? super I, ? extends X> transformer) {
        return new CastingTransformerWrapper(transformer);
    }

    public static <I, X, O extends X> Transformer<I, O> downcast(Transformer<? super I, ? extends X> transformer) {
        return new DowncastingTransformerWrapper(transformer);
    }

    public static <I, O, X extends O> Transformer<I, O> upcast(Transformer<? super I, ? extends X> transformer) {
        return new UpcastingTransformerWrapper(transformer);
    }

    public static <I, O> Transformer<I, O> safe(Transformer<? super I, ? extends O> transformer) {
        return TransformerTools.safe(transformer, DefaultExceptionHandler.instance(), null);
    }

    public static <I, O> Transformer<I, O> safe(Transformer<? super I, ? extends O> transformer, O exceptionOutput) {
        return TransformerTools.safe(transformer, DefaultExceptionHandler.instance(), exceptionOutput);
    }

    public static <I, O> Transformer<I, O> safe(Transformer<? super I, ? extends O> transformer, ExceptionHandler exceptionHandler) {
        return TransformerTools.safe(transformer, exceptionHandler, null);
    }

    public static <I, O> Transformer<I, O> safe(Transformer<? super I, ? extends O> transformer, ExceptionHandler exceptionHandler, O exceptionOutput) {
        return new SafeTransformerWrapper<I, O>(transformer, exceptionHandler, exceptionOutput);
    }

    public static <I> Transformer<I, I> passThruTransformer() {
        return PassThruTransformer.instance();
    }

    public static <I> Transformer<I, I> passThruTransformer(I nullOutput) {
        return TransformerTools.nullCheck(TransformerTools.<I>passThruTransformer(), nullOutput);
    }

    public static <I extends Cloneable> Transformer<I, I> cloneTransformer() {
        return CloneTransformer.instance();
    }

    public static <O> Transformer<Class<? extends O>, O> instantiationTransformer() {
        return InstantiationTransformer.instance();
    }

    public static <I, O> Transformer<I, O> get(String fieldName) {
        return new FieldTransformer(fieldName);
    }

    public static <I, O> Transformer<I, O> execute(String methodName) {
        return TransformerTools.execute(methodName, ClassTools.EMPTY_ARRAY, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public static <I, O> Transformer<I, O> execute(String methodName, Class<?> parameterType, Object argument) {
        return TransformerTools.execute(methodName, new Class[]{parameterType}, new Object[]{argument});
    }

    public static <I, O> Transformer<I, O> execute(String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        return new MethodTransformer(methodName, parameterTypes, arguments);
    }

    public static <I, O> Transformer<I, O> chain(Transformer ... transformers) {
        return TransformerTools.chain(ArrayTools.iterable(transformers));
    }

    public static <I, O> Transformer<I, O> chain(Iterable<Transformer<?, ?>> transformers) {
        return new TransformerChain(transformers);
    }

    public static <I, O> Transformer<I, O> conditionalTransformer(Predicate<? super I> predicate, Transformer<? super I, ? extends O> transformer) {
        return TransformerTools.conditionalTransformer(predicate, transformer, NullOutputTransformer.instance());
    }

    public static <I, O> Transformer<I, O> conditionalTransformer(Predicate<? super I> predicate, Transformer<? super I, ? extends O> trueTransformer, Transformer<? super I, ? extends O> falseTransformer) {
        return new ConditionalTransformer<I, O>(predicate, trueTransformer, falseTransformer);
    }

    public static <I, O> Transformer<I, O> switchTransformer(Association<Predicate<? super I>, Transformer<? super I, ? extends O>> ... transformers) {
        return TransformerTools.switchTransformer(ArrayTools.iterable(transformers));
    }

    public static <I, O> Transformer<I, O> switchTransformer(Iterable<Association<Predicate<? super I>, Transformer<? super I, ? extends O>>> transformers) {
        return TransformerTools.switchTransformer(transformers, NullOutputTransformer.instance());
    }

    public static <I, O> Transformer<I, O> switchTransformer(Iterable<Association<Predicate<? super I>, Transformer<? super I, ? extends O>>> transformers, Transformer<? super I, ? extends O> defaultTransformer) {
        return new SwitchTransformer<I, O>(transformers, defaultTransformer);
    }

    public static <I, O> Transformer<I, O> disabledTransformer() {
        return DisabledTransformer.instance();
    }

    public static <I, O> Transformer<I, O> mapTransformer(Map<? super I, ? extends O> map) {
        return new MapTransformer<I, O>(map);
    }

    public static <I, O> Transformer<I, O> nullOutputTransformer() {
        return NullOutputTransformer.instance();
    }

    public static <I, O> Transformer<I, O> staticOutputTransformer(O output) {
        return new StaticOutputTransformer(output);
    }

    public static Transformer<?, ?>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    private TransformerTools() {
        throw new UnsupportedOperationException();
    }
}

