/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.context;

import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationship;
import org.eclipse.jpt.jpa.core.context.TypeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface AttributeMapping
extends JpaContextModel {
    public static final Transformer<AttributeMapping, String> NAME_TRANSFORMER = new NameTransformer();
    public static final String DEFAULT_PROPERTY = "default";
    public static final Predicate<AttributeMapping> IS_NOT_TRANSIENT = new IsNotTransient();
    public static final Predicate<AttributeMapping> IS_OVERRIDABLE_ASSOCIATION_MAPPING = new IsOverridableAssociationMapping();
    public static final Transformer<AttributeMapping, Iterable<Generator>> GENERATORS_TRANSFORMER = new GeneratorsTransformer();
    public static final Transformer<AttributeMapping, Iterable<String>> ALL_MAPPING_NAMES_TRANSFORMER = new AllMappingNamesTransformer();
    public static final Transformer<AttributeMapping, Iterable<String>> ALL_OVERRIDABLE_ATTRIBUTE_MAPPING_NAMES_TRANSFORMER = new AllOverridableAttributeMappingNamesTransformer();
    public static final Transformer<AttributeMapping, Iterable<String>> ALL_OVERRIDABLE_ASSOCIATION_MAPPING_NAMES_TRANSFORMER = new AllOverridableAssociationMappingNamesTransformer();

    public SpecifiedPersistentAttribute getPersistentAttribute();

    public String getName();

    public boolean isDefault();

    public String getKey();

    public boolean isOverridableAttributeMapping();

    public boolean isOverridableAssociationMapping();

    public TypeMapping getTypeMapping();

    public String getPrimaryKeyColumnName();

    public boolean isRelationshipOwner();

    public boolean isOwnedBy(AttributeMapping var1);

    public boolean validatesAgainstDatabase();

    public SpecifiedRelationship resolveOverriddenRelationship(String var1);

    public Iterable<Generator> getGenerators();

    public Iterable<String> getAllMappingNames();

    public Iterable<String> getAllOverridableAttributeMappingNames();

    public Iterable<String> getAllOverridableAssociationMappingNames();

    public AttributeMapping resolveAttributeMapping(String var1);

    public SpecifiedColumn resolveOverriddenColumn(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AllMappingNamesTransformer
    extends TransformerAdapter<AttributeMapping, Iterable<String>> {
        public Iterable<String> transform(AttributeMapping mapping) {
            return mapping.getAllMappingNames();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AllOverridableAssociationMappingNamesTransformer
    extends TransformerAdapter<AttributeMapping, Iterable<String>> {
        public Iterable<String> transform(AttributeMapping mapping) {
            return mapping.getAllOverridableAssociationMappingNames();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AllOverridableAttributeMappingNamesTransformer
    extends TransformerAdapter<AttributeMapping, Iterable<String>> {
        public Iterable<String> transform(AttributeMapping mapping) {
            return mapping.getAllOverridableAttributeMappingNames();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GeneratorsTransformer
    extends TransformerAdapter<AttributeMapping, Iterable<Generator>> {
        public Iterable<Generator> transform(AttributeMapping mapping) {
            return mapping.getGenerators();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsNotTransient
    extends PredicateAdapter<AttributeMapping> {
        public boolean evaluate(AttributeMapping mapping) {
            return mapping.getKey() != "transient";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsOverridableAssociationMapping
    extends PredicateAdapter<AttributeMapping> {
        public boolean evaluate(AttributeMapping mapping) {
            return mapping.isOverridableAssociationMapping();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyEquals
    extends CriterionPredicate<AttributeMapping, String> {
        public KeyEquals(String mappingKey) {
            super((Object)mappingKey);
        }

        public boolean evaluate(AttributeMapping mapping) {
            return ObjectTools.equals((Object)mapping.getKey(), (Object)this.criterion);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameTransformer
    extends TransformerAdapter<AttributeMapping, String> {
        public String transform(AttributeMapping mapping) {
            return mapping.getName();
        }
    }
}

