/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SubListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.JpaPlatformVariation;
import org.eclipse.jpt.jpa.core.context.AssociationOverride;
import org.eclipse.jpt.jpa.core.context.AssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BaseColumn;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.DiscriminatorType;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.IdTypeMapping;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.NamedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.OverrideContainer;
import org.eclipse.jpt.jpa.core.context.Override_;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.SecondaryTable;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationship;
import org.eclipse.jpt.jpa.core.context.SpecifiedSecondaryTable;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.TableColumn;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaQueryContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedSecondaryTable;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedTable;
import org.eclipse.jpt.jpa.core.context.java.JavaTable;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaIdTypeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractNamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideInverseJoinColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideJoinColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideJoinTableValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AttributeOverrideColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AttributeOverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.DiscriminatorColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityPrimaryKeyJoinColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.GenericEntityPrimaryKeyValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.JoinTableTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.MappedSuperclassOverrideDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.OverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.SecondaryTableValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.TableValidator;
import org.eclipse.jpt.jpa.core.internal.resource.java.NullPrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaAssociationOverrideContainer2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaAttributeOverrideContainer2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaEntity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOverrideContainer2_0;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorValueAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.InheritanceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaEntity
extends AbstractJavaIdTypeMapping<EntityAnnotation>
implements JavaEntity2_0,
JavaGeneratorContainer.Parent,
JavaQueryContainer.Parent {
    protected String specifiedName;
    protected String defaultName;
    protected Entity rootEntity;
    protected final Vector<Entity> descendants = new Vector();
    protected final JavaSpecifiedTable table;
    protected boolean specifiedTableIsAllowed;
    protected boolean tableIsUndefined;
    protected final AbstractJpaContextModel.ContextListContainer<JavaSpecifiedSecondaryTable, SecondaryTableAnnotation> specifiedSecondaryTableContainer;
    protected final JavaSpecifiedSecondaryTable.ParentAdapter specifiedSecondaryTableParentAdapter;
    protected final PrimaryKeyJoinColumnParentAdapter primaryKeyJoinColumnParentAdapter;
    protected final AbstractJpaContextModel.ContextListContainer<JavaSpecifiedPrimaryKeyJoinColumn, PrimaryKeyJoinColumnAnnotation> specifiedPrimaryKeyJoinColumnContainer;
    protected JavaSpecifiedPrimaryKeyJoinColumn defaultPrimaryKeyJoinColumn;
    protected InheritanceType specifiedInheritanceStrategy;
    protected InheritanceType defaultInheritanceStrategy;
    protected String specifiedDiscriminatorValue;
    protected String defaultDiscriminatorValue;
    protected boolean specifiedDiscriminatorValueIsAllowed;
    protected boolean discriminatorValueIsUndefined;
    protected final JavaSpecifiedDiscriminatorColumn discriminatorColumn;
    protected boolean specifiedDiscriminatorColumnIsAllowed;
    protected boolean discriminatorColumnIsUndefined;
    protected final JavaAttributeOverrideContainer attributeOverrideContainer;
    protected final JavaAssociationOverrideContainer associationOverrideContainer;
    protected final JavaGeneratorContainer generatorContainer;
    protected final JavaQueryContainer queryContainer;

    protected AbstractJavaEntity(JavaPersistentType parent, EntityAnnotation mappingAnnotation) {
        super(parent, mappingAnnotation);
        this.specifiedName = ((EntityAnnotation)this.mappingAnnotation).getName();
        this.table = this.buildTable();
        this.rootEntity = this;
        this.specifiedSecondaryTableParentAdapter = this.buildSpecifiedSecondaryTableParentAdapter();
        this.specifiedSecondaryTableContainer = this.buildSpecifiedSecondaryTableContainer();
        this.primaryKeyJoinColumnParentAdapter = this.buildPrimaryKeyJoinColumnParentAdapter();
        this.specifiedPrimaryKeyJoinColumnContainer = this.buildSpecifiedPrimaryKeyJoinColumnContainer();
        this.specifiedInheritanceStrategy = this.buildSpecifiedInheritanceStrategy();
        this.specifiedDiscriminatorValue = this.getDiscriminatorValueAnnotation().getValue();
        this.discriminatorColumn = this.buildDiscriminatorColumn();
        this.attributeOverrideContainer = this.buildAttributeOverrideContainer();
        this.associationOverrideContainer = this.buildAssociationOverrideContainer();
        this.generatorContainer = this.buildGeneratorContainer();
        this.queryContainer = this.buildQueryContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(((EntityAnnotation)this.mappingAnnotation).getName());
        this.table.synchronizeWithResourceModel();
        this.syncSpecifiedSecondaryTables();
        this.syncSpecifiedPrimaryKeyJoinColumns();
        this.setSpecifiedInheritanceStrategy_(this.buildSpecifiedInheritanceStrategy());
        this.setSpecifiedDiscriminatorValue_(this.getDiscriminatorValueAnnotation().getValue());
        this.discriminatorColumn.synchronizeWithResourceModel();
        this.attributeOverrideContainer.synchronizeWithResourceModel();
        this.associationOverrideContainer.synchronizeWithResourceModel();
        this.generatorContainer.synchronizeWithResourceModel();
        this.queryContainer.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultName(this.buildDefaultName());
        this.setRootEntity(this.buildRootEntity());
        this.updateDescendants();
        this.setDefaultInheritanceStrategy(this.buildDefaultInheritanceStrategy());
        this.table.update();
        this.setSpecifiedTableIsAllowed(this.buildSpecifiedTableIsAllowed());
        this.setTableIsUndefined(this.buildTableIsUndefined());
        this.updateModels((Iterable<? extends JpaContextModel>)this.getSecondaryTables());
        this.updateDefaultPrimaryKeyJoinColumn();
        this.updateModels((Iterable<? extends JpaContextModel>)this.getPrimaryKeyJoinColumns());
        this.discriminatorColumn.update();
        this.setSpecifiedDiscriminatorColumnIsAllowed(this.buildSpecifiedDiscriminatorColumnIsAllowed());
        this.setDiscriminatorColumnIsUndefined(this.buildDiscriminatorColumnIsUndefined());
        this.setDefaultDiscriminatorValue(this.buildDefaultDiscriminatorValue());
        this.setSpecifiedDiscriminatorValueIsAllowed(this.buildSpecifiedDiscriminatorValueIsAllowed());
        this.setDiscriminatorValueIsUndefined(this.buildDiscriminatorValueIsUndefined());
        this.attributeOverrideContainer.update();
        this.associationOverrideContainer.update();
        this.generatorContainer.update();
        this.queryContainer.update();
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        ((EntityAnnotation)this.mappingAnnotation).setName(name);
        this.setSpecifiedName_(name);
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected String buildDefaultName() {
        return this.getJavaResourceType().getName();
    }

    @Override
    public Entity getRootEntity() {
        return this.rootEntity;
    }

    protected void setRootEntity(Entity entity) {
        Entity old = this.rootEntity;
        this.rootEntity = entity;
        this.firePropertyChanged("rootEntity", old, entity);
    }

    protected Entity buildRootEntity() {
        Entity root = this;
        for (TypeMapping typeMapping : this.getAncestors()) {
            if (!(typeMapping instanceof Entity)) continue;
            root = (Entity)typeMapping;
        }
        return root;
    }

    @Override
    public Iterable<Entity> getDescendants() {
        return IterableTools.cloneLive(this.descendants);
    }

    protected void updateDescendants() {
        this.synchronizeCollection(this.buildDescendants(), this.descendants, "descendants");
    }

    protected Iterable<Entity> buildDescendants() {
        return this.isRootEntity() ? IterableTools.filter(this.getPersistenceUnit().getEntities(), (Predicate)new Entity.IsDescendant(this)) : IterableTools.emptyIterable();
    }

    @Override
    public JavaSpecifiedTable getTable() {
        return this.table;
    }

    protected JavaSpecifiedTable buildTable() {
        return this.getJpaFactory().buildJavaTable(this.buildTableParentAdapter());
    }

    protected JavaTable.ParentAdapter buildTableParentAdapter() {
        return new TableParentAdapter();
    }

    @Override
    public boolean specifiedTableIsAllowed() {
        return this.specifiedTableIsAllowed;
    }

    protected void setSpecifiedTableIsAllowed(boolean specifiedTableIsAllowed) {
        boolean old = this.specifiedTableIsAllowed;
        this.specifiedTableIsAllowed = specifiedTableIsAllowed;
        this.firePropertyChanged("specifiedTableIsAllowed", old, specifiedTableIsAllowed);
    }

    protected boolean buildSpecifiedTableIsAllowed() {
        return !this.isAbstractTablePerClass() && !this.isSingleTableDescendant();
    }

    @Override
    public boolean tableIsUndefined() {
        return this.tableIsUndefined;
    }

    protected void setTableIsUndefined(boolean tableIsUndefined) {
        boolean old = this.tableIsUndefined;
        this.tableIsUndefined = tableIsUndefined;
        this.firePropertyChanged("tableIsUndefined", old, tableIsUndefined);
    }

    protected boolean buildTableIsUndefined() {
        return this.isAbstractTablePerClass();
    }

    @Override
    public String getDefaultTableName() {
        return this.isSingleTableDescendant() ? this.rootEntity.getTable().getName() : (this.isAbstractTablePerClass() ? null : this.getName());
    }

    @Override
    public String getDefaultSchema() {
        return this.isSingleTableDescendant() ? this.rootEntity.getTable().getSchema() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultSchema());
    }

    @Override
    public String getDefaultCatalog() {
        return this.isSingleTableDescendant() ? this.rootEntity.getTable().getCatalog() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultCatalog());
    }

    @Override
    public ListIterable<JavaSpecifiedSecondaryTable> getSecondaryTables() {
        return this.getSpecifiedSecondaryTables();
    }

    @Override
    public int getSecondaryTablesSize() {
        return this.getSpecifiedSecondaryTablesSize();
    }

    @Override
    public ListIterable<JavaSpecifiedSecondaryTable> getSpecifiedSecondaryTables() {
        return this.specifiedSecondaryTableContainer;
    }

    @Override
    public int getSpecifiedSecondaryTablesSize() {
        return this.specifiedSecondaryTableContainer.size();
    }

    @Override
    public JavaSpecifiedSecondaryTable addSpecifiedSecondaryTable() {
        return this.addSpecifiedSecondaryTable(this.getSpecifiedSecondaryTablesSize());
    }

    @Override
    public JavaSpecifiedSecondaryTable addSpecifiedSecondaryTable(int index) {
        SecondaryTableAnnotation annotation = this.addSecondaryTableAnnotation(index);
        return (JavaSpecifiedSecondaryTable)this.specifiedSecondaryTableContainer.addContextElement(index, annotation);
    }

    protected SecondaryTableAnnotation addSecondaryTableAnnotation(int index) {
        return (SecondaryTableAnnotation)this.getJavaResourceType().addAnnotation(index, "javax.persistence.SecondaryTable");
    }

    @Override
    public void removeSpecifiedSecondaryTable(SpecifiedSecondaryTable secondaryTable) {
        this.removeSpecifiedSecondaryTable(this.specifiedSecondaryTableContainer.indexOf((JavaSpecifiedSecondaryTable)secondaryTable));
    }

    @Override
    public void removeSpecifiedSecondaryTable(int index) {
        this.getJavaResourceType().removeAnnotation(index, "javax.persistence.SecondaryTable");
        this.specifiedSecondaryTableContainer.remove(index);
    }

    @Override
    public void moveSpecifiedSecondaryTable(int targetIndex, int sourceIndex) {
        this.getResourceAnnotatedElement().moveAnnotation(targetIndex, sourceIndex, "javax.persistence.SecondaryTable");
        this.specifiedSecondaryTableContainer.move(targetIndex, sourceIndex);
    }

    protected JavaSpecifiedSecondaryTable buildSecondaryTable(SecondaryTableAnnotation secondaryTableAnnotation) {
        return this.getJpaFactory().buildJavaSecondaryTable(this.specifiedSecondaryTableParentAdapter, secondaryTableAnnotation);
    }

    protected void syncSpecifiedSecondaryTables() {
        this.specifiedSecondaryTableContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<SecondaryTableAnnotation> getSecondaryTableAnnotations() {
        return this.getSecondaryTableAnnotations_();
    }

    protected ListIterable<SecondaryTableAnnotation> getSecondaryTableAnnotations_() {
        return new SubListIterableWrapper(this.getNestableSecondaryTableAnnotations_());
    }

    protected ListIterable<NestableAnnotation> getNestableSecondaryTableAnnotations_() {
        return this.getResourceAnnotatedElement().getAnnotations("javax.persistence.SecondaryTable");
    }

    protected AbstractJpaContextModel.ContextListContainer<JavaSpecifiedSecondaryTable, SecondaryTableAnnotation> buildSpecifiedSecondaryTableContainer() {
        return this.buildSpecifiedContextListContainer("specifiedSecondaryTables", new SpecifiedSecondaryTableContainerAdapter());
    }

    protected JavaSpecifiedSecondaryTable.ParentAdapter buildSpecifiedSecondaryTableParentAdapter() {
        return new SecondaryTableParentAdapter();
    }

    @Override
    public ListIterable<JavaSpecifiedPrimaryKeyJoinColumn> getPrimaryKeyJoinColumns() {
        return this.hasSpecifiedPrimaryKeyJoinColumns() ? this.getSpecifiedPrimaryKeyJoinColumns() : this.getDefaultPrimaryKeyJoinColumns();
    }

    @Override
    public int getPrimaryKeyJoinColumnsSize() {
        return this.hasSpecifiedPrimaryKeyJoinColumns() ? this.getSpecifiedPrimaryKeyJoinColumnsSize() : this.getDefaultPrimaryKeyJoinColumnsSize();
    }

    @Override
    public ListIterable<JavaSpecifiedPrimaryKeyJoinColumn> getSpecifiedPrimaryKeyJoinColumns() {
        return this.specifiedPrimaryKeyJoinColumnContainer;
    }

    @Override
    public SpecifiedPrimaryKeyJoinColumn getSpecifiedPrimaryKeyJoinColumn(int index) {
        return (SpecifiedPrimaryKeyJoinColumn)this.specifiedPrimaryKeyJoinColumnContainer.get(index);
    }

    @Override
    public int getSpecifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumnContainer.size();
    }

    protected boolean hasSpecifiedPrimaryKeyJoinColumns() {
        return this.getSpecifiedPrimaryKeyJoinColumnsSize() != 0;
    }

    @Override
    public JavaSpecifiedPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn() {
        return this.addSpecifiedPrimaryKeyJoinColumn(this.getSpecifiedPrimaryKeyJoinColumnsSize());
    }

    @Override
    public JavaSpecifiedPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        PrimaryKeyJoinColumnAnnotation annotation = this.addPrimaryKeyJoinColumnAnnotation(index);
        return (JavaSpecifiedPrimaryKeyJoinColumn)this.specifiedPrimaryKeyJoinColumnContainer.addContextElement(index, annotation);
    }

    protected PrimaryKeyJoinColumnAnnotation addPrimaryKeyJoinColumnAnnotation(int index) {
        return (PrimaryKeyJoinColumnAnnotation)this.getJavaResourceType().addAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn");
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(SpecifiedPrimaryKeyJoinColumn joinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumnContainer.indexOf((JavaSpecifiedPrimaryKeyJoinColumn)joinColumn));
    }

    @Override
    public void convertDefaultPrimaryKeyJoinColumnsToSpecified() {
        JavaSpecifiedPrimaryKeyJoinColumn pkJoinColumn = this.addSpecifiedPrimaryKeyJoinColumn(0);
        if (this.defaultPrimaryKeyJoinColumn != null) {
            String columnName = this.defaultPrimaryKeyJoinColumn.getDefaultName();
            String referencedColumnName = this.defaultPrimaryKeyJoinColumn.getDefaultReferencedColumnName();
            pkJoinColumn.setSpecifiedName(columnName);
            pkJoinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
        }
    }

    @Override
    public void clearSpecifiedPrimaryKeyJoinColumns() {
        int index = this.getSpecifiedPrimaryKeyJoinColumnsSize();
        while (--index >= 0) {
            this.getJavaResourceType().removeAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn");
        }
        this.specifiedPrimaryKeyJoinColumnContainer.clear();
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        this.getJavaResourceType().removeAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn");
        this.specifiedPrimaryKeyJoinColumnContainer.remove(index);
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        this.getJavaResourceType().moveAnnotation(targetIndex, sourceIndex, "javax.persistence.PrimaryKeyJoinColumn");
        this.specifiedPrimaryKeyJoinColumnContainer.move(targetIndex, sourceIndex);
    }

    protected void syncSpecifiedPrimaryKeyJoinColumns() {
        this.specifiedPrimaryKeyJoinColumnContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<PrimaryKeyJoinColumnAnnotation> getPrimaryKeyJoinColumnAnnotations() {
        return this.getPrimaryKeyJoinColumnAnnotations_();
    }

    protected ListIterable<PrimaryKeyJoinColumnAnnotation> getPrimaryKeyJoinColumnAnnotations_() {
        return new SubListIterableWrapper(this.getNestablePrimaryKeyJoinColumnAnnotations_());
    }

    protected ListIterable<NestableAnnotation> getNestablePrimaryKeyJoinColumnAnnotations_() {
        return this.getResourceAnnotatedElement().getAnnotations("javax.persistence.PrimaryKeyJoinColumn");
    }

    protected PrimaryKeyJoinColumnParentAdapter buildPrimaryKeyJoinColumnParentAdapter() {
        return new PrimaryKeyJoinColumnParentAdapter();
    }

    protected JavaSpecifiedPrimaryKeyJoinColumn buildSpecifiedPrimaryKeyJoinColumn(PrimaryKeyJoinColumnAnnotation primaryKeyJoinColumnAnnotation) {
        return this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this.primaryKeyJoinColumnParentAdapter, primaryKeyJoinColumnAnnotation);
    }

    protected AbstractJpaContextModel.ContextListContainer<JavaSpecifiedPrimaryKeyJoinColumn, PrimaryKeyJoinColumnAnnotation> buildSpecifiedPrimaryKeyJoinColumnContainer() {
        return this.buildSpecifiedContextListContainer("specifiedPrimaryKeyJoinColumns", new SpecifiedPrimaryKeyJoinColumnContainerAdapter());
    }

    @Override
    public JavaSpecifiedPrimaryKeyJoinColumn getDefaultPrimaryKeyJoinColumn() {
        return this.defaultPrimaryKeyJoinColumn;
    }

    protected void setDefaultPrimaryKeyJoinColumn(JavaSpecifiedPrimaryKeyJoinColumn pkJoinColumn) {
        JavaSpecifiedPrimaryKeyJoinColumn old = this.defaultPrimaryKeyJoinColumn;
        this.defaultPrimaryKeyJoinColumn = pkJoinColumn;
        this.firePropertyChanged("defaultPrimaryKeyJoinColumn", old, pkJoinColumn);
    }

    protected ListIterable<JavaSpecifiedPrimaryKeyJoinColumn> getDefaultPrimaryKeyJoinColumns() {
        return this.defaultPrimaryKeyJoinColumn != null ? new SingleElementListIterable((Object)this.defaultPrimaryKeyJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultPrimaryKeyJoinColumnsSize() {
        return this.defaultPrimaryKeyJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultPrimaryKeyJoinColumn() {
        if (this.buildsDefaultPrimaryKeyJoinColumn()) {
            if (this.defaultPrimaryKeyJoinColumn == null) {
                this.setDefaultPrimaryKeyJoinColumn(this.buildDefaultPrimaryKeyJoinColumn());
            } else {
                this.defaultPrimaryKeyJoinColumn.update();
            }
        } else {
            this.setDefaultPrimaryKeyJoinColumn(null);
        }
    }

    protected boolean buildsDefaultPrimaryKeyJoinColumn() {
        return !this.isRootEntity() && !this.hasSpecifiedPrimaryKeyJoinColumns();
    }

    protected JavaSpecifiedPrimaryKeyJoinColumn buildDefaultPrimaryKeyJoinColumn() {
        return this.buildSpecifiedPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumnAnnotation((JavaResourceModel)this.getJavaResourceType()));
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return this.specifiedInheritanceStrategy != null ? this.specifiedInheritanceStrategy : this.defaultInheritanceStrategy;
    }

    @Override
    public InheritanceType getSpecifiedInheritanceStrategy() {
        return this.specifiedInheritanceStrategy;
    }

    @Override
    public void setSpecifiedInheritanceStrategy(InheritanceType inheritanceType) {
        if (ObjectTools.notEquals((Object)((Object)this.specifiedInheritanceStrategy), (Object)((Object)inheritanceType))) {
            this.getInheritanceAnnotation().setStrategy(InheritanceType.toJavaResourceModel(inheritanceType));
            this.removeInheritanceAnnotationIfUnset();
            this.setSpecifiedInheritanceStrategy_(inheritanceType);
        }
    }

    protected void setSpecifiedInheritanceStrategy_(InheritanceType inheritanceType) {
        InheritanceType old = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = inheritanceType;
        this.firePropertyChanged("specifiedInheritanceStrategy", (Object)old, (Object)inheritanceType);
    }

    protected InheritanceType buildSpecifiedInheritanceStrategy() {
        return InheritanceType.fromJavaResourceModel(this.getInheritanceAnnotation().getStrategy());
    }

    @Override
    public InheritanceType getDefaultInheritanceStrategy() {
        return this.defaultInheritanceStrategy;
    }

    protected void setDefaultInheritanceStrategy(InheritanceType inheritanceType) {
        InheritanceType old = this.defaultInheritanceStrategy;
        this.defaultInheritanceStrategy = inheritanceType;
        this.firePropertyChanged("defaultInheritanceStrategy", (Object)old, (Object)inheritanceType);
    }

    protected InheritanceType buildDefaultInheritanceStrategy() {
        return this.isRootEntity() ? InheritanceType.SINGLE_TABLE : this.rootEntity.getInheritanceStrategy();
    }

    protected InheritanceAnnotation getInheritanceAnnotation() {
        return (InheritanceAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.persistence.Inheritance");
    }

    protected void removeInheritanceAnnotationIfUnset() {
        if (this.getInheritanceAnnotation().isUnset()) {
            this.removeInheritanceAnnotation();
        }
    }

    protected void removeInheritanceAnnotation() {
        this.getJavaResourceType().removeAnnotation("javax.persistence.Inheritance");
    }

    @Override
    public String getDiscriminatorValue() {
        return this.specifiedDiscriminatorValue != null ? this.specifiedDiscriminatorValue : this.defaultDiscriminatorValue;
    }

    @Override
    public String getSpecifiedDiscriminatorValue() {
        return this.specifiedDiscriminatorValue;
    }

    @Override
    public void setSpecifiedDiscriminatorValue(String discriminatorValue) {
        if (ObjectTools.notEquals((Object)this.specifiedDiscriminatorValue, (Object)discriminatorValue)) {
            this.getDiscriminatorValueAnnotation().setValue(discriminatorValue);
            this.removeDiscriminatorValueAnnotationIfUnset();
            this.setSpecifiedDiscriminatorValue_(discriminatorValue);
        }
    }

    protected void setSpecifiedDiscriminatorValue_(String discriminatorValue) {
        String old = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = discriminatorValue;
        this.firePropertyChanged("specifiedDiscriminatorValue", old, discriminatorValue);
    }

    @Override
    public String getDefaultDiscriminatorValue() {
        return this.defaultDiscriminatorValue;
    }

    protected void setDefaultDiscriminatorValue(String discriminatorValue) {
        String old = this.defaultDiscriminatorValue;
        this.defaultDiscriminatorValue = discriminatorValue;
        this.firePropertyChanged("defaultDiscriminatorValue", old, discriminatorValue);
    }

    protected String buildDefaultDiscriminatorValue() {
        if (this.discriminatorValueIsUndefined) {
            return null;
        }
        return this.getDiscriminatorType() == DiscriminatorType.STRING ? this.getName() : null;
    }

    protected DiscriminatorType getDiscriminatorType() {
        return this.discriminatorColumn.getDiscriminatorType();
    }

    @Override
    public boolean specifiedDiscriminatorValueIsAllowed() {
        return this.specifiedDiscriminatorValueIsAllowed;
    }

    protected void setSpecifiedDiscriminatorValueIsAllowed(boolean allowed) {
        boolean old = this.specifiedDiscriminatorValueIsAllowed;
        this.specifiedDiscriminatorValueIsAllowed = allowed;
        this.firePropertyChanged("discriminatorValueIsAllowed", old, allowed);
    }

    protected boolean buildSpecifiedDiscriminatorValueIsAllowed() {
        return !this.isTablePerClass() && !this.isAbstract();
    }

    @Override
    public boolean discriminatorValueIsUndefined() {
        return this.discriminatorValueIsUndefined;
    }

    protected void setDiscriminatorValueIsUndefined(boolean undefined) {
        boolean old = this.discriminatorValueIsUndefined;
        this.discriminatorValueIsUndefined = undefined;
        this.firePropertyChanged("discriminatorValueIsUndefined", old, undefined);
    }

    protected boolean buildDiscriminatorValueIsUndefined() {
        return this.isTablePerClass() || this.isAbstract() || this.isRootNoDescendantsNoStrategyDefined();
    }

    protected DiscriminatorValueAnnotation getDiscriminatorValueAnnotation() {
        return (DiscriminatorValueAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.persistence.DiscriminatorValue");
    }

    protected void removeDiscriminatorValueAnnotationIfUnset() {
        if (this.getDiscriminatorValueAnnotation().isUnset()) {
            this.removeDiscriminatorValueAnnotation();
        }
    }

    protected void removeDiscriminatorValueAnnotation() {
        this.getJavaResourceType().removeAnnotation("javax.persistence.DiscriminatorValue");
    }

    @Override
    public JavaSpecifiedDiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    protected JavaSpecifiedDiscriminatorColumn buildDiscriminatorColumn() {
        return this.getJpaFactory().buildJavaDiscriminatorColumn(this.buildDiscriminatorColumnParentAdapter());
    }

    protected JavaSpecifiedDiscriminatorColumn.ParentAdapter buildDiscriminatorColumnParentAdapter() {
        return new DiscriminatorColumnParentAdapter();
    }

    @Override
    public boolean specifiedDiscriminatorColumnIsAllowed() {
        return this.specifiedDiscriminatorColumnIsAllowed;
    }

    protected void setSpecifiedDiscriminatorColumnIsAllowed(boolean allowed) {
        boolean old = this.specifiedDiscriminatorColumnIsAllowed;
        this.specifiedDiscriminatorColumnIsAllowed = allowed;
        this.firePropertyChanged("specifiedDiscriminatorColumnIsAllowed", old, allowed);
    }

    protected boolean buildSpecifiedDiscriminatorColumnIsAllowed() {
        return !this.isTablePerClass() && this.isRootEntity();
    }

    @Override
    public boolean discriminatorColumnIsUndefined() {
        return this.discriminatorColumnIsUndefined;
    }

    protected void setDiscriminatorColumnIsUndefined(boolean undefined) {
        boolean old = this.discriminatorColumnIsUndefined;
        this.discriminatorColumnIsUndefined = undefined;
        this.firePropertyChanged("discriminatorColumnIsUndefined", old, undefined);
    }

    protected boolean buildDiscriminatorColumnIsUndefined() {
        return this.isTablePerClass() || this.isRootNoDescendantsNoStrategyDefined();
    }

    protected DiscriminatorColumnAnnotation getDiscriminatorColumnAnnotation() {
        return (DiscriminatorColumnAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.persistence.DiscriminatorColumn");
    }

    protected void removeDiscriminatorColumnAnnotation() {
        this.getJavaResourceType().removeAnnotation("javax.persistence.DiscriminatorColumn");
    }

    @Override
    public JavaAttributeOverrideContainer getAttributeOverrideContainer() {
        return this.attributeOverrideContainer;
    }

    protected JavaAttributeOverrideContainer buildAttributeOverrideContainer() {
        return this.getJpaFactory().buildJavaAttributeOverrideContainer(new AttributeOverrideContainerParentAdapter());
    }

    @Override
    public JavaAssociationOverrideContainer getAssociationOverrideContainer() {
        return this.associationOverrideContainer;
    }

    protected JavaAssociationOverrideContainer buildAssociationOverrideContainer() {
        return this.getJpaFactory().buildJavaAssociationOverrideContainer(new AssociationOverrideContainerParentAdapter());
    }

    @Override
    public SpecifiedRelationship resolveOverriddenRelationship(String attributeName) {
        JavaSpecifiedAssociationOverride override = this.associationOverrideContainer.getSpecifiedOverrideNamed(attributeName);
        return override != null ? override.getRelationship() : super.resolveOverriddenRelationship(attributeName);
    }

    @Override
    public JavaGeneratorContainer getGeneratorContainer() {
        return this.generatorContainer;
    }

    protected JavaGeneratorContainer buildGeneratorContainer() {
        return this.getJpaFactory().buildJavaGeneratorContainer(this);
    }

    @Override
    public Iterable<Generator> getGenerators() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.getGenerators(), this.generatorContainer.getGenerators()});
    }

    public JavaResourceType getResourceAnnotatedElement() {
        return this.getJavaResourceType();
    }

    @Override
    public boolean supportsGenerators() {
        return true;
    }

    @Override
    public JavaQueryContainer getQueryContainer() {
        return this.queryContainer;
    }

    protected JavaQueryContainer buildQueryContainer() {
        return this.getJpaFactory().buildJavaQueryContainer(this);
    }

    @Override
    public Iterable<Query> getQueries() {
        return this.queryContainer.getQueries();
    }

    @Override
    public Iterable<Table> getAssociatedTables() {
        return IterableTools.insert((Object)this.table, this.getSecondaryTables());
    }

    @Override
    public Iterable<Table> getAllAssociatedTables() {
        return IterableTools.children(this.getInheritanceHierarchy(), TypeMappingTools.ASSOCIATED_TABLES_TRANSFORMER);
    }

    @Override
    public Iterable<String> getAllAssociatedTableNames() {
        return this.convertToNames(this.getAllAssociatedTables());
    }

    protected Iterable<String> convertToNames(Iterable<Table> tables) {
        return IterableTools.removeNulls((Iterable)IterableTools.transform(tables, Table.NAME_TRANSFORMER));
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return !this.tableNameIsValid(tableName);
    }

    protected boolean tableNameIsValid(String tableName) {
        return this.tableIsUndefined || this.tableNameIsValid_(tableName);
    }

    protected boolean tableNameIsValid_(String tableName) {
        return this.connectionProfileIsActive() ? this.resolveDbTable(tableName) != null : this.tableNameIsAssociatedTable(tableName);
    }

    protected boolean tableNameIsAssociatedTable(String tableName) {
        if (tableName != null && tableName.equals(this.getPrimaryTableName())) {
            return true;
        }
        return IterableTools.contains(this.getAllAssociatedTableNames(), (Object)tableName);
    }

    @Override
    public String getPrimaryTableName() {
        return this.table.getName();
    }

    @Override
    public org.eclipse.jpt.jpa.db.Table getPrimaryDbTable() {
        return this.table.getDbTable();
    }

    @Override
    public org.eclipse.jpt.jpa.db.Table resolveDbTable(String tableName) {
        if (this.getDataSource().connectionProfileIsActive()) {
            return this.getDataSource().selectTableForIdentifier(this.getAllAssociatedDbTables(), tableName);
        }
        return null;
    }

    protected Iterable<org.eclipse.jpt.jpa.db.Table> getAllAssociatedDbTables() {
        return IterableTools.removeNulls((Iterable)IterableTools.transform(this.getAllAssociatedTables(), Table.DB_TABLE_TRANSFORMER));
    }

    @Override
    public Schema getDbSchema() {
        return this.table.getDbSchema();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return MappingTools.getPrimaryKeyColumnName(this);
    }

    @Override
    public SpecifiedPersistentAttribute getIdAttribute() {
        Iterator<AttributeMapping> idAttributeMappings = this.getAllAttributeMappings("id").iterator();
        if (idAttributeMappings.hasNext()) {
            SpecifiedPersistentAttribute attribute = idAttributeMappings.next().getPersistentAttribute();
            return idAttributeMappings.hasNext() ? null : attribute;
        }
        return null;
    }

    @Override
    public String getKey() {
        return "entity";
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public SpecifiedColumn resolveOverriddenColumn(String attributeName) {
        JavaSpecifiedAttributeOverride override = this.attributeOverrideContainer.getSpecifiedOverrideNamed(attributeName);
        return override != null ? override.getColumn() : super.resolveOverriddenColumn(attributeName);
    }

    @Override
    public Iterable<String> getOverridableAttributeNames() {
        return this.isTablePerClass() ? super.getOverridableAttributeNames() : EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getOverridableAssociationNames() {
        return this.isTablePerClass() ? super.getOverridableAssociationNames() : EmptyIterable.instance();
    }

    @Override
    public AttributeMapping resolveAttributeMapping(String name) {
        for (AttributeMapping attributeMapping : this.getAllAttributeMappings()) {
            AttributeMapping resolvedMapping = attributeMapping.resolveAttributeMapping(name);
            if (resolvedMapping == null) continue;
            return resolvedMapping;
        }
        return null;
    }

    @Override
    public Entity getParentEntity() {
        for (TypeMapping typeMapping : this.getAncestors()) {
            if (!(typeMapping instanceof Entity)) continue;
            return (Entity)typeMapping;
        }
        return null;
    }

    @Override
    public boolean isRootEntity() {
        return this == this.rootEntity;
    }

    public boolean isDescendant() {
        return !this.isRootEntity();
    }

    protected boolean isSingleTableDescendant() {
        return this.isDescendant() && this.getInheritanceStrategy() == InheritanceType.SINGLE_TABLE;
    }

    public boolean isRootNoDescendantsNoStrategyDefined() {
        return this.isRootEntity() && this.descendants.isEmpty() && this.specifiedInheritanceStrategy == null;
    }

    protected boolean isAbstractTablePerClass() {
        return this.isAbstract() && this.isTablePerClass();
    }

    protected boolean isTablePerClass() {
        return this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS;
    }

    protected boolean isTablePerClassDescendant() {
        return this.isTablePerClass() && this.isDescendant();
    }

    protected boolean isAbstract() {
        return this.getJavaResourceType().isAbstract();
    }

    protected boolean isFinal() {
        return this.getJavaResourceType().isFinal();
    }

    protected boolean isMember() {
        return this.getJavaResourceType().getTypeBinding().isMemberTypeDeclaration();
    }

    protected boolean isStatic() {
        return this.getJavaResourceType().isStatic();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.table.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (JavaSpecifiedSecondaryTable secondaryTable : this.getSecondaryTables()) {
            result = secondaryTable.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        for (JavaSpecifiedPrimaryKeyJoinColumn pkJoinColumn : this.getPrimaryKeyJoinColumns()) {
            result = pkJoinColumn.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        result = this.attributeOverrideContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.associationOverrideContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.discriminatorColumn.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.generatorContainer.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateTable(messages, reporter);
        for (JavaSpecifiedSecondaryTable secondaryTable : this.getSecondaryTables()) {
            secondaryTable.validate(messages, reporter);
        }
        this.validateInheritance(messages, reporter);
        this.validatePrimaryKeyJoinColumns(messages, reporter);
        this.generatorContainer.validate(messages, reporter);
        this.queryContainer.validate(messages, reporter);
        this.attributeOverrideContainer.validate(messages, reporter);
        this.associationOverrideContainer.validate(messages, reporter);
        this.validateEntityName(messages);
    }

    protected void validatePrimaryKeyJoinColumns(List<IMessage> messages, IReporter reporter) {
        if (this.getPrimaryKeyJoinColumnsSize() > 0) {
            if (this.getParentEntity() == null) {
                messages.add(this.buildValidationMessage(((EntityAnnotation)this.getMappingAnnotation()).getNameTextRange(), JptJpaCoreValidationMessages.ROOT_ENTITY_HAS_PK_JOIN_COLUMN_DEFINED, this.getPersistentType().getName()));
            } else {
                for (JavaSpecifiedPrimaryKeyJoinColumn pkJoinColumn : this.getPrimaryKeyJoinColumns()) {
                    pkJoinColumn.validate(messages, reporter);
                }
            }
        }
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return super.validatesAgainstDatabase() && !this.isAbstractTablePerClass();
    }

    protected void validateEntityName(List<IMessage> messages) {
        if (StringTools.isBlank((String)this.getName())) {
            messages.add(this.buildValidationMessage(((EntityAnnotation)this.getMappingAnnotation()).getNameTextRange(), JptJpaCoreValidationMessages.ENTITY_NAME_MISSING, this.getPersistentType().getName()));
        }
    }

    @Override
    public boolean supportsValidationMessages() {
        return MappingTools.modelIsInternalSource(this, (JavaResourceModel)this.getJavaResourceType());
    }

    @Override
    public TextRange getNameTextRange() {
        return ((EntityAnnotation)this.getMappingAnnotation()).getNameTextRange();
    }

    @Override
    protected JpaValidator buildPrimaryKeyValidator() {
        return new GenericEntityPrimaryKeyValidator(this);
    }

    protected void validateTable(List<IMessage> messages, IReporter reporter) {
        if (this.isAbstractTablePerClass()) {
            if (this.table.isSpecifiedInResource()) {
                messages.add(this.buildValidationMessage(this.table.getValidationTextRange(), JptJpaCoreValidationMessages.ENTITY_ABSTRACT_TABLE_PER_CLASS_DEFINES_TABLE, this.getName()));
            }
            return;
        }
        if (this.isSingleTableDescendant() && this.getDataSource().connectionProfileIsActive()) {
            if (this.specifiedTableDoesNotMatchRootTable()) {
                messages.add(this.buildValidationMessage(this.table.getValidationTextRange(), JptJpaCoreValidationMessages.ENTITY_SINGLE_TABLE_DESCENDANT_DEFINES_TABLE, this.getName()));
            }
            return;
        }
        this.table.validate(messages, reporter);
    }

    protected boolean specifiedTableDoesNotMatchRootTable() {
        return this.table.isSpecifiedInResource() && this.table.getDbTable() != this.getRootEntity().getTable().getDbTable();
    }

    protected void validateInheritance(List<IMessage> messages, IReporter reporter) {
        this.validateInheritanceStrategy(messages);
        this.validateDiscriminatorColumn(messages, reporter);
        this.validateDiscriminatorValue(messages);
    }

    protected void validateDiscriminatorColumn(List<IMessage> messages, IReporter reporter) {
        if (this.specifiedDiscriminatorColumnIsAllowed && !this.discriminatorColumnIsUndefined) {
            this.discriminatorColumn.validate(messages, reporter);
        } else if (!this.discriminatorColumn.isVirtual()) {
            if (this.isDescendant()) {
                messages.add(this.buildValidationMessage(this.getDiscriminatorColumnTextRange(), JptJpaCoreValidationMessages.ENTITY_NON_ROOT_DISCRIMINATOR_COLUMN_DEFINED, this.getName()));
            } else if (this.isTablePerClass()) {
                messages.add(this.buildValidationMessage(this.getDiscriminatorColumnTextRange(), JptJpaCoreValidationMessages.ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_COLUMN_DEFINED, this.getName()));
            }
        }
    }

    protected void validateDiscriminatorValue(List<IMessage> messages) {
        if (this.discriminatorValueIsUndefined && this.specifiedDiscriminatorValue != null) {
            if (this.isAbstract()) {
                messages.add(this.buildValidationMessage(this.getDiscriminatorValueTextRange(), JptJpaCoreValidationMessages.ENTITY_ABSTRACT_DISCRIMINATOR_VALUE_DEFINED, this.getName()));
            } else if (this.isTablePerClass()) {
                messages.add(this.buildValidationMessage(this.getDiscriminatorValueTextRange(), JptJpaCoreValidationMessages.ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_VALUE_DEFINED, this.getName()));
            }
        }
    }

    protected void validateInheritanceStrategy(List<IMessage> messages) {
        JpaPlatformVariation.Supported tablePerConcreteClassInheritanceIsSupported = this.getJpaPlatformVariation().getTablePerConcreteClassInheritanceIsSupported();
        if (tablePerConcreteClassInheritanceIsSupported == JpaPlatformVariation.Supported.YES) {
            return;
        }
        if (this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS && this.isRootEntity()) {
            if (tablePerConcreteClassInheritanceIsSupported == JpaPlatformVariation.Supported.NO) {
                messages.add(this.buildValidationMessage(this.getInheritanceStrategyTextRange(), JptJpaCoreValidationMessages.ENTITY_TABLE_PER_CLASS_NOT_SUPPORTED_ON_PLATFORM, this.getName()));
            } else {
                messages.add(this.buildValidationMessage(this.getInheritanceStrategyTextRange(), JptJpaCoreValidationMessages.ENTITY_TABLE_PER_CLASS_NOT_PORTABLE_ON_PLATFORM, this.getName()));
            }
        }
    }

    protected TextRange getDiscriminatorValueTextRange() {
        return this.getValidationTextRange(this.getDiscriminatorValueAnnotation().getTextRange());
    }

    protected TextRange getDiscriminatorColumnTextRange() {
        return this.getValidationTextRange(this.discriminatorColumn.getValidationTextRange());
    }

    protected TextRange getInheritanceStrategyTextRange() {
        return this.getValidationTextRange(this.getInheritanceAnnotation().getStrategyTextRange());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AssociationOverrideContainerParentAdapter
    extends OverrideContainerParentAdapter
    implements JavaAssociationOverrideContainer2_0.ParentAdapter {
        @Override
        protected Iterable<String> getAllOverridableNames_(TypeMapping overriddenTypeMapping) {
            return overriddenTypeMapping.getAllOverridableAssociationNames();
        }

        @Override
        public SpecifiedRelationship resolveOverriddenRelationship(String attributeName) {
            return MappingTools.resolveOverriddenRelationship(this.getOverridableTypeMapping(), attributeName);
        }

        @Override
        public JpaValidator buildOverrideValidator(Override_ override, OverrideContainer container) {
            return new AssociationOverrideValidator((AssociationOverride)override, (AssociationOverrideContainer)container, (OverrideValidator.OverrideDescriptionProvider)new MappedSuperclassOverrideDescriptionProvider());
        }

        @Override
        public JpaValidator buildColumnValidator(Override_ override, BaseColumn column, TableColumn.ParentAdapter parentAdapter) {
            return new AssociationOverrideJoinColumnValidator((AssociationOverride)override, (JoinColumn)column, (JoinColumn.ParentAdapter)parentAdapter, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
        }

        @Override
        public JpaValidator buildJoinTableJoinColumnValidator(AssociationOverride override, JoinColumn column, JoinColumn.ParentAdapter parentAdapter) {
            return new AssociationOverrideJoinColumnValidator(override, column, parentAdapter, (AbstractNamedColumnValidator.TableDescriptionProvider)new JoinTableTableDescriptionProvider());
        }

        @Override
        public JpaValidator buildJoinTableInverseJoinColumnValidator(AssociationOverride override, JoinColumn column, JoinColumn.ParentAdapter parentAdapter) {
            return new AssociationOverrideInverseJoinColumnValidator(override, column, parentAdapter, (AbstractNamedColumnValidator.TableDescriptionProvider)new JoinTableTableDescriptionProvider());
        }

        @Override
        public JpaValidator buildJoinTableValidator(AssociationOverride override, Table t) {
            return new AssociationOverrideJoinTableValidator(override, (JoinTable)t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttributeOverrideContainerParentAdapter
    extends OverrideContainerParentAdapter
    implements JavaAttributeOverrideContainer2_0.ParentAdapter {
        @Override
        protected Iterable<String> getAllOverridableNames_(TypeMapping overriddenTypeMapping) {
            return IterableTools.filter(overriddenTypeMapping.getAllOverridableAttributeNames(), (Predicate)new AttributeIsDerivedId());
        }

        @Override
        public SpecifiedColumn resolveOverriddenColumn(String attributeName) {
            return MappingTools.resolveOverriddenColumn(this.getOverridableTypeMapping(), attributeName);
        }

        @Override
        public JpaValidator buildOverrideValidator(Override_ override, OverrideContainer container) {
            return new AttributeOverrideValidator((AttributeOverride)override, (AttributeOverrideContainer)container, (OverrideValidator.OverrideDescriptionProvider)new MappedSuperclassOverrideDescriptionProvider());
        }

        @Override
        public JpaValidator buildColumnValidator(Override_ override, BaseColumn column, TableColumn.ParentAdapter parentAdapter) {
            return new AttributeOverrideColumnValidator((AttributeOverride)override, column, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AttributeIsDerivedId
        extends PredicateAdapter<String> {
            public boolean evaluate(String attributeName) {
                return !AttributeOverrideContainerParentAdapter.this.getTypeMapping().attributeIsDerivedId(attributeName);
            }
        }
    }

    public class DiscriminatorColumnParentAdapter
    extends NamedColumnParentAdapter
    implements JavaSpecifiedDiscriminatorColumn.ParentAdapter {
        public JavaEntity getColumnParent() {
            return AbstractJavaEntity.this;
        }

        public String getDefaultColumnName(NamedColumn column) {
            return this.isDescendant() ? this.getRootDiscriminatorColumn().getName() : (this.discriminatorColumnIsUndefined() ? null : "DTYPE");
        }

        public int getDefaultLength() {
            return this.isDescendant() ? this.getRootDiscriminatorColumn().getLength() : (this.discriminatorColumnIsUndefined() ? 0 : 31);
        }

        public DiscriminatorType getDefaultDiscriminatorType() {
            return this.isDescendant() ? this.getRootDiscriminatorColumn().getDiscriminatorType() : (this.discriminatorColumnIsUndefined() ? null : NamedDiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE);
        }

        protected boolean isDescendant() {
            return AbstractJavaEntity.this.isDescendant();
        }

        protected SpecifiedDiscriminatorColumn getRootDiscriminatorColumn() {
            return AbstractJavaEntity.this.rootEntity.getDiscriminatorColumn();
        }

        protected boolean discriminatorColumnIsUndefined() {
            return AbstractJavaEntity.this.discriminatorColumnIsUndefined;
        }

        public JpaValidator buildColumnValidator(NamedColumn column) {
            return new DiscriminatorColumnValidator(column);
        }

        public DiscriminatorColumnAnnotation getColumnAnnotation() {
            return AbstractJavaEntity.this.getDiscriminatorColumnAnnotation();
        }

        public void removeColumnAnnotation() {
            AbstractJavaEntity.this.removeDiscriminatorColumnAnnotation();
        }
    }

    public abstract class NamedColumnParentAdapter
    implements NamedColumn.ParentAdapter {
        public String getDefaultTableName() {
            return AbstractJavaEntity.this.getPrimaryTableName();
        }

        public org.eclipse.jpt.jpa.db.Table resolveDbTable(String tableName) {
            return AbstractJavaEntity.this.resolveDbTable(tableName);
        }

        public TextRange getValidationTextRange() {
            return AbstractJavaEntity.this.getValidationTextRange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class OverrideContainerParentAdapter
    implements JavaOverrideContainer2_0.ParentAdapter {
        @Override
        public JpaContextModel getOverrideContainerParent() {
            return AbstractJavaEntity.this;
        }

        @Override
        public JavaResourceMember getResourceMember() {
            return AbstractJavaEntity.this.getJavaResourceType();
        }

        @Override
        public AbstractJavaEntity getTypeMapping() {
            return AbstractJavaEntity.this;
        }

        @Override
        public TextRange getValidationTextRange() {
            return AbstractJavaEntity.this.getValidationTextRange();
        }

        @Override
        public IdTypeMapping getOverridableTypeMapping() {
            return AbstractJavaEntity.this.getSuperTypeMapping();
        }

        @Override
        public Iterable<String> getAllOverridableNames() {
            IdTypeMapping overriddenTypeMapping = this.getOverridableTypeMapping();
            return overriddenTypeMapping != null ? this.getAllOverridableNames_(overriddenTypeMapping) : EmptyIterable.instance();
        }

        protected abstract Iterable<String> getAllOverridableNames_(TypeMapping var1);

        @Override
        public String getDefaultTableName() {
            return AbstractJavaEntity.this.getPrimaryTableName();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return AbstractJavaEntity.this.tableNameIsInvalid(tableName);
        }

        @Override
        public org.eclipse.jpt.jpa.db.Table resolveDbTable(String tableName) {
            return AbstractJavaEntity.this.resolveDbTable(tableName);
        }

        @Override
        public Iterable<String> getCandidateTableNames() {
            return AbstractJavaEntity.this.getAllAssociatedTableNames();
        }

        @Override
        public String getPossiblePrefix() {
            return null;
        }

        @Override
        public String getWritePrefix() {
            return null;
        }

        @Override
        public boolean isRelevant(String overrideName) {
            return true;
        }
    }

    public class PrimaryKeyJoinColumnParentAdapter
    extends NamedColumnParentAdapter
    implements BaseJoinColumn.ParentAdapter {
        public JpaContextModel getColumnParent() {
            return AbstractJavaEntity.this;
        }

        public org.eclipse.jpt.jpa.db.Table getReferencedColumnDbTable() {
            Entity parentEntity = AbstractJavaEntity.this.getParentEntity();
            return parentEntity == null ? null : parentEntity.getPrimaryDbTable();
        }

        public int getJoinColumnsSize() {
            return AbstractJavaEntity.this.getPrimaryKeyJoinColumnsSize();
        }

        public String getDefaultColumnName(NamedColumn column) {
            if (this.getJoinColumnsSize() != 1) {
                return null;
            }
            Entity parentEntity = AbstractJavaEntity.this.getParentEntity();
            return parentEntity == null ? AbstractJavaEntity.this.getPrimaryKeyColumnName() : parentEntity.getPrimaryKeyColumnName();
        }

        public JpaValidator buildColumnValidator(NamedColumn column) {
            return new EntityPrimaryKeyJoinColumnValidator((BaseJoinColumn)column, this);
        }
    }

    public class SecondaryTableParentAdapter
    implements JavaSpecifiedSecondaryTable.ParentAdapter {
        public JavaEntity getTableParent() {
            return AbstractJavaEntity.this;
        }

        public JpaValidator buildTableValidator(Table t) {
            return new SecondaryTableValidator((SecondaryTable)t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpecifiedPrimaryKeyJoinColumnContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<JavaSpecifiedPrimaryKeyJoinColumn, PrimaryKeyJoinColumnAnnotation> {
        public SpecifiedPrimaryKeyJoinColumnContainerAdapter() {
            super(AbstractJavaEntity.this);
        }

        @Override
        public JavaSpecifiedPrimaryKeyJoinColumn buildContextElement(PrimaryKeyJoinColumnAnnotation resourceElement) {
            return AbstractJavaEntity.this.buildSpecifiedPrimaryKeyJoinColumn(resourceElement);
        }

        @Override
        public ListIterable<PrimaryKeyJoinColumnAnnotation> getResourceElements() {
            return AbstractJavaEntity.this.getPrimaryKeyJoinColumnAnnotations();
        }

        @Override
        public PrimaryKeyJoinColumnAnnotation extractResourceElement(JavaSpecifiedPrimaryKeyJoinColumn contextElement) {
            return contextElement.getColumnAnnotation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpecifiedSecondaryTableContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<JavaSpecifiedSecondaryTable, SecondaryTableAnnotation> {
        public SpecifiedSecondaryTableContainerAdapter() {
            super(AbstractJavaEntity.this);
        }

        @Override
        public JavaSpecifiedSecondaryTable buildContextElement(SecondaryTableAnnotation resourceElement) {
            return AbstractJavaEntity.this.buildSecondaryTable(resourceElement);
        }

        @Override
        public ListIterable<SecondaryTableAnnotation> getResourceElements() {
            return AbstractJavaEntity.this.getSecondaryTableAnnotations();
        }

        @Override
        public SecondaryTableAnnotation extractResourceElement(JavaSpecifiedSecondaryTable contextElement) {
            return contextElement.getTableAnnotation();
        }
    }

    public class TableParentAdapter
    implements JavaTable.ParentAdapter {
        public JavaEntity getTableParent() {
            return AbstractJavaEntity.this;
        }

        public JpaValidator buildTableValidator(Table t) {
            return new TableValidator(t);
        }
    }
}

