/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.TypeBinding;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.TypeDeclarationTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.CollectionMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.Accessor;
import org.eclipse.jpt.jpa.core.context.java.DefaultJavaAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.java.FieldAccessor;
import org.eclipse.jpt.jpa.core.internal.context.java.PropertyAccessor;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedPersistentAttribute2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.AccessAnnotation2_0;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaPersistentAttribute
extends AbstractJavaContextModel<PersistentType>
implements JavaSpecifiedPersistentAttribute,
SpecifiedPersistentAttribute2_0 {
    protected final Accessor accessor;
    protected AccessType defaultAccess;
    protected AccessType specifiedAccess;
    protected JavaAttributeMapping mapping;
    protected String defaultMappingKey;
    protected JavaSpecifiedPersistentAttribute.JpaContainerDefinition jpaContainerDefinition = JavaSpecifiedPersistentAttribute.JpaContainerDefinition.Null.instance();
    protected static final JavaSpecifiedPersistentAttribute.JpaContainerDefinition[] JPA_CONTAINER_DEFINITION_ARRAY = new JavaSpecifiedPersistentAttribute.JpaContainerDefinition[]{new CollectionJpaContainerDefinition(Set.class, "javax.persistence.metamodel.SetAttribute"), new CollectionJpaContainerDefinition(List.class, "javax.persistence.metamodel.ListAttribute"), new CollectionJpaContainerDefinition(Collection.class, "javax.persistence.metamodel.CollectionAttribute"), new MapJpaContainerDefinition(Map.class, "javax.persistence.metamodel.MapAttribute")};
    protected static final Iterable<JavaSpecifiedPersistentAttribute.JpaContainerDefinition> JPA_CONTAINER_DEFINITIONS = IterableTools.iterable((Object[])JPA_CONTAINER_DEFINITION_ARRAY);

    protected AbstractJavaPersistentAttribute(PersistentType parent, JavaResourceField resourceField) {
        super(parent);
        this.accessor = new FieldAccessor(this, resourceField);
        this.initialize();
    }

    protected AbstractJavaPersistentAttribute(PersistentType parent, JavaResourceMethod resourceGetter, JavaResourceMethod resourceSetter) {
        super(parent);
        this.accessor = new PropertyAccessor(this, resourceGetter, resourceSetter);
        this.initialize();
    }

    protected AbstractJavaPersistentAttribute(PersistentType parent, Accessor accessor) {
        super(parent);
        this.accessor = accessor;
        this.initialize();
    }

    protected void initialize() {
        this.defaultAccess = this.buildDefaultAccess();
        this.specifiedAccess = this.buildSpecifiedAccess();
        this.mapping = this.buildMapping();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setDefaultAccess(this.buildDefaultAccess());
        this.setSpecifiedAccess_(this.buildSpecifiedAccess());
        this.syncMapping();
    }

    @Override
    public void update() {
        super.update();
        this.updateJpaContainerDefinition();
        this.updateMapping();
    }

    @Override
    public void addRootStructureNodesTo(JpaFile jpaFile, Collection<JpaStructureNode> rootStructureNodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.getResourceAttribute().getName();
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public boolean isFor(JavaResourceField resourceField) {
        return this.accessor.isFor(resourceField);
    }

    @Override
    public boolean isFor(JavaResourceMethod resourceGetter, JavaResourceMethod resourceSetter) {
        return this.accessor.isFor(resourceGetter, resourceSetter);
    }

    @Override
    public AccessType getAccess() {
        AccessType access = this.getSpecifiedAccess();
        return access != null ? access : this.defaultAccess;
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", old, access);
    }

    protected AccessType buildDefaultAccess() {
        return this.accessor.getDefaultAccess();
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType specifiedAccess) {
        throw new UnsupportedOperationException();
    }

    protected void setSpecifiedAccess_(AccessType access) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = access;
        this.firePropertyChanged("specifiedAccess", old, access);
    }

    protected AccessType buildSpecifiedAccess() {
        AccessAnnotation2_0 accessAnnotation = this.getAccessAnnotation();
        return accessAnnotation == null ? null : AccessType.fromJavaResourceModel(accessAnnotation.getValue(), this.getJpaPlatform(), this.getResourceType());
    }

    protected AccessAnnotation2_0 getAccessAnnotation() {
        return (AccessAnnotation2_0)this.getResourceAttribute().getAnnotation("javax.persistence.Access");
    }

    @Override
    public JavaAttributeMapping getMapping() {
        return this.mapping;
    }

    protected void setMapping(JavaAttributeMapping mapping) {
        JavaAttributeMapping old = this.mapping;
        this.mapping = mapping;
        this.firePropertyChanged("mapping", old, mapping);
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public JavaAttributeMapping setMappingKey(String key) {
        if (this.mapping.isDefault()) {
            if (key != null) {
                this.setMappingKey_(key);
            }
        } else if (!ObjectTools.equals((Object)key, (Object)this.mapping.getKey())) {
            this.setMappingKey_(key);
        }
        return this.mapping;
    }

    protected void setMappingKey_(String key) {
        JavaAttributeMappingDefinition definition = this.getSpecifiedMappingDefinition(key);
        if (definition == null) {
            definition = this.getDefaultMappingDefinition();
            Iterable<String> supportingAnnotationNames = definition != null ? definition.getSupportingAnnotationNames() : EmptyIterable.instance();
            this.setMappingAnnotation(null, supportingAnnotationNames);
        } else {
            this.setMappingAnnotation(definition);
        }
        this.setMapping(this.buildMapping(definition));
    }

    protected void setMappingAnnotation(JavaAttributeMappingDefinition definition) {
        this.setMappingAnnotation(definition.getAnnotationName(), definition.getSupportingAnnotationNames());
    }

    protected void setMappingAnnotation(String primaryAnnotationName, Iterable<String> supportingAnnotationNames) {
        this.getResourceAttribute().setPrimaryAnnotation(primaryAnnotationName, supportingAnnotationNames);
    }

    protected JavaAttributeMapping buildMapping(JavaAttributeMappingDefinition definition) {
        return definition == null ? this.buildNullMapping() : this.buildMapping_(definition);
    }

    protected JavaAttributeMapping buildNullMapping() {
        return this.getJpaFactory().buildJavaNullAttributeMapping(this);
    }

    protected JavaAttributeMapping buildMapping_(JavaAttributeMappingDefinition definition) {
        if (this.mapping != null && this.mapping.isDefault() && ObjectTools.equals((Object)this.mapping.getKey(), (Object)definition.getKey())) {
            this.mapping.updateDefault();
            return this.mapping;
        }
        return definition.buildMapping(this, this.getJpaFactory());
    }

    protected JavaAttributeMapping buildMapping() {
        return this.buildMapping(this.getSpecifiedMappingDefinition());
    }

    protected void syncMapping() {
        this.mapping.synchronizeWithResourceModel();
    }

    protected JavaAttributeMappingDefinition getSpecifiedMappingDefinition(String key) {
        if (key == null) {
            return null;
        }
        for (JavaAttributeMappingDefinition definition : this.getSpecifiedMappingDefinitions()) {
            if (!ObjectTools.equals((Object)definition.getKey(), (Object)key)) continue;
            return definition;
        }
        throw new IllegalArgumentException("invalid mapping key: " + key);
    }

    protected JavaAttributeMappingDefinition getSpecifiedMappingDefinition() {
        if (this.accessor.getResourceAttribute().isAnnotated()) {
            for (JavaAttributeMappingDefinition definition : this.getSpecifiedMappingDefinitions()) {
                if (!definition.isSpecified(this)) continue;
                return definition;
            }
        }
        return null;
    }

    protected Iterable<JavaAttributeMappingDefinition> getSpecifiedMappingDefinitions() {
        return this.getJpaPlatform().getSpecifiedJavaAttributeMappingDefinitions();
    }

    @Override
    public String getDefaultMappingKey() {
        return this.defaultMappingKey;
    }

    protected void setDefaultMappingKey(String mappingKey) {
        String old = this.defaultMappingKey;
        this.defaultMappingKey = mappingKey;
        this.firePropertyChanged("defaultMappingKey", old, mappingKey);
    }

    protected void updateMapping() {
        String newSpecifiedKey;
        JavaAttributeMappingDefinition newDefinition = null;
        JavaAttributeMappingDefinition defaultDefinition = this.getDefaultMappingDefinition();
        String newDefaultKey = defaultDefinition == null ? null : defaultDefinition.getKey();
        boolean mappingChanged = false;
        if (ObjectTools.notEquals((Object)this.mapping.getKey(), (Object)newDefaultKey)) {
            newDefinition = defaultDefinition;
            mappingChanged = true;
        }
        this.setDefaultMappingKey(newDefaultKey);
        JavaAttributeMappingDefinition specifiedDefinition = this.getSpecifiedMappingDefinition();
        String string = newSpecifiedKey = specifiedDefinition == null ? null : specifiedDefinition.getKey();
        if (specifiedDefinition != null) {
            newDefinition = null;
            mappingChanged = false;
            if (this.mapping.isDefault() || ObjectTools.notEquals((Object)this.mapping.getKey(), (Object)newSpecifiedKey)) {
                newDefinition = specifiedDefinition;
                mappingChanged = true;
            }
        }
        if (mappingChanged) {
            this.setMapping(this.buildMapping(newDefinition));
        } else {
            this.mapping.update();
        }
    }

    protected JavaAttributeMappingDefinition getDefaultMappingDefinition() {
        for (DefaultJavaAttributeMappingDefinition definition : this.getDefaultMappingDefinitions()) {
            if (!definition.isDefault(this)) continue;
            return definition;
        }
        return null;
    }

    protected Iterable<DefaultJavaAttributeMappingDefinition> getDefaultMappingDefinitions() {
        return this.getJpaPlatform().getDefaultJavaAttributeMappingDefinitions();
    }

    @Override
    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType(this);
    }

    @Override
    public Class<JavaPersistentAttribute> getStructureType() {
        return JavaPersistentAttribute.class;
    }

    public Iterable<JpaStructureNode> getStructureChildren() {
        return IterableTools.emptyIterable();
    }

    @Override
    public int getStructureChildrenSize() {
        return 0;
    }

    @Override
    public TextRange getFullTextRange() {
        return this.getResourceAttribute().getTextRange();
    }

    @Override
    public boolean containsOffset(int offset) {
        TextRange fullTextRange = this.getFullTextRange();
        return fullTextRange == null ? false : fullTextRange.includes(offset);
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getResourceAttribute().getNameTextRange();
    }

    @Override
    public boolean typeIsBasic() {
        String typeName = this.getTypeName();
        if (typeName == null) {
            return false;
        }
        int arrayDepth = TypeDeclarationTools.arrayDepth((String)typeName);
        if (arrayDepth > 1) {
            return false;
        }
        if (arrayDepth == 1) {
            String elementTypeName = TypeDeclarationTools.elementTypeName((String)typeName, (int)1);
            return MappingTools.elementTypeIsValidForBasicArray(elementTypeName);
        }
        if (ClassNameTools.isVariablePrimitive((String)typeName)) {
            return true;
        }
        if (ClassNameTools.isVariablePrimitiveWrapper((String)typeName)) {
            return true;
        }
        if (MappingTools.typeIsOtherValidBasicType(typeName)) {
            return true;
        }
        if (this.getResourceAttribute().getTypeBinding().isEnum()) {
            return true;
        }
        return this.getResourceAttribute().getTypeBinding().isSubTypeOf(TypeTools.SERIALIZABLE_NAME);
    }

    @Override
    public String getSingleReferenceTargetTypeName() {
        String typeName = this.getTypeName();
        if (typeName == null) {
            return null;
        }
        if (TypeDeclarationTools.arrayDepth((String)typeName) != 0) {
            return null;
        }
        if (this.typeIsContainer()) {
            return null;
        }
        return typeName;
    }

    @Override
    public String getMultiReferenceTargetTypeName() {
        return this.getJpaContainerDefinition().getMultiReferenceTargetTypeName(this.getResourceAttribute());
    }

    @Override
    public String getMultiReferenceMapKeyTypeName() {
        return this.getJpaContainerDefinition().getMultiReferenceMapKeyTypeName(this.getResourceAttribute());
    }

    protected boolean typeIsContainer() {
        return this.jpaContainerDefinition.isContainer();
    }

    @Override
    public PersistentType getDeclaringPersistentType() {
        return (PersistentType)this.parent;
    }

    @Override
    public TypeMapping getDeclaringTypeMapping() {
        return this.getDeclaringPersistentType().getMapping();
    }

    @Override
    public JavaSpecifiedPersistentAttribute getJavaPersistentAttribute() {
        return this;
    }

    @Override
    public JavaResourceAttribute getResourceAttribute() {
        return this.accessor.getResourceAttribute();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.mapping.getPrimaryKeyColumnName();
    }

    @Override
    public String getTypeName() {
        return this.getResourceAttribute().getTypeBinding().getQualifiedName();
    }

    @Override
    public String getTypeName(PersistentType contextType) {
        while (contextType != null) {
            if (contextType == this.parent) {
                return this.getTypeName();
            }
            TypeBinding typeBinding = contextType.getAttributeTypeBinding(this);
            if (typeBinding != null) {
                return typeBinding.getQualifiedName();
            }
            contextType = contextType.getSuperPersistentType();
        }
        return null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public IJavaElement getJavaElement() {
        return this.accessor.getJavaElement();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.isVirtual() ? this.getDeclaringPersistentType().getValidationTextRange() : this.getSelectionTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateAttribute(messages, reporter);
        this.mapping.validate(messages, reporter);
    }

    protected void validateAttribute(List<IMessage> messages, IReporter reporter) {
        this.buildAttributeValidator().validate(messages, reporter);
    }

    protected abstract JpaValidator buildAttributeValidator();

    @Override
    public boolean isVirtual() {
        IContentType persistentTypeContentType = this.getDeclaringPersistentType().getResourceType().getContentType();
        return !persistentTypeContentType.isKindOf(JavaResourceCompilationUnit.CONTENT_TYPE) && !persistentTypeContentType.isKindOf(JavaResourcePackageFragmentRoot.JAR_CONTENT_TYPE);
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return this.mapping.getCompletionProposals(pos);
    }

    @Override
    public String getMetamodelContainerFieldTypeName() {
        return this.getJpaContainerDefinition().getMetamodelContainerFieldTypeName();
    }

    @Override
    public String getMetamodelContainerFieldMapKeyTypeName() {
        return this.getJpaContainerDefinition().getMetamodelContainerFieldMapKeyTypeName((CollectionMapping)((Object)this.mapping));
    }

    @Override
    public String getMetamodelTypeName() {
        String typeName = this.getTypeName();
        if (typeName == null) {
            return MetamodelField2_0.DEFAULT_TYPE_NAME;
        }
        if (ClassNameTools.isPrimitive((String)typeName)) {
            return ClassNameTools.primitiveWrapperClassName((String)typeName);
        }
        return typeName;
    }

    @Override
    public JavaSpecifiedPersistentAttribute.JpaContainerDefinition getJpaContainerDefinition() {
        return this.jpaContainerDefinition;
    }

    protected void updateJpaContainerDefinition() {
        this.setJpaContainerDefinition(this.buildJpaContainerDefinition());
    }

    protected void setJpaContainerDefinition(JavaSpecifiedPersistentAttribute.JpaContainerDefinition jpaContainerDefinition) {
        JavaSpecifiedPersistentAttribute.JpaContainerDefinition old = this.jpaContainerDefinition;
        this.jpaContainerDefinition = jpaContainerDefinition;
        this.firePropertyChanged("jpaContainerDefinition", old, this.jpaContainerDefinition);
    }

    protected JavaSpecifiedPersistentAttribute.JpaContainerDefinition buildJpaContainerDefinition() {
        for (JavaSpecifiedPersistentAttribute.JpaContainerDefinition definition : this.getJpaContainerDefinitions()) {
            if (!this.getResourceAttribute().getTypeBinding().isSubTypeOf(definition.getTypeName())) continue;
            return definition;
        }
        return JavaSpecifiedPersistentAttribute.JpaContainerDefinition.Null.instance();
    }

    protected Iterable<JavaSpecifiedPersistentAttribute.JpaContainerDefinition> getJpaContainerDefinitions() {
        return JPA_CONTAINER_DEFINITIONS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractJpaContainerDefinition
    implements JavaSpecifiedPersistentAttribute.JpaContainerDefinition {
        protected final String typeName;
        protected final String metamodelContainerFieldTypeName;

        protected AbstractJpaContainerDefinition(Class<?> containerClass, String metamodelContainerFieldTypeName) {
            this(containerClass.getName(), metamodelContainerFieldTypeName);
        }

        protected AbstractJpaContainerDefinition(String typeName, String metamodelContainerFieldTypeName) {
            if (typeName == null || metamodelContainerFieldTypeName == null) {
                throw new NullPointerException();
            }
            this.typeName = typeName;
            this.metamodelContainerFieldTypeName = metamodelContainerFieldTypeName;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public boolean isContainer() {
            return true;
        }

        @Override
        public String getMetamodelContainerFieldTypeName() {
            return this.metamodelContainerFieldTypeName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CollectionJpaContainerDefinition
    extends AbstractJpaContainerDefinition {
        protected CollectionJpaContainerDefinition(Class<?> collectionClass, String staticMetamodelTypeDeclarationTypeName) {
            super(collectionClass, staticMetamodelTypeDeclarationTypeName);
        }

        @Override
        public String getMultiReferenceTargetTypeName(JavaResourceAttribute resourceAttribute) {
            return resourceAttribute.getTypeBinding().getTypeArgumentNamesSize() == 1 ? resourceAttribute.getTypeBinding().getTypeArgumentName(0) : null;
        }

        @Override
        public String getMultiReferenceMapKeyTypeName(JavaResourceAttribute resourceAttribute) {
            return null;
        }

        @Override
        public String getMetamodelContainerFieldMapKeyTypeName(CollectionMapping mapping) {
            return null;
        }

        @Override
        public boolean isMap() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MapJpaContainerDefinition
    extends AbstractJpaContainerDefinition {
        protected MapJpaContainerDefinition(Class<?> mapClass, String staticMetamodelTypeDeclarationTypeName) {
            super(mapClass, staticMetamodelTypeDeclarationTypeName);
        }

        @Override
        public String getMultiReferenceTargetTypeName(JavaResourceAttribute resourceAttribute) {
            return resourceAttribute.getTypeBinding().getTypeArgumentNamesSize() == 2 ? resourceAttribute.getTypeBinding().getTypeArgumentName(1) : null;
        }

        @Override
        public String getMultiReferenceMapKeyTypeName(JavaResourceAttribute resourceAttribute) {
            return resourceAttribute.getTypeBinding().getTypeArgumentNamesSize() == 2 ? resourceAttribute.getTypeBinding().getTypeArgumentName(0) : null;
        }

        @Override
        public String getMetamodelContainerFieldMapKeyTypeName(CollectionMapping mapping) {
            return mapping.getMetamodelFieldMapKeyTypeName();
        }

        @Override
        public boolean isMap() {
            return true;
        }
    }
}

