/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.VirtualJoinTable;
import org.eclipse.jpt.jpa.core.context.VirtualJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.VirtualRelationship;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaVirtualReferenceTable;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaVirtualJoinTable
extends AbstractJavaVirtualReferenceTable<VirtualJoinTableRelationshipStrategy, VirtualJoinTable.ParentAdapter, JoinTable>
implements VirtualJoinTable {
    protected final AbstractJpaContextModel.ContextListContainer<VirtualJoinColumn, JoinColumn> specifiedInverseJoinColumnContainer;
    protected final JoinColumn.ParentAdapter inverseJoinColumnParentAdapter = this.buildInverseJoinColumnParentAdapter();
    protected VirtualJoinColumn defaultInverseJoinColumn;

    public GenericJavaVirtualJoinTable(VirtualJoinTable.ParentAdapter parentAdapter, JoinTable overriddenTable) {
        super(parentAdapter, overriddenTable);
        this.specifiedInverseJoinColumnContainer = this.buildSpecifiedInverseJoinColumnContainer();
    }

    @Override
    public void update() {
        super.update();
        this.updateSpecifiedInverseJoinColumns();
        this.updateDefaultInverseJoinColumn();
    }

    public ListIterable<VirtualJoinColumn> getInverseJoinColumns() {
        return this.hasSpecifiedInverseJoinColumns() ? this.getSpecifiedInverseJoinColumns() : this.getDefaultInverseJoinColumns();
    }

    @Override
    public int getInverseJoinColumnsSize() {
        return this.hasSpecifiedInverseJoinColumns() ? this.getSpecifiedInverseJoinColumnsSize() : this.getDefaultInverseJoinColumnsSize();
    }

    public ListIterable<VirtualJoinColumn> getSpecifiedInverseJoinColumns() {
        return this.specifiedInverseJoinColumnContainer;
    }

    @Override
    public int getSpecifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumnContainer.size();
    }

    @Override
    public boolean hasSpecifiedInverseJoinColumns() {
        return this.getSpecifiedInverseJoinColumnsSize() != 0;
    }

    @Override
    public VirtualJoinColumn getSpecifiedInverseJoinColumn(int index) {
        return (VirtualJoinColumn)this.specifiedInverseJoinColumnContainer.get(index);
    }

    protected void updateSpecifiedInverseJoinColumns() {
        this.specifiedInverseJoinColumnContainer.update();
    }

    protected ListIterable<JoinColumn> getOverriddenInverseJoinColumns() {
        return new SuperListIterableWrapper(((JoinTable)this.getOverriddenTable()).getSpecifiedInverseJoinColumns());
    }

    protected void moveSpecifiedInverseJoinColumn(int index, VirtualJoinColumn joinColumn) {
        this.specifiedInverseJoinColumnContainer.move(index, joinColumn);
    }

    protected VirtualJoinColumn addSpecifiedInverseJoinColumn(int index, JoinColumn joinColumn) {
        return (VirtualJoinColumn)this.specifiedInverseJoinColumnContainer.addContextElement(index, joinColumn);
    }

    protected void removeSpecifiedInverseJoinColumn(VirtualJoinColumn joinColumn) {
        this.specifiedInverseJoinColumnContainer.remove(joinColumn);
    }

    protected AbstractJpaContextModel.ContextListContainer<VirtualJoinColumn, JoinColumn> buildSpecifiedInverseJoinColumnContainer() {
        return this.buildVirtualContextListContainer("specifiedInverseJoinColumns", new SpecifiedInverseJoinColumnContainerAdapter());
    }

    @Override
    public VirtualJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(VirtualJoinColumn joinColumn) {
        VirtualJoinColumn old = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = joinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", old, joinColumn);
    }

    protected ListIterable<VirtualJoinColumn> getDefaultInverseJoinColumns() {
        return this.defaultInverseJoinColumn != null ? new SingleElementListIterable((Object)this.defaultInverseJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultInverseJoinColumn() {
        if (this.buildsDefaultInverseJoinColumn()) {
            if (this.defaultInverseJoinColumn == null) {
                this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(((JoinTable)this.getOverriddenTable()).getDefaultInverseJoinColumn()));
            } else {
                this.defaultInverseJoinColumn.update();
            }
        } else {
            this.setDefaultInverseJoinColumn(null);
        }
    }

    protected boolean buildsDefaultInverseJoinColumn() {
        return !this.hasSpecifiedInverseJoinColumns();
    }

    protected VirtualJoinTableRelationshipStrategy getRelationshipStrategy() {
        return (VirtualJoinTableRelationshipStrategy)this.parent;
    }

    @Override
    protected JoinColumn.ParentAdapter buildJoinColumnParentAdapter() {
        return new JoinColumnParentAdapter();
    }

    protected JoinColumn.ParentAdapter buildInverseJoinColumnParentAdapter() {
        return new InverseJoinColumnParentAdapter();
    }

    protected VirtualJoinColumn buildInverseJoinColumn(JoinColumn joinColumn) {
        return this.buildJoinColumn(this.inverseJoinColumnParentAdapter, joinColumn);
    }

    @Override
    protected String buildDefaultName() {
        return this.getRelationshipStrategy().getJoinTableDefaultName();
    }

    @Override
    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationshipStrategy().getRelationship().getMapping();
    }

    @Override
    public SpecifiedPersistentAttribute getPersistentAttribute() {
        return this.getRelationshipMapping().getPersistentAttribute();
    }

    @Override
    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter) {
        super.validateJoinColumns(messages, reporter);
        this.validateModels((Iterable<? extends JpaContextModel>)this.getInverseJoinColumns(), messages, reporter);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getRelationshipStrategy().validatesAgainstDatabase();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractJoinColumnParentAdapter
    implements JoinColumn.ParentAdapter {
        @Override
        public JpaContextModel getColumnParent() {
            return GenericJavaVirtualJoinTable.this;
        }

        @Override
        public String getDefaultColumnName(NamedColumn column) {
            return MappingTools.buildJoinColumnDefaultName((JoinColumn)column, this);
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return ObjectTools.notEquals((Object)this.getDefaultTableName(), (Object)tableName);
        }

        @Override
        public Iterable<String> getCandidateTableNames() {
            return EmptyIterable.instance();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return ObjectTools.equals((Object)GenericJavaVirtualJoinTable.this.getName(), (Object)tableName) ? GenericJavaVirtualJoinTable.this.getDbTable() : null;
        }

        @Override
        public String getDefaultTableName() {
            return GenericJavaVirtualJoinTable.this.getName();
        }

        @Override
        public TextRange getValidationTextRange() {
            return GenericJavaVirtualJoinTable.this.getValidationTextRange();
        }

        protected VirtualRelationship getRelationship() {
            return GenericJavaVirtualJoinTable.this.getRelationshipStrategy().getRelationship();
        }
    }

    public class InverseJoinColumnParentAdapter
    extends AbstractJoinColumnParentAdapter {
        public Entity getRelationshipTarget() {
            RelationshipMapping relationshipMapping = GenericJavaVirtualJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            RelationshipMapping relationshipMapping = GenericJavaVirtualJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getName();
        }

        public Table getReferencedColumnDbTable() {
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
        }

        public int getJoinColumnsSize() {
            return GenericJavaVirtualJoinTable.this.getInverseJoinColumnsSize();
        }

        public JpaValidator buildColumnValidator(NamedColumn column) {
            return GenericJavaVirtualJoinTable.this.getRelationshipStrategy().buildJoinTableInverseJoinColumnValidator((JoinColumn)column, this);
        }
    }

    public class JoinColumnParentAdapter
    extends AbstractJoinColumnParentAdapter {
        public Entity getRelationshipTarget() {
            return this.getRelationship().getEntity();
        }

        public String getAttributeName() {
            return MappingTools.getTargetAttributeName(GenericJavaVirtualJoinTable.this.getRelationshipMapping());
        }

        public Table getReferencedColumnDbTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        protected TypeMapping getTypeMapping() {
            return this.getRelationship().getTypeMapping();
        }

        public int getJoinColumnsSize() {
            return GenericJavaVirtualJoinTable.this.getJoinColumnsSize();
        }

        public JpaValidator buildColumnValidator(NamedColumn column) {
            return GenericJavaVirtualJoinTable.this.getRelationshipStrategy().buildJoinTableJoinColumnValidator((JoinColumn)column, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpecifiedInverseJoinColumnContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<VirtualJoinColumn, JoinColumn> {
        public SpecifiedInverseJoinColumnContainerAdapter() {
            super(GenericJavaVirtualJoinTable.this);
        }

        @Override
        public VirtualJoinColumn buildContextElement(JoinColumn resourceElement) {
            return GenericJavaVirtualJoinTable.this.buildInverseJoinColumn(resourceElement);
        }

        @Override
        public ListIterable<JoinColumn> getResourceElements() {
            return GenericJavaVirtualJoinTable.this.getOverriddenInverseJoinColumns();
        }

        @Override
        public JoinColumn extractResourceElement(VirtualJoinColumn contextElement) {
            return contextElement.getOverriddenColumn();
        }
    }
}

