/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.jpa.core.context.DatabaseGenerator;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.SequenceGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaSequenceGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmDatabaseGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.jpa.db.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmSequenceGenerator
extends AbstractOrmDatabaseGenerator<XmlSequenceGenerator>
implements OrmSequenceGenerator {
    protected String specifiedSequenceName;
    protected String defaultSequenceName;

    protected AbstractOrmSequenceGenerator(JpaContextModel parent, XmlSequenceGenerator xmlSequenceGenerator) {
        super(parent, xmlSequenceGenerator);
        this.specifiedSequenceName = xmlSequenceGenerator.getSequenceName();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedSequenceName_(((XmlSequenceGenerator)this.xmlGenerator).getSequenceName());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultSequenceName(this.buildDefaultSequenceName());
    }

    @Override
    protected int buildDefaultInitialValue() {
        return 1;
    }

    @Override
    public String getSequenceName() {
        return this.specifiedSequenceName != null ? this.specifiedSequenceName : this.defaultSequenceName;
    }

    @Override
    public String getSpecifiedSequenceName() {
        return this.specifiedSequenceName;
    }

    @Override
    public void setSpecifiedSequenceName(String specifiedSequenceName) {
        this.setSpecifiedSequenceName_(specifiedSequenceName);
        ((XmlSequenceGenerator)this.xmlGenerator).setSequenceName(specifiedSequenceName);
    }

    protected void setSpecifiedSequenceName_(String specifiedSequenceName) {
        String old = this.specifiedSequenceName;
        this.specifiedSequenceName = specifiedSequenceName;
        this.firePropertyChanged("specifiedSequenceName", old, specifiedSequenceName);
    }

    @Override
    public String getDefaultSequenceName() {
        return this.defaultSequenceName;
    }

    protected void setDefaultSequenceName(String defaultSequenceName) {
        String old = this.defaultSequenceName;
        this.defaultSequenceName = defaultSequenceName;
        this.firePropertyChanged("defaultSequenceName", old, defaultSequenceName);
    }

    protected String buildDefaultSequenceName() {
        return null;
    }

    @Override
    public Class<SequenceGenerator> getGeneratorType() {
        return SequenceGenerator.class;
    }

    @Override
    protected boolean isEquivalentTo_(DatabaseGenerator other) {
        return super.isEquivalentTo_(other) && this.isEquivalentTo_((SequenceGenerator)other);
    }

    protected boolean isEquivalentTo_(SequenceGenerator other) {
        return ObjectTools.equals((Object)this.specifiedSequenceName, (Object)other.getSpecifiedSequenceName());
    }

    @Override
    public void convertFrom(JavaSequenceGenerator javaGenerator) {
        super.convertFrom(javaGenerator);
        this.setSpecifiedSequenceName(javaGenerator.getSpecifiedSequenceName());
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.sequenceNameTouches(pos)) {
            return this.getCandidateSequences();
        }
        return null;
    }

    protected boolean sequenceNameTouches(int pos) {
        return ((XmlSequenceGenerator)this.xmlGenerator).sequenceNameTouches(pos);
    }

    protected Iterable<String> getCandidateSequences() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.getSortedSequenceIdentifiers() : EmptyIterable.instance();
    }
}

