/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXmlEnumValue;
import org.eclipse.text.edits.ReplaceEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistenceUnitProperties
extends AbstractModel
implements PersistenceUnitProperties {
    private PersistenceUnit persistenceUnit;
    private Map<String, String> propertyNames;
    public static final String PROPERTY_VALUE_DELIMITER = ",";
    private static final long serialVersionUID = 1L;

    protected AbstractPersistenceUnitProperties(PersistenceUnit parent) {
        this.initialize();
        this.initialize(parent);
        this.postInitialize();
    }

    protected void initialize() {
        this.propertyNames = new HashMap<String, String>();
    }

    protected void initialize(PersistenceUnit parent) {
        this.persistenceUnit = parent;
        this.initializePropertyNames();
        this.initializeProperties();
    }

    protected void initializePropertyNames() {
        this.addPropertyNames(this.propertyNames);
    }

    protected abstract void initializeProperties();

    protected void postInitialize() {
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return this.persistenceUnit;
    }

    @Override
    public JpaProject getJpaProject() {
        return this.persistenceUnit.getJpaProject();
    }

    protected abstract void addPropertyNames(Map<String, String> var1);

    @Override
    public boolean itemIsProperty(PersistenceUnit.Property item) {
        if (item == null) {
            throw new NullPointerException();
        }
        return this.propertyNames().keySet().contains(item.getName());
    }

    @Override
    public String propertyIdOf(PersistenceUnit.Property property) {
        String propertyId = this.propertyNames().get(property.getName());
        if (propertyId == null) {
            throw new IllegalArgumentException("Illegal property: " + property);
        }
        return propertyId;
    }

    public String propertyIdOf(String eclipseLinkkey) {
        String propertyId = this.propertyNames().get(eclipseLinkkey);
        if (propertyId == null) {
            throw new IllegalArgumentException("Illegal property: " + eclipseLinkkey);
        }
        return propertyId;
    }

    protected String persistenceUnitKeyOf(String propertyId) {
        for (String persistenceUnitKey : this.propertyNames().keySet()) {
            if (!this.propertyNames().get(persistenceUnitKey).equals(propertyId)) continue;
            return persistenceUnitKey;
        }
        throw new IllegalArgumentException("Illegal property ID: " + propertyId);
    }

    protected void putProperty(String propertyId, String value) {
        this.putProperty(propertyId, value, false);
    }

    protected void putProperty(String propertyId, String value, boolean allowDuplicates) {
        String persistenceUnitKey = this.persistenceUnitKeyOf(propertyId);
        this.putPersistenceUnitProperty(persistenceUnitKey, null, value, allowDuplicates);
    }

    protected void putProperty(String propertyId, Boolean value) {
        this.putProperty(propertyId, value, false);
    }

    protected void putProperty(String propertyId, Boolean value, boolean allowDuplicates) {
        this.putProperty(propertyId, this.getPropertyStringValueOf(value), allowDuplicates);
    }

    protected void putProperty(String propertyId, Integer value) {
        this.putProperty(propertyId, value, false);
    }

    protected void putProperty(String propertyId, Integer value, boolean allowDuplicates) {
        this.putProperty(propertyId, this.getPropertyStringValueOf(value), allowDuplicates);
    }

    protected void putProperty(String propertyId, PersistenceXmlEnumValue value) {
        this.putProperty(propertyId, value, false);
    }

    protected void putProperty(String propertyId, PersistenceXmlEnumValue value, boolean allowDuplicates) {
        this.putProperty(propertyId, this.getPropertyStringValueOf(value), allowDuplicates);
    }

    protected void removeProperty(String propertyId, String value) {
        String persistenceUnitKey = this.persistenceUnitKeyOf(propertyId);
        this.getPersistenceUnit().removeProperty(persistenceUnitKey, value);
    }

    protected boolean persistenceUnitKeyExists(String persistenceUnitKey) {
        return this.getStringValue(persistenceUnitKey) != null;
    }

    protected String getStringValue(String persistenceUnitKey) {
        PersistenceUnit.Property p = this.getPersistenceUnit().getProperty(persistenceUnitKey);
        return p == null ? null : p.getValue();
    }

    protected String getStringValue(String key, String keySuffix) {
        return this.getStringValue(keySuffix == null ? key : String.valueOf(key) + keySuffix);
    }

    protected void putStringValue(String key, String newValue) {
        this.putStringValue(key, null, newValue, false);
    }

    protected void putStringValue(String key, String newValue, boolean allowDuplicate) {
        this.putStringValue(key, null, newValue, allowDuplicate);
    }

    protected void putStringValue(String key, String keySuffix, String newValue, boolean allowDuplicate) {
        this.putPersistenceUnitProperty(key, keySuffix, newValue, allowDuplicate);
    }

    protected Integer getIntegerValue(String persistenceUnitKey) {
        PersistenceUnit.Property p = this.getPersistenceUnit().getProperty(persistenceUnitKey);
        return p == null ? null : this.getIntegerValueOf(p.getValue());
    }

    protected Integer getIntegerValueOf(String puStringValue) {
        if (StringTools.isBlank((String)puStringValue)) {
            return null;
        }
        try {
            return Integer.valueOf(puStringValue);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected Integer getIntegerValue(String key, String keySuffix) {
        return this.getIntegerValue(keySuffix == null ? key : String.valueOf(key) + keySuffix);
    }

    protected void putIntegerValue(String key, Integer newValue) {
        this.putIntegerValue(key, null, newValue, false);
    }

    protected void putIntegerValue(String key, Integer newValue, boolean allowDuplicate) {
        this.putIntegerValue(key, null, newValue, allowDuplicate);
    }

    protected void putIntegerValue(String key, String keySuffix, Integer newValue, boolean allowDuplicate) {
        this.putPersistenceUnitProperty(key, keySuffix, this.getPropertyStringValueOf(newValue), allowDuplicate);
    }

    protected Boolean getBooleanValue(String persistenceUnitKey) {
        PersistenceUnit.Property p = this.getPersistenceUnit().getProperty(persistenceUnitKey);
        return p == null ? null : this.getBooleanValueOf(p.getValue());
    }

    protected Boolean getBooleanValueOf(String puStringValue) {
        if (StringTools.isBlank((String)puStringValue)) {
            return null;
        }
        return Boolean.valueOf(puStringValue);
    }

    protected Boolean getBooleanValue(String key, String keySuffix) {
        return this.getBooleanValue(keySuffix == null ? key : String.valueOf(key) + keySuffix);
    }

    protected void putBooleanValue(String key, Boolean newValue) {
        this.putBooleanValue(key, null, newValue, false);
    }

    protected void putBooleanValue(String key, Boolean newValue, boolean allowDuplicate) {
        this.putBooleanValue(key, null, newValue, allowDuplicate);
    }

    protected void putBooleanValue(String key, String keySuffix, Boolean newValue, boolean allowDuplicate) {
        this.putPersistenceUnitProperty(key, keySuffix, this.getPropertyStringValueOf(newValue), allowDuplicate);
    }

    protected <T extends PersistenceXmlEnumValue> T getEnumValue(String persistenceUnitKey, T[] enumValues) {
        PersistenceUnit.Property p = this.getPersistenceUnit().getProperty(persistenceUnitKey);
        return (T)(p == null ? null : this.getEnumValueOf(p.getValue(), (PersistenceXmlEnumValue[])enumValues));
    }

    protected <T extends PersistenceXmlEnumValue> T getEnumValue(String key, String keySuffix, T[] enumValues) {
        return (T)this.getEnumValue(keySuffix == null ? key : String.valueOf(key) + keySuffix, (PersistenceXmlEnumValue[])enumValues);
    }

    protected <T extends PersistenceXmlEnumValue> void putEnumValue(String key, T newValue) {
        this.putEnumValue(key, null, newValue, false);
    }

    protected <T extends PersistenceXmlEnumValue> void putEnumValue(String key, T newValue, boolean allowDuplicate) {
        this.putEnumValue(key, null, newValue, allowDuplicate);
    }

    protected <T extends PersistenceXmlEnumValue> void putEnumValue(String key, String keySuffix, T newValue, boolean allowDuplicate) {
        this.putPersistenceUnitProperty(key, keySuffix, this.getPropertyStringValueOf(newValue), allowDuplicate);
    }

    protected List<String> getCompositeValue(String persistenceUnitKey) {
        String values = this.getStringValue(persistenceUnitKey);
        return this.extractCompositeValue(values);
    }

    protected void putPropertyCompositeValue(String key, String valueToAppend) {
        String persistenceUnitKey = this.persistenceUnitKeyOf(key);
        String persistenceUnitValue = this.buildCompositeValue(this.getStringValue(persistenceUnitKey), valueToAppend);
        this.putPersistenceUnitProperty(persistenceUnitKey, null, persistenceUnitValue, false);
    }

    protected void removePropertyCompositeValue(String key, String valueToRemove) {
        String persistenceUnitKey = this.persistenceUnitKeyOf(key);
        String persistenceUnitValue = this.removeValueFrom(this.getStringValue(persistenceUnitKey), valueToRemove.trim());
        this.putPersistenceUnitProperty(persistenceUnitKey, null, persistenceUnitValue, false);
    }

    protected <T extends PersistenceXmlEnumValue> T getEnumValueOf(String puStringValue, T[] enumValues) {
        T[] TArray = enumValues;
        int n = enumValues.length;
        int n2 = 0;
        while (n2 < n) {
            T enumValue = TArray[n2];
            if (this.getPropertyStringValueOf((PersistenceXmlEnumValue)enumValue).equals(puStringValue)) {
                return enumValue;
            }
            ++n2;
        }
        return null;
    }

    protected String getPropertyStringValueOf(PersistenceXmlEnumValue value) {
        if (value == null) {
            return null;
        }
        return value.getPropertyValue();
    }

    protected String getPropertyStringValueOf(Boolean value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    protected String getPropertyStringValueOf(Integer value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private Map<String, String> propertyNames() {
        return this.propertyNames;
    }

    private void putPersistenceUnitProperty(String key, String keySuffix, String stringValue, boolean allowDuplicates) {
        String persistenceUnitKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        this.getPersistenceUnit().setProperty(persistenceUnitKey, stringValue, allowDuplicates);
    }

    private String buildCompositeValue(String value, String valueToAppend) {
        if (StringTools.isBlank((String)valueToAppend)) {
            return value;
        }
        return StringTools.isBlank((String)value) ? valueToAppend : String.valueOf(value) + PROPERTY_VALUE_DELIMITER + valueToAppend;
    }

    protected List<String> extractCompositeValue(String compositeValue) {
        if (StringTools.isBlank((String)compositeValue)) {
            return new ArrayList<String>(0);
        }
        String[] values = compositeValue.split(PROPERTY_VALUE_DELIMITER);
        ArrayList<String> results = new ArrayList<String>(values.length);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            results.add(value.trim());
            ++n2;
        }
        return results;
    }

    private String removeValueFrom(String compositeValue, String valueToRemove) {
        if (StringTools.isBlank((String)valueToRemove)) {
            return compositeValue;
        }
        String[] values = compositeValue.split(PROPERTY_VALUE_DELIMITER);
        ArrayList<String> results = new ArrayList<String>(values.length);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (!value.trim().equals(valueToRemove)) {
                results.add(value);
            }
            ++n2;
        }
        if (results.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder(values.length);
        for (String value : results) {
            sb.append(value).append(PROPERTY_VALUE_DELIMITER);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return EmptyIterable.instance();
    }
}

