/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractNamedColumnValidator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJoinColumnValidator<C extends BaseJoinColumn>
extends AbstractNamedColumnValidator<C> {
    protected final BaseJoinColumn.ParentAdapter joinColumnParentAdapter;

    protected BaseJoinColumnValidator(C column, BaseJoinColumn.ParentAdapter joinColumnParentAdapter, AbstractNamedColumnValidator.TableDescriptionProvider provider) {
        super(column, provider);
        this.joinColumnParentAdapter = joinColumnParentAdapter;
    }

    protected BaseJoinColumnValidator(PersistentAttribute persistentAttribute, C column, BaseJoinColumn.ParentAdapter joinColumnParentAdapter, AbstractNamedColumnValidator.TableDescriptionProvider provider) {
        super(persistentAttribute, column, provider);
        this.joinColumnParentAdapter = joinColumnParentAdapter;
    }

    @Override
    protected void validateName(List<IMessage> messages) {
        this.validateJoinColumnName(messages);
        this.validateReferencedColumnName(messages);
    }

    protected void validateJoinColumnName(List<IMessage> messages) {
        if (((BaseJoinColumn)this.column).getSpecifiedName() == null && this.joinColumnParentAdapter.getJoinColumnsSize() > 1) {
            messages.add(this.buildUnspecifiedNameMultipleJoinColumnsMessage());
        } else if (((BaseJoinColumn)this.column).getName() != null) {
            super.validateName(messages);
        }
    }

    protected void validateReferencedColumnName(List<IMessage> messages) {
        if (((BaseJoinColumn)this.column).getSpecifiedReferencedColumnName() == null && this.joinColumnParentAdapter.getJoinColumnsSize() > 1) {
            messages.add(this.buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage());
        } else if (((BaseJoinColumn)this.column).getSpecifiedReferencedColumnName() != null && ((BaseJoinColumn)this.column).getReferencedColumnDbTable() != null && !((BaseJoinColumn)this.column).referencedColumnIsResolved()) {
            messages.add(this.buildUnresolvedReferencedColumnNameMessage());
        }
    }

    protected IMessage buildUnresolvedReferencedColumnNameMessage() {
        return this.columnIsPartOfVirtualAttribute() ? this.buildVirtualAttributeUnresolvedReferencedColumnNameMessage() : this.buildUnresolvedReferencedColumnNameMessage(this.getUnresolvedReferencedColumnNameMessage());
    }

    protected abstract ValidationMessage getUnresolvedReferencedColumnNameMessage();

    protected IMessage buildUnresolvedReferencedColumnNameMessage(ValidationMessage message) {
        return ValidationMessageTools.buildValidationMessage((IResource)((BaseJoinColumn)this.column).getResource(), (TextRange)((BaseJoinColumn)this.column).getReferencedColumnNameTextRange(), (ValidationMessage)message, (Object[])new Object[]{((BaseJoinColumn)this.column).getReferencedColumnName(), ((BaseJoinColumn)this.column).getReferencedColumnDbTable().getName()});
    }

    protected IMessage buildVirtualAttributeUnresolvedReferencedColumnNameMessage() {
        return ValidationMessageTools.buildValidationMessage((IResource)((BaseJoinColumn)this.column).getResource(), (TextRange)this.getVirtualAttributeTextRange(), (ValidationMessage)this.getVirtualAttributeUnresolvedReferencedColumnNameMessage(), (Object[])new Object[]{this.persistentAttribute.getName(), ((BaseJoinColumn)this.column).getReferencedColumnName(), ((BaseJoinColumn)this.column).getReferencedColumnDbTable().getName()});
    }

    protected abstract ValidationMessage getVirtualAttributeUnresolvedReferencedColumnNameMessage();

    protected IMessage buildUnspecifiedNameMultipleJoinColumnsMessage() {
        return this.columnIsPartOfVirtualAttribute() ? this.buildVirtualAttributeUnspecifiedNameMultipleJoinColumnsMessage() : this.buildUnspecifiedNameMultipleJoinColumnsMessage(this.getUnspecifiedNameMultipleJoinColumnsMessage());
    }

    protected abstract ValidationMessage getUnspecifiedNameMultipleJoinColumnsMessage();

    protected IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(ValidationMessage message) {
        return ValidationMessageTools.buildValidationMessage((IResource)((BaseJoinColumn)this.column).getResource(), (TextRange)((BaseJoinColumn)this.column).getNameValidationTextRange(), (ValidationMessage)message);
    }

    protected IMessage buildVirtualAttributeUnspecifiedNameMultipleJoinColumnsMessage() {
        return ValidationMessageTools.buildValidationMessage((IResource)((BaseJoinColumn)this.column).getResource(), (TextRange)this.getVirtualAttributeTextRange(), (ValidationMessage)this.getVirtualAttributeUnspecifiedNameMultipleJoinColumnsMessage(), (Object[])new Object[]{this.persistentAttribute.getName()});
    }

    protected abstract ValidationMessage getVirtualAttributeUnspecifiedNameMultipleJoinColumnsMessage();

    protected IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage() {
        return this.columnIsPartOfVirtualAttribute() ? this.buildVirtualAttributeUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage() : this.buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(this.getUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage());
    }

    protected abstract ValidationMessage getUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage();

    protected IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(ValidationMessage message) {
        return ValidationMessageTools.buildValidationMessage((IResource)((BaseJoinColumn)this.column).getResource(), (TextRange)((BaseJoinColumn)this.column).getReferencedColumnNameTextRange(), (ValidationMessage)message);
    }

    protected IMessage buildVirtualAttributeUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage() {
        return ValidationMessageTools.buildValidationMessage((IResource)((BaseJoinColumn)this.column).getResource(), (TextRange)this.getVirtualAttributeTextRange(), (ValidationMessage)this.getVirtualAttributeUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(), (Object[])new Object[]{this.persistentAttribute.getName()});
    }

    protected abstract ValidationMessage getVirtualAttributeUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage();
}

