/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.Collections;
import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.java.JavaNamedQuery;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmQuery;
import org.eclipse.jpt.jpa.core.jpa2.context.LockModeType2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.NamedQuery2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaNamedQuery2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmNamedQuery2_0;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.core.resource.orm.XmlNamedQuery;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericOrmNamedQuery
extends AbstractOrmQuery<XmlNamedQuery>
implements OrmNamedQuery2_0 {
    protected String query;
    private LockModeType2_0 specifiedLockMode;
    private LockModeType2_0 defaultLockMode;

    public GenericOrmNamedQuery(JpaContextModel parent, XmlNamedQuery resourceNamedQuery) {
        super(parent, resourceNamedQuery);
        this.query = ((XmlNamedQuery)this.xmlQuery).getQuery();
        this.specifiedLockMode = this.buildSpecifiedLockMode();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setQuery_(((XmlNamedQuery)this.xmlQuery).getQuery());
        this.setSpecifiedLockMode_(this.buildSpecifiedLockMode());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultLockMode(this.buildDefaultLockMode());
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        this.setQuery_(query);
        ((XmlNamedQuery)this.xmlQuery).setQuery(query);
    }

    protected void setQuery_(String query) {
        String old = this.query;
        this.query = query;
        this.firePropertyChanged("query", old, query);
    }

    @Override
    public LockModeType2_0 getLockMode() {
        return this.specifiedLockMode != null ? this.specifiedLockMode : this.defaultLockMode;
    }

    @Override
    public LockModeType2_0 getSpecifiedLockMode() {
        return this.specifiedLockMode;
    }

    @Override
    public void setSpecifiedLockMode(LockModeType2_0 lockMode) {
        this.setSpecifiedLockMode_(lockMode);
        ((XmlNamedQuery)this.xmlQuery).setLockMode(LockModeType2_0.toOrmResourceModel(lockMode));
    }

    public void setSpecifiedLockMode_(LockModeType2_0 lockMode) {
        LockModeType2_0 old = this.specifiedLockMode;
        this.specifiedLockMode = lockMode;
        this.firePropertyChanged("specifiedLockMode", (Object)old, (Object)lockMode);
    }

    protected LockModeType2_0 buildSpecifiedLockMode() {
        return this.isJpa2_0Compatible() ? LockModeType2_0.fromOrmResourceModel(((XmlNamedQuery)this.xmlQuery).getLockMode()) : null;
    }

    @Override
    public LockModeType2_0 getDefaultLockMode() {
        return this.defaultLockMode;
    }

    protected void setDefaultLockMode(LockModeType2_0 lockMode) {
        LockModeType2_0 old = this.defaultLockMode;
        this.defaultLockMode = lockMode;
        this.firePropertyChanged("defaultLockMode", (Object)old, (Object)lockMode);
    }

    protected LockModeType2_0 buildDefaultLockMode() {
        return this.isJpa2_0Compatible() ? LockModeType2_0.NONE : null;
    }

    @Override
    public void convertFrom(JavaNamedQuery javaQuery) {
        super.convertFrom(javaQuery);
        this.setQuery(javaQuery.getQuery());
        if (this.isJpa2_0Compatible()) {
            this.setSpecifiedLockMode(((JavaNamedQuery2_0)javaQuery).getSpecifiedLockMode());
        }
    }

    @Override
    public void validate(JpaJpqlQueryHelper queryHelper, List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateQuery(queryHelper, messages, reporter);
    }

    protected void validateQuery(JpaJpqlQueryHelper queryHelper, List<IMessage> messages, IReporter reporter) {
        if (StringTools.isBlank((String)this.query)) {
            messages.add(this.buildValidationMessage(this.getNameTextRange(), JptJpaCoreValidationMessages.QUERY_STATEMENT_UNDEFINED, this.name));
        } else {
            this.validateQuery_(queryHelper, messages, reporter);
        }
    }

    protected void validateQuery_(JpaJpqlQueryHelper queryHelper, List<IMessage> messages, IReporter reporter) {
        XmlNamedQuery xmlQuery = (XmlNamedQuery)this.getXmlQuery();
        JpaJpqlQueryHelper.EscapeType escapeType = xmlQuery.isQueryInsideCDATASection() ? JpaJpqlQueryHelper.EscapeType.NONE : JpaJpqlQueryHelper.EscapeType.XML;
        queryHelper.validate(this, this.query, xmlQuery.getActualQuery(), this.getQueryTextRanges(), xmlQuery.getQueryOffset(), escapeType, messages);
    }

    @Override
    public List<TextRange> getQueryTextRanges() {
        return Collections.singletonList(((XmlNamedQuery)this.xmlQuery).getQueryTextRange());
    }

    @Override
    protected boolean isEquivalentTo_(Query other) {
        return super.isEquivalentTo_(other) && this.isEquivalentTo_((NamedQuery)other);
    }

    protected boolean isEquivalentTo_(NamedQuery other) {
        boolean queriesEquivalent = ObjectTools.equals((Object)this.query, (Object)other.getQuery());
        if (this.isJpa2_0Compatible()) {
            return queriesEquivalent && this.isEquivalentTo_((NamedQuery2_0)other);
        }
        return queriesEquivalent;
    }

    protected boolean isEquivalentTo_(NamedQuery2_0 other) {
        return this.specifiedLockMode == other.getSpecifiedLockMode();
    }

    @Override
    public Class<NamedQuery> getQueryType() {
        return NamedQuery.class;
    }
}

