/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.VirtualReferenceTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedReferenceTable;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmTable;
import org.eclipse.jpt.jpa.core.resource.orm.AbstractXmlReferenceTable;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericOrmReferenceTable<P extends JpaContextModel, PA extends Table.ParentAdapter<P>, X extends AbstractXmlReferenceTable>
extends AbstractOrmTable<P, PA, X>
implements OrmSpecifiedReferenceTable {
    protected final AbstractJpaContextModel.ContextListContainer<OrmSpecifiedJoinColumn, XmlJoinColumn> specifiedJoinColumnContainer;
    protected final JoinColumn.ParentAdapter joinColumnParentAdapter = this.buildJoinColumnParentAdapter();
    protected OrmSpecifiedJoinColumn defaultJoinColumn;

    protected GenericOrmReferenceTable(PA parentAdapter) {
        super(parentAdapter);
        this.specifiedJoinColumnContainer = this.buildSpecifiedJoinColumnContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedJoinColumns();
    }

    @Override
    public void update() {
        super.update();
        this.updateModels((Iterable<? extends JpaContextModel>)this.getSpecifiedJoinColumns());
        this.updateDefaultJoinColumn();
    }

    @Override
    public ListIterable<OrmSpecifiedJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    @Override
    public void convertDefaultJoinColumnToSpecified() {
        MappingTools.convertReferenceTableDefaultToSpecifiedJoinColumn(this);
    }

    @Override
    public ListIterable<OrmSpecifiedJoinColumn> getSpecifiedJoinColumns() {
        return this.specifiedJoinColumnContainer;
    }

    @Override
    public int getSpecifiedJoinColumnsSize() {
        return this.specifiedJoinColumnContainer.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.getSpecifiedJoinColumnsSize() != 0;
    }

    @Override
    public OrmSpecifiedJoinColumn getSpecifiedJoinColumn(int index) {
        return (OrmSpecifiedJoinColumn)this.specifiedJoinColumnContainer.get(index);
    }

    @Override
    public OrmSpecifiedJoinColumn addSpecifiedJoinColumn() {
        return this.addSpecifiedJoinColumn(this.getSpecifiedJoinColumnsSize());
    }

    @Override
    public OrmSpecifiedJoinColumn addSpecifiedJoinColumn(int index) {
        AbstractXmlReferenceTable xmlTable = (AbstractXmlReferenceTable)this.getXmlTableForUpdate();
        XmlJoinColumn xmlJoinColumn = this.buildXmlJoinColumn();
        OrmSpecifiedJoinColumn joinColumn = (OrmSpecifiedJoinColumn)this.specifiedJoinColumnContainer.addContextElement(index, xmlJoinColumn);
        xmlTable.getJoinColumns().add(index, (Object)xmlJoinColumn);
        return joinColumn;
    }

    protected XmlJoinColumn buildXmlJoinColumn() {
        return OrmFactory.eINSTANCE.createXmlJoinColumn();
    }

    @Override
    public void removeSpecifiedJoinColumn(SpecifiedJoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumnContainer.indexOf((OrmSpecifiedJoinColumn)joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        this.specifiedJoinColumnContainer.remove(index);
        ((AbstractXmlReferenceTable)this.getXmlTable()).getJoinColumns().remove(index);
        this.removeXmlTableIfUnset();
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        this.specifiedJoinColumnContainer.move(targetIndex, sourceIndex);
        ((AbstractXmlReferenceTable)this.getXmlTable()).getJoinColumns().move(targetIndex, sourceIndex);
    }

    @Override
    public void clearSpecifiedJoinColumns() {
        this.specifiedJoinColumnContainer.clear();
        ((AbstractXmlReferenceTable)this.getXmlTable()).getJoinColumns().clear();
    }

    protected void syncSpecifiedJoinColumns() {
        this.specifiedJoinColumnContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlJoinColumn> getXmlJoinColumns() {
        AbstractXmlReferenceTable xmlTable = (AbstractXmlReferenceTable)this.getXmlTable();
        return xmlTable == null ? EmptyListIterable.instance() : IterableTools.cloneLive(xmlTable.getJoinColumns());
    }

    protected AbstractJpaContextModel.ContextListContainer<OrmSpecifiedJoinColumn, XmlJoinColumn> buildSpecifiedJoinColumnContainer() {
        return this.buildSpecifiedContextListContainer("specifiedJoinColumns", new SpecifiedJoinColumnContainerAdapter());
    }

    protected abstract JoinColumn.ParentAdapter buildJoinColumnParentAdapter();

    @Override
    public OrmSpecifiedJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmSpecifiedJoinColumn joinColumn) {
        OrmSpecifiedJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmSpecifiedJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(null));
            } else {
                this.defaultJoinColumn.update();
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns();
    }

    protected void initializeFrom(OrmSpecifiedReferenceTable oldTable) {
        super.initializeFrom(oldTable);
        for (OrmSpecifiedJoinColumn joinColumn : oldTable.getSpecifiedJoinColumns()) {
            this.addSpecifiedJoinColumn().initializeFrom(joinColumn);
        }
    }

    protected void initializeFrom(VirtualReferenceTable virtualTable) {
        super.initializeFrom(virtualTable);
        for (VirtualJoinColumn joinColumn : virtualTable.getJoinColumns()) {
            this.addSpecifiedJoinColumn().initializeFrom(joinColumn);
        }
    }

    protected OrmSpecifiedJoinColumn buildJoinColumn(XmlJoinColumn xmlJoinColumn) {
        return this.getContextModelFactory().buildOrmJoinColumn(this.joinColumnParentAdapter, xmlJoinColumn);
    }

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        boolean continueValidating = this.buildTableValidator().validate(messages, reporter);
        if (continueValidating) {
            this.validateJoinColumns(messages, reporter);
        }
    }

    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter) {
        this.validateModels((Iterable<? extends JpaContextModel>)this.getJoinColumns(), messages, reporter);
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (OrmSpecifiedJoinColumn column : this.getJoinColumns()) {
            result = column.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpecifiedJoinColumnContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<OrmSpecifiedJoinColumn, XmlJoinColumn> {
        @Override
        public OrmSpecifiedJoinColumn buildContextElement(XmlJoinColumn resourceElement) {
            return GenericOrmReferenceTable.this.buildJoinColumn(resourceElement);
        }

        @Override
        public ListIterable<XmlJoinColumn> getResourceElements() {
            return GenericOrmReferenceTable.this.getXmlJoinColumns();
        }

        @Override
        public XmlJoinColumn extractResourceElement(OrmSpecifiedJoinColumn contextElement) {
            return contextElement.getXmlColumn();
        }
    }
}

