/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceNamedColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceBaseDiscriminatorColumnAnnotation
extends SourceNamedColumnAnnotation
implements DiscriminatorColumnAnnotation {
    private DeclarationAnnotationElementAdapter<String> discriminatorTypeDeclarationAdapter = this.buildDiscriminatorTypeDeclarationAdapter();
    private AnnotationElementAdapter<String> discriminatorTypeAdapter = this.buildDiscriminatorTypeAdapter();
    private DiscriminatorType discriminatorType;
    private DeclarationAnnotationElementAdapter<Integer> lengthDeclarationAdapter = this.buildLengthDeclarationAdapter();
    private AnnotationElementAdapter<Integer> lengthAdapter = this.buildLengthAdapter();
    private Integer length;

    protected SourceBaseDiscriminatorColumnAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
    }

    protected SourceBaseDiscriminatorColumnAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        this(parent, element, daa, (AnnotationAdapter)new ElementAnnotationAdapter(element, daa));
    }

    protected SourceBaseDiscriminatorColumnAnnotation(JavaResourceModel parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter idaa) {
        this(parent, element, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter(element, idaa));
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.discriminatorType = this.buildDiscriminatorType(astAnnotation);
        this.length = this.buildLength(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncLength(this.buildLength(astAnnotation));
        this.syncDiscriminatorType(this.buildDiscriminatorType(astAnnotation));
    }

    @Override
    public DiscriminatorType getDiscriminatorType() {
        return this.discriminatorType;
    }

    @Override
    public void setDiscriminatorType(DiscriminatorType discriminatorType) {
        if (ObjectTools.notEquals((Object)((Object)this.discriminatorType), (Object)((Object)discriminatorType))) {
            this.discriminatorType = discriminatorType;
            this.discriminatorTypeAdapter.setValue((Object)DiscriminatorType.toJavaAnnotationValue(discriminatorType));
        }
    }

    private void syncDiscriminatorType(DiscriminatorType astDiscriminatorType) {
        DiscriminatorType old = this.discriminatorType;
        this.discriminatorType = astDiscriminatorType;
        this.firePropertyChanged("discriminatorType", (Object)old, (Object)astDiscriminatorType);
    }

    private DiscriminatorType buildDiscriminatorType(Annotation astAnnotation) {
        return DiscriminatorType.fromJavaAnnotationValue(this.discriminatorTypeAdapter.getValue(astAnnotation));
    }

    private DeclarationAnnotationElementAdapter<String> buildDiscriminatorTypeDeclarationAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(this.daa, this.getDiscriminatorTypeElementName());
    }

    private AnnotationElementAdapter<String> buildDiscriminatorTypeAdapter() {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, this.discriminatorTypeDeclarationAdapter);
    }

    protected abstract String getDiscriminatorTypeElementName();

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public void setLength(Integer length) {
        if (ObjectTools.notEquals((Object)this.length, (Object)length)) {
            this.length = length;
            this.lengthAdapter.setValue((Object)length);
        }
    }

    private void syncLength(Integer astLength) {
        Integer old = this.length;
        this.length = astLength;
        this.firePropertyChanged("length", old, astLength);
    }

    private Integer buildLength(Annotation astAnnotation) {
        return (Integer)this.lengthAdapter.getValue(astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<Integer> buildLengthDeclarationAdapter() {
        return this.buildIntegerElementAdapter(this.getLengthElementName());
    }

    private AnnotationElementAdapter<Integer> buildLengthAdapter() {
        return this.buildIntegerElementAdapter(this.lengthDeclarationAdapter);
    }

    protected abstract String getLengthElementName();

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.discriminatorType == null && this.length == null;
    }
}

