/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.internal.ModuleType;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;
import org.eclipse.wst.server.core.util.PublishAdapter;
import org.eclipse.wst.server.ui.DeleteServerDialogExtension;
import org.eclipse.wst.server.ui.editor.ServerEditorOverviewPageModifier;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.InitializeJob;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPreferences;
import org.eclipse.wst.server.ui.internal.TerminationDialog;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.actions.RunOnServerActionDelegate;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorCore;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorInput;
import org.eclipse.wst.server.ui.internal.provisional.AbstractServerLabelProvider;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.viewers.InitialSelectionProvider;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.internal.wizard.fragment.ModifyModulesWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.fragment.NewRuntimeWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.fragment.NewServerWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.fragment.TasksWizardFragment;
import org.eclipse.wst.server.ui.wizard.ServerCreationWizardPageExtension;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerUIPlugin
extends AbstractUIPlugin {
    protected static final String VIEW_ID = "org.eclipse.wst.server.ui.ServersView";
    public static final String PLUGIN_ID = "org.eclipse.wst.server.ui";
    protected static final String EXTENSION_SERVER_IMAGES = "serverImages";
    private static final String EXTENSION_WIZARD_FRAGMENTS = "wizardFragments";
    public static final String EXTENSION_EDITOR_PAGES = "editorPages";
    public static final String EXTENSION_EDITOR_PAGE_SECTIONS = "editorPageSections";
    public static final byte STOP = 1;
    private static ServerUIPlugin singleton;
    protected Map imageDescriptors = new HashMap();
    private static Map<String, WizardFragmentData> wizardFragments;
    private static List<ServerCreationWizardPageExtension> serverCreationWizardPageExtensions;
    private static List<OverviewPageModifierFactory> serverEditorOverviewPageModifierFactories;
    private static List<DeleteServerDialogExtension> deleteServerDialogExtensions;
    private static HashMap<String, AbstractServerLabelProvider> serverLabelProviders;
    private static AbstractServerLabelProvider defaultServerLabelProvider;
    private static InitialSelectionProvider selectionProvider;
    private static IRegistryChangeListener registryListener;
    protected static List<IServer> terminationWatches;
    protected IServerLifecycleListener serverLifecycleListener = new IServerLifecycleListener(){

        public void serverAdded(IServer server) {
            server.addServerListener(serverListener);
            ((Server)server).addPublishListener(publishListener);
        }

        public void serverChanged(IServer server) {
        }

        public void serverRemoved(IServer server) {
            server.removeServerListener(serverListener);
            ((Server)server).removePublishListener(publishListener);
        }
    };
    protected static IServerListener serverListener;
    protected static IPublishListener publishListener;

    static {
        defaultServerLabelProvider = new AbstractServerLabelProvider();
        terminationWatches = new ArrayList<IServer>();
        serverListener = new IServerListener(){

            public void serverChanged(ServerEvent event) {
                int eventKind = event.getKind();
                if ((eventKind & 1) != 0) {
                    ServerUIPlugin.showServersView(true);
                } else if ((eventKind & 0x10) != 0) {
                    ServerUIPlugin.showServersView(false);
                }
            }
        };
        publishListener = new PublishAdapter(){

            public void publishStarted(IServer server) {
                ServerUIPlugin.showServersView(false);
            }

            public void publishFinished(IServer server, IStatus status) {
                ServerUIPlugin.showServersView(false);
            }
        };
    }

    public ServerUIPlugin() {
        singleton = this;
    }

    public static ServerUIPlugin getInstance() {
        return singleton;
    }

    public static void log(IStatus status) {
        ServerUIPlugin.getInstance().getLog().log(status);
    }

    public static ServerUIPreferences getPreferences() {
        return ServerUIPreferences.getInstance();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (Trace.CONFIG) {
            Trace.trace("/config", "----->----- Server UI plugin start ----->-----");
        }
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverLifecycleListener);
        ServerUIPlugin.loadServerLabelProvider();
        InitializeJob job = new InitializeJob();
        job.schedule();
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        props.put("listener.symbolic.name", PLUGIN_ID);
        context.registerService(DebugOptionsListener.class.getName(), (Object)new Trace(), props);
    }

    public void stop(BundleContext context) throws Exception {
        if (Trace.CONFIG) {
            Trace.trace("/config", "-----<----- Server UI plugin stop -----<-----");
        }
        super.stop(context);
        if (registryListener != null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.removeRegistryChangeListener(registryListener);
        }
        ImageResource.dispose();
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                servers[i].removeServerListener(serverListener);
                ((Server)servers[i]).removePublishListener(publishListener);
                ++i;
            }
        }
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverLifecycleListener);
    }

    public static void addTerminationWatch(Shell shell, IServer server, int mode) {
        IServerListener listener;
        if (terminationWatches.contains(server)) {
            return;
        }
        terminationWatches.add(server);
        class TerminateThread
        extends Thread {
            public boolean alive;
            public IServerListener listener;
            private final /* synthetic */ IServer val$server;
            private final /* synthetic */ int val$mode;
            private final /* synthetic */ Shell val$shell;

            public TerminateThread(IServer iServer, int n, Shell shell) {
                this.val$server = iServer;
                this.val$mode = n;
                this.val$shell = shell;
                super("Server Termination Thread");
                this.alive = true;
            }

            public void run() {
                while (this.alive) {
                    int delay = this.val$server.getStartTimeout() * 1000;
                    if (this.val$mode == 1) {
                        delay = this.val$server.getStopTimeout() * 1000;
                    } else if (this.val$mode == 2) {
                        delay += this.val$server.getStopTimeout() * 1000;
                    }
                    if (delay < 0) {
                        return;
                    }
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.val$server.getServerState() == 4) {
                        this.alive = false;
                    }
                    if (this.alive) {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                TerminationDialog dialog = new TerminationDialog(val$shell, val$server.getName());
                                dialog.open();
                                if (dialog.getReturnCode() == 0) {
                                    if (val$server.getServerState() != 4) {
                                        val$server.stop(true);
                                    }
                                    alive = false;
                                }
                            }
                        });
                    }
                    if (this.alive) continue;
                    if (this.listener != null) {
                        this.val$server.removeServerListener(this.listener);
                    }
                    terminationWatches.remove(this.val$server);
                }
            }
        }
        final TerminateThread t = new TerminateThread(server, mode, shell);
        t.setDaemon(true);
        t.setPriority(3);
        t.listener = listener = new IServerListener(){
            {
            }

            public void serverChanged(ServerEvent event) {
                int eventKind = event.getKind();
                IServer server2 = event.getServer();
                if (eventKind == 17 && server2.getServerState() == 4) {
                    t.alive = false;
                }
            }
        };
        server.addServerListener(listener);
        t.start();
    }

    public static IServer findServer(IFile file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                if (file.equals((Object)((Server)servers[i]).getFile())) {
                    return servers[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static IRuntime[] getRuntimes(IRuntimeType runtimeType) {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        IRuntime[] runtimes = ServerCore.getRuntimes();
        if (runtimes != null) {
            int size = runtimes.length;
            int i = 0;
            while (i < size) {
                if (runtimes[i].getRuntimeType() != null && runtimes[i].getRuntimeType().equals(runtimeType)) {
                    list.add(runtimes[i]);
                }
                ++i;
            }
        }
        IRuntime[] r = new IRuntime[list.size()];
        list.toArray(r);
        return r;
    }

    public static void editServer(IServer server) {
        if (server == null) {
            return;
        }
        ServerUIPlugin.editServer(server.getId());
    }

    protected static void editServer(String serverId) {
        block3: {
            if (serverId == null) {
                return;
            }
            IWorkbenchWindow workbenchWindow = ServerUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            try {
                ServerEditorInput input = new ServerEditorInput(serverId);
                page.openEditor((IEditorInput)input, "org.eclipse.wst.server.ui.editor");
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block3;
                Trace.trace("/severe", "Error opening server editor", e);
            }
        }
    }

    public static boolean saveEditors() {
        byte b = ServerUIPlugin.getPreferences().getSaveEditors();
        if (b == 0) {
            return true;
        }
        return ServerUIPlugin.getInstance().getWorkbench().saveAllEditors(b == 1);
    }

    public static boolean promptIfDirty(Shell shell, IServer server) {
        if (server == null) {
            return false;
        }
        if (!(server instanceof IServerWorkingCopy)) {
            return true;
        }
        String title = Messages.resourceDirtyDialogTitle;
        IServerWorkingCopy wc = (IServerWorkingCopy)server;
        if (wc.isDirty()) {
            String message = NLS.bind((String)Messages.resourceDirtyDialogMessage, (Object)server.getName());
            String[] labels = new String[]{Messages.resourceDirtyDialogContinue, IDialogConstants.CANCEL_LABEL};
            MessageDialog dialog = new MessageDialog(shell, title, null, message, 2, labels, 0);
            if (dialog.open() != 0) {
                return false;
            }
        }
        return true;
    }

    protected static void showServersView(final boolean bringToFront) {
        if (!ServerUIPlugin.getPreferences().getShowOnActivity()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                block7: {
                    try {
                        IWorkbench workbench = ServerUIPlugin.getInstance().getWorkbench();
                        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                        if (workbenchWindow == null) {
                            if (Trace.FINER) {
                                Trace.trace("/finer", "No active workbench window");
                            }
                            return;
                        }
                        IWorkbenchPage page = workbenchWindow.getActivePage();
                        IViewPart view2 = page.findView(ServerUIPlugin.VIEW_ID);
                        if (view2 != null) {
                            if (bringToFront) {
                                page.bringToTop((IWorkbenchPart)view2);
                            } else {
                                IWorkbenchSiteProgressService wsps = (IWorkbenchSiteProgressService)view2.getSite().getAdapter(IWorkbenchSiteProgressService.class);
                                wsps.warnOfContentChange();
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!Trace.SEVERE) break block7;
                        Trace.trace("/severe", "Error opening Servers view", e);
                    }
                }
            }
        });
    }

    public static boolean isCompatibleWithLaunchMode(IServer server, String launchMode) {
        if (server == null || launchMode == null) {
            return false;
        }
        int state = server.getServerState();
        if (state == 2 && launchMode.equals(server.getMode())) {
            return true;
        }
        return server.getServerType() != null && server.getServerType().supportsLaunchMode(launchMode);
    }

    public static boolean showNewRuntimeWizard(Shell shell, final String type, final String version, final String runtimeTypeId) {
        WizardFragment fragment = new WizardFragment(){

            @Override
            protected void createChildFragments(List<WizardFragment> list) {
                list.add(new NewRuntimeWizardFragment(type, version, runtimeTypeId));
                list.add(WizardTaskUtil.SaveRuntimeFragment);
            }
        };
        TaskWizard wizard = new TaskWizard(Messages.wizNewRuntimeWizardTitle, fragment);
        wizard.setForcePreviousAndNextButtons(true);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        return dialog.open() == 0;
    }

    public static boolean showNewRuntimeWizard(Shell shell, final String runtimeTypeId) {
        IRuntimeType runtimeType = null;
        if (runtimeTypeId != null) {
            runtimeType = ServerCore.findRuntimeType((String)runtimeTypeId);
        }
        if (runtimeType != null) {
            try {
                IRuntimeWorkingCopy runtime = runtimeType.createRuntime(null, null);
                TaskModel taskModel = new TaskModel();
                taskModel.putObject("runtime", (Object)runtime);
                WizardFragment fragment = new WizardFragment(){

                    @Override
                    protected void createChildFragments(List<WizardFragment> list) {
                        list.add(ServerUIPlugin.getWizardFragment(runtimeTypeId));
                        list.add(WizardTaskUtil.SaveRuntimeFragment);
                    }
                };
                TaskWizard wizard = new TaskWizard(Messages.wizNewRuntimeWizardTitle, fragment, taskModel);
                wizard.setForcePreviousAndNextButtons(true);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                return dialog.open() == 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return ServerUIPlugin.showNewRuntimeWizard(shell, null, null, runtimeTypeId);
    }

    public static boolean showNewServerWizard(Shell shell, final String typeId, final String versionId, final String serverTypeId) {
        WizardFragment fragment = new WizardFragment(){

            @Override
            protected void createChildFragments(List<WizardFragment> list) {
                list.add(new NewServerWizardFragment((IModuleType)new ModuleType(typeId, versionId), serverTypeId));
                list.add(WizardTaskUtil.TempSaveRuntimeFragment);
                list.add(WizardTaskUtil.TempSaveServerFragment);
                list.add(new ModifyModulesWizardFragment());
                list.add(new TasksWizardFragment());
                list.add(WizardTaskUtil.SaveRuntimeFragment);
                list.add(WizardTaskUtil.SaveServerFragment);
                list.add(WizardTaskUtil.SaveHostnameFragment);
            }
        };
        TaskWizard wizard = new TaskWizard(Messages.wizNewServerWizardTitle, fragment);
        wizard.setForcePreviousAndNextButtons(true);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        return dialog.open() == 0;
    }

    public static boolean hasWizardFragment(String typeId) {
        if (typeId == null) {
            return false;
        }
        if (wizardFragments == null) {
            ServerUIPlugin.loadWizardFragments();
        }
        for (String key : wizardFragments.keySet()) {
            if (!typeId.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static WizardFragment getWizardFragment(String typeId) {
        if (typeId == null) {
            return null;
        }
        if (wizardFragments == null) {
            ServerUIPlugin.loadWizardFragments();
        }
        for (String key : wizardFragments.keySet()) {
            if (!typeId.equals(key)) continue;
            WizardFragmentData data = wizardFragments.get(key);
            return ServerUIPlugin.getWizardFragment(data);
        }
        return null;
    }

    private static synchronized void loadWizardFragments() {
        if (wizardFragments != null) {
            return;
        }
        if (Trace.CONFIG) {
            Trace.trace("/config", "->- Loading .wizardFragments extension point ->-");
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, EXTENSION_WIZARD_FRAGMENTS);
        HashMap<String, WizardFragmentData> map = new HashMap<String, WizardFragmentData>(cf.length);
        ServerUIPlugin.loadWizardFragments(cf, map);
        ServerUIPlugin.addRegistryListener();
        wizardFragments = map;
        if (Trace.CONFIG) {
            Trace.trace("/config", "-<- Done loading .wizardFragments extension point -<-");
        }
    }

    private static synchronized void loadWizardFragments(IConfigurationElement[] cf, Map<String, WizardFragmentData> map) {
        int i = 0;
        while (i < cf.length) {
            block5: {
                try {
                    String id = cf[i].getAttribute("typeIds");
                    String[] ids = ServerUIPlugin.tokenize(id, ",");
                    int size = ids.length;
                    int j = 0;
                    while (j < size) {
                        map.put(ids[j], new WizardFragmentData(id, cf[i]));
                        ++j;
                    }
                    if (Trace.CONFIG) {
                        Trace.trace("/config", "  Loaded wizardFragment: " + id);
                    }
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block5;
                    Trace.trace("/severe", "  Could not load wizardFragment: " + cf[i].getAttribute("id"), t);
                }
            }
            ++i;
        }
    }

    public static InitialSelectionProvider getInitialSelectionProvider() {
        if (selectionProvider == null) {
            ServerUIPlugin.loadInitialSelectionProvider();
        }
        return selectionProvider;
    }

    public static AbstractServerLabelProvider getServerLabelProvider(String serverTypeId) {
        AbstractServerLabelProvider serverLabelProvider;
        if (serverLabelProviders == null) {
            ServerUIPlugin.loadServerLabelProvider();
        }
        if ((serverLabelProvider = serverLabelProviders.get(serverTypeId)) == null) {
            serverLabelProvider = defaultServerLabelProvider;
            serverLabelProviders.put(serverTypeId, serverLabelProvider);
        }
        return serverLabelProvider;
    }

    public static List<ServerCreationWizardPageExtension> getServerCreationWizardPageExtensions() {
        if (serverCreationWizardPageExtensions == null) {
            ServerUIPlugin.loadServerCreationWizardPageExtensions();
        }
        return serverCreationWizardPageExtensions;
    }

    public static List<ServerEditorOverviewPageModifier> getServerEditorOverviewPageModifiers(String serverType) {
        return ServerUIPlugin.getServerEditorOverviewPageModifiersImpl(serverType);
    }

    private static List<ServerEditorOverviewPageModifier> getServerEditorOverviewPageModifiersImpl(String serverType) {
        if (serverEditorOverviewPageModifierFactories == null) {
            ServerUIPlugin.loadServerEditorOverviewPageModifiers();
        }
        ArrayList<ServerEditorOverviewPageModifier> pageModifierImplLst = new ArrayList<ServerEditorOverviewPageModifier>();
        for (OverviewPageModifierFactory curFactory : serverEditorOverviewPageModifierFactories) {
            if (curFactory == null || serverType != null && !curFactory.supportsType(serverType)) continue;
            pageModifierImplLst.add(curFactory.createModifier());
        }
        return pageModifierImplLst;
    }

    public static List<DeleteServerDialogExtension> getDeleteServerDialogExtensions() {
        if (deleteServerDialogExtensions == null) {
            ServerUIPlugin.loadDeleteServerDialogExtensions();
        }
        return deleteServerDialogExtensions;
    }

    private static synchronized void loadServerCreationWizardPageExtensions() {
        IConfigurationElement[] cf;
        if (serverCreationWizardPageExtensions != null) {
            return;
        }
        if (Trace.CONFIG) {
            Trace.trace("/config", "->- Loading .serverCreationWizardPageExtension extension point ->-");
        }
        serverCreationWizardPageExtensions = new ArrayList<ServerCreationWizardPageExtension>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = cf = registry.getConfigurationElementsFor(PLUGIN_ID, "serverCreationWizardPageExtension");
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                IConfigurationElement curConfigElement = iConfigurationElementArray[n2];
                try {
                    ServerCreationWizardPageExtension curExtension = (ServerCreationWizardPageExtension)curConfigElement.createExecutableExtension("class");
                    if (Trace.CONFIG) {
                        Trace.trace("/config", "  Loaded .serverCreationWizardPageExtension: " + cf[0].getAttribute("id") + ", loaded class=" + curExtension);
                    }
                    if (curExtension != null) {
                        serverCreationWizardPageExtensions.add(curExtension);
                    }
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block8;
                    Trace.trace("/severe", "  Could not load .serverCreationWizardPageExtension: " + cf[0].getAttribute("id"), t);
                }
            }
            ++n2;
        }
        if (Trace.CONFIG) {
            Trace.trace("/config", "-<- Done loading .serverCreationWizardPageExtension extension point -<-");
        }
    }

    private static synchronized void loadServerEditorOverviewPageModifiers() {
        IConfigurationElement[] cf;
        if (serverEditorOverviewPageModifierFactories != null) {
            return;
        }
        if (Trace.CONFIG) {
            Trace.trace("/config", "->- Loading .serverEditorOverviewPageModifier extension point ->-");
        }
        serverEditorOverviewPageModifierFactories = new ArrayList<OverviewPageModifierFactory>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = cf = registry.getConfigurationElementsFor(PLUGIN_ID, "serverEditorOverviewPageModifier");
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                IConfigurationElement curConfigElement = iConfigurationElementArray[n2];
                try {
                    ServerEditorOverviewPageModifier curExtension = (ServerEditorOverviewPageModifier)curConfigElement.createExecutableExtension("class");
                    if (Trace.CONFIG) {
                        Trace.trace("/config", "  Loaded .serverEditorOverviewPageModifier: " + cf[0].getAttribute("id") + ", loaded class=" + curExtension);
                    }
                    if (curExtension != null) {
                        serverEditorOverviewPageModifierFactories.add(new OverviewPageModifierFactory(curConfigElement));
                    }
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block8;
                    Trace.trace("/severe", "  Could not load .serverEditorOverviewPageModifier: " + cf[0].getAttribute("id"), t);
                }
            }
            ++n2;
        }
        Collections.sort(serverEditorOverviewPageModifierFactories);
        if (Trace.CONFIG) {
            Trace.trace("/config", "-<- Done loading .serverEditorOverviewPageModifier extension point -<-");
        }
    }

    private static synchronized void loadDeleteServerDialogExtensions() {
        IConfigurationElement[] cf;
        if (deleteServerDialogExtensions != null) {
            return;
        }
        if (Trace.CONFIG) {
            Trace.trace("/config", "->- Loading .deleteServerDialogExtension extension point ->-");
        }
        deleteServerDialogExtensions = new ArrayList<DeleteServerDialogExtension>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = cf = registry.getConfigurationElementsFor(PLUGIN_ID, "deleteServerDialogExtension");
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                IConfigurationElement curConfigElement = iConfigurationElementArray[n2];
                try {
                    DeleteServerDialogExtension curExtension = (DeleteServerDialogExtension)curConfigElement.createExecutableExtension("class");
                    if (Trace.CONFIG) {
                        Trace.trace("/config", "  Loaded .deleteServerDialogExtension: " + cf[0].getAttribute("id") + ", loaded class=" + curExtension);
                    }
                    if (curExtension != null) {
                        deleteServerDialogExtensions.add(curExtension);
                    }
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block8;
                    Trace.trace("/severe", "  Could not load .deleteServerDialogExtension: " + cf[0].getAttribute("id"), t);
                }
            }
            ++n2;
        }
        if (Trace.CONFIG) {
            Trace.trace("/config", "-<- Done loading .deleteServerDialogExtension extension point -<-");
        }
    }

    private static synchronized void loadServerLabelProvider() {
        IConfigurationElement[] cf;
        if (serverLabelProviders != null) {
            return;
        }
        if (Trace.CONFIG) {
            Trace.trace("/config", "->- Loading .serverLabelProvider extension point ->-");
        }
        serverLabelProviders = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = cf = registry.getConfigurationElementsFor(PLUGIN_ID, "serverLabelProvider");
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            String[] exServerTypes;
            IConfigurationElement curConfigElement = iConfigurationElementArray[n2];
            String[] stringArray = exServerTypes = ServerPlugin.tokenize((String)curConfigElement.getAttribute("serverTypes"), (String)",");
            int n3 = exServerTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                block11: {
                    String exServerType = stringArray[n4];
                    try {
                        if (serverLabelProviders.containsKey(exServerType)) {
                            if (Trace.WARNING) {
                                Trace.trace("/warning", "More that one .serverLabelProvider found - ignoring");
                            }
                            serverLabelProviders.put(exServerType, defaultServerLabelProvider);
                        } else {
                            AbstractServerLabelProvider exClass = (AbstractServerLabelProvider)curConfigElement.createExecutableExtension("class");
                            if (Trace.CONFIG) {
                                Trace.trace("/config", "  Loaded .serverLabelProvider: " + curConfigElement.getAttribute("id") + ", loaded class=" + exClass);
                            }
                            serverLabelProviders.put(exServerType, exClass);
                        }
                    }
                    catch (Throwable t) {
                        if (!Trace.SEVERE) break block11;
                        Trace.trace("/severe", "  Could not load .serverLabelProvider: " + curConfigElement.getAttribute("id"), t);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (Trace.CONFIG) {
            Trace.trace("/config", "-<- Done loading .serverLabelProvider extension point -<-");
        }
    }

    private static synchronized void loadInitialSelectionProvider() {
        block13: {
            IExtensionRegistry registry;
            IConfigurationElement[] cf;
            if (selectionProvider != null) {
                return;
            }
            if (Trace.CONFIG) {
                Trace.trace("/config", "->- Loading .initialSelectionProvider extension point ->-");
            }
            if ((cf = (registry = Platform.getExtensionRegistry()).getConfigurationElementsFor(PLUGIN_ID, "initialSelectionProvider")).length == 1) {
                try {
                    selectionProvider = (InitialSelectionProvider)((Object)cf[0].createExecutableExtension("class"));
                    if (Trace.CONFIG) {
                        Trace.trace("/config", "  Loaded initialSelectionProvider: " + cf[0].getAttribute("id"));
                    }
                    break block13;
                }
                catch (Throwable t) {
                    if (Trace.SEVERE) {
                        Trace.trace("/severe", "  Could not load initialSelectionProvider: " + cf[0].getAttribute("id"), t);
                    }
                    break block13;
                }
            }
            if (cf.length > 1) {
                if (Trace.WARNING) {
                    Trace.trace("/warning", "More that one initial selection provider found - ignoring");
                } else if (Trace.CONFIG) {
                    Trace.trace("/config", "No initial selection provider found");
                }
            }
        }
        if (selectionProvider == null) {
            selectionProvider = new InitialSelectionProvider();
        }
        if (Trace.CONFIG) {
            Trace.trace("/config", "-<- Done loading .initialSelectionProvider extension point -<-");
        }
    }

    protected static WizardFragment getWizardFragment(WizardFragmentData fragment) {
        block5: {
            if (fragment == null) {
                return null;
            }
            if (fragment.fragment == null) {
                try {
                    long time = System.currentTimeMillis();
                    fragment.fragment = (WizardFragment)fragment.ce.createExecutableExtension("class");
                    if (Trace.PERFORMANCE) {
                        Trace.trace("/performance", "ServerUIPlugin.getWizardFragment(): <" + (System.currentTimeMillis() - time) + "> " + fragment.ce.getAttribute("id"));
                    }
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block5;
                    Trace.trace("/severe", "Could not create wizardFragment: " + fragment.ce.getAttribute("id"), t);
                }
            }
        }
        return fragment.fragment;
    }

    public static void runOnServer(Object object, String launchMode) {
        RunOnServerActionDelegate delegate = new RunOnServerActionDelegate();
        Action action = new Action(){};
        if (object != null) {
            StructuredSelection sel = new StructuredSelection(object);
            delegate.selectionChanged((IAction)action, (ISelection)sel);
        } else {
            delegate.selectionChanged((IAction)action, null);
        }
        delegate.run((IAction)action);
    }

    public static synchronized void addRegistryListener() {
        if (registryListener != null) {
            return;
        }
        registryListener = new RegistryChangeListener();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener(registryListener, PLUGIN_ID);
    }

    protected static void handleWizardFragmentDelta(IExtensionDelta delta) {
        if (wizardFragments == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        HashMap<String, WizardFragmentData> map = new HashMap<String, WizardFragmentData>(wizardFragments);
        if (delta.getKind() == 1) {
            ServerUIPlugin.loadWizardFragments(cf, map);
        }
        wizardFragments = map;
    }

    public static String[] tokenize(String str, String delim) {
        String[] s;
        if (str == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            if (s == null || s.length() <= 0) continue;
            list.add(s.trim());
        }
        s = new String[list.size()];
        list.toArray(s);
        return s;
    }

    public static IClient[] getClients(IServer server, Object launchable, String launchMode) {
        if (server == null || launchable == null) {
            return new IClient[0];
        }
        ArrayList<IClient> list = new ArrayList<IClient>(5);
        IClient[] clients = ServerPlugin.getClients();
        if (clients != null) {
            int size = clients.length;
            int i = 0;
            while (i < size) {
                if (Trace.FINEST) {
                    Trace.trace("/finest", "client= " + clients[i]);
                }
                if (clients[i].supports(server, launchable, launchMode)) {
                    list.add(clients[i]);
                }
                ++i;
            }
        }
        IClient[] clients2 = new IClient[list.size()];
        list.toArray(clients2);
        return clients2;
    }

    public static Object[] getLaunchableAdapter(IServer server, IModuleArtifact moduleArtifact) throws CoreException {
        ILaunchableAdapter[] adapters = ServerPlugin.getLaunchableAdapters();
        if (adapters != null) {
            int size2 = adapters.length;
            IStatus lastStatus = null;
            int j = 0;
            while (j < size2) {
                block8: {
                    ILaunchableAdapter adapter = adapters[j];
                    try {
                        Object launchable2 = adapter.getLaunchable(server, moduleArtifact);
                        if (Trace.FINEST) {
                            Trace.trace("/finest", "adapter= " + adapter + ", launchable= " + launchable2);
                        }
                        if (launchable2 != null) {
                            return new Object[]{adapter, launchable2};
                        }
                    }
                    catch (CoreException ce) {
                        lastStatus = ce.getStatus();
                    }
                    catch (Exception e) {
                        if (!Trace.SEVERE) break block8;
                        Trace.trace("/severe", "Error in launchable adapter", e);
                    }
                }
                ++j;
            }
            if (lastStatus != null) {
                throw new CoreException(lastStatus);
            }
        }
        ILaunchableAdapter launchableAdapter = ServerPlugin.findLaunchableAdapter((String)"org.eclipse.wst.server.ui.launchable.adapter.default");
        Object launchable = launchableAdapter.getLaunchable(server, moduleArtifact);
        return new Object[]{launchableAdapter, launchable};
    }

    public static Object[] adaptLabelChangeObjects(Object[] obj) {
        if (obj == null) {
            return obj;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int size = obj.length;
        int i = 0;
        while (i < size) {
            if (obj[i] instanceof IModule) {
                list.add(obj[i]);
            } else if (obj[i] instanceof IServer) {
                list.add(obj[i]);
            } else if (obj[i] instanceof ModuleServer) {
                list.add(obj[i]);
            } else if (obj[i] instanceof IProject) {
                IProject proj = (IProject)obj[i];
                IModule[] m = ServerUtil.getModules((IProject)proj);
                int size2 = m.length;
                int j = 0;
                while (j < size2) {
                    list.add(m[j]);
                    ++j;
                }
            }
            ++i;
        }
        Object[] o = new Object[list.size()];
        list.toArray(o);
        return o;
    }

    public static class DefaultLaunchableAdapter
    extends LaunchableAdapterDelegate {
        public static final String ID = "org.eclipse.wst.server.ui.launchable.adapter.default";

        public Object getLaunchable(IServer server, IModuleArtifact moduleArtifact) {
            return "launchable";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OverviewPageModifierFactory
    implements Comparable<OverviewPageModifierFactory> {
        IConfigurationElement element;
        String[] serverTypes = null;
        int order = 10;

        OverviewPageModifierFactory(IConfigurationElement element) {
            this.element = element;
            this.init();
        }

        private void init() {
            String attr = this.element.getAttribute("serverTypes");
            this.serverTypes = attr == null || attr.length() == 0 ? null : attr.split(",");
            String w = this.element.getAttribute("order");
            if (w != null) {
                try {
                    this.order = Integer.parseInt(w);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }

        ServerEditorOverviewPageModifier createModifier() {
            try {
                ServerEditorOverviewPageModifier curExtension = (ServerEditorOverviewPageModifier)this.element.createExecutableExtension("class");
                if (Trace.CONFIG) {
                    Trace.trace("/config", "  New instance of .serverEditorOverviewPageModifier: " + this.element.getAttribute("id") + ", loaded class=" + curExtension);
                }
                return curExtension;
            }
            catch (Throwable t) {
                if (Trace.SEVERE) {
                    Trace.trace("/severe", "  Could not create new instance .serverEditorOverviewPageModifier: " + this.element.getAttribute("id"), t);
                }
                return null;
            }
        }

        boolean supportsType(String serverType) {
            return ServerPlugin.contains((String[])this.serverTypes, (String)serverType);
        }

        @Override
        public int compareTo(OverviewPageModifierFactory factory) {
            return this.order - factory.order;
        }
    }

    protected static class RegistryChangeListener
    implements IRegistryChangeListener {
        protected RegistryChangeListener() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            int i;
            IExtensionDelta[] deltas = event.getExtensionDeltas(ServerUIPlugin.PLUGIN_ID, ServerUIPlugin.EXTENSION_WIZARD_FRAGMENTS);
            if (deltas != null) {
                i = 0;
                while (i < deltas.length) {
                    ServerUIPlugin.handleWizardFragmentDelta(deltas[i]);
                    ++i;
                }
            }
            if ((deltas = event.getExtensionDeltas(ServerUIPlugin.PLUGIN_ID, ServerUIPlugin.EXTENSION_SERVER_IMAGES)) != null) {
                i = 0;
                while (i < deltas.length) {
                    ImageResource.handleServerImageDelta(deltas[i]);
                    ++i;
                }
            }
            if ((deltas = event.getExtensionDeltas(ServerUIPlugin.PLUGIN_ID, ServerUIPlugin.EXTENSION_EDITOR_PAGES)) != null) {
                i = 0;
                while (i < deltas.length) {
                    ServerEditorCore.handleEditorPageFactoriesDelta(deltas[i]);
                    ++i;
                }
            }
            if ((deltas = event.getExtensionDeltas(ServerUIPlugin.PLUGIN_ID, ServerUIPlugin.EXTENSION_EDITOR_PAGE_SECTIONS)) != null) {
                i = 0;
                while (i < deltas.length) {
                    ServerEditorCore.handleEditorPageSectionFactoriesDelta(deltas[i]);
                    ++i;
                }
            }
        }
    }

    static class WizardFragmentData {
        String id;
        IConfigurationElement ce;
        WizardFragment fragment;

        public WizardFragmentData(String id, IConfigurationElement ce) {
            this.id = id;
            this.ce = ce;
        }
    }
}

