/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.border.CSSBorder;
import org.eclipse.jst.pagedesigner.css2.layout.CSSInlineFlowLayout;
import org.eclipse.jst.pagedesigner.css2.layout.CSSLayout;
import org.eclipse.jst.pagedesigner.css2.layout.DisplayToLayout;
import org.eclipse.jst.pagedesigner.css2.layout.FlowBox;
import org.eclipse.jst.pagedesigner.css2.layout.FlowContext;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigureLayout;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSPainter;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSPainter2;
import org.eclipse.jst.pagedesigner.css2.style.DefaultStyle;
import org.eclipse.jst.pagedesigner.css2.style.ITagEditInfo;
import org.eclipse.jst.pagedesigner.css2.widget.BorderUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class CSSFigure
extends FlowFigure
implements ICSSFigure {
    private static Logger _log = PDPlugin.getLogger(CSSFigure.class);
    private static final Rectangle PRIVATE_RECT = new Rectangle();
    private ICSSStyle _style;
    private CSSLayout _fixedLayout;

    public CSSFigure() {
        this(DefaultStyle.getInstance());
    }

    public CSSFigure(ICSSStyle style) {
        this._style = style;
        this.invalidateCSS();
    }

    public ICSSStyle getCSSStyle() {
        return this._style;
    }

    public void setCSSStyle(ICSSStyle style) {
        this._style = style;
        this.invalidateCSS();
    }

    public void revalidate() {
        CSSLayout layout = (CSSLayout)this.getLayoutManager();
        layout.figureRevalidate();
        super.revalidate();
    }

    public void invalidateCSS() {
        CSSLayout layout = this.regetLayout(this.getLayoutManager());
        this.setLayoutManager((LayoutManager)layout);
    }

    public void setFixedLayoutManager(CSSLayout layout) {
        this._fixedLayout = layout;
        this.setLayoutManager((LayoutManager)this.regetLayout(this.getLayoutManager()));
    }

    public void setLayoutManager(LayoutManager manager) {
        LayoutManager old = this.getLayoutManager();
        if (old != manager) {
            FlowContext context = null;
            if (old instanceof FlowFigureLayout) {
                context = ((FlowFigureLayout)old).getOriginalFlowContext();
            }
            if (manager instanceof FlowFigureLayout) {
                ((FlowFigureLayout)manager).setOriginalFlowContext(context);
            }
            if (manager instanceof FlowContext) {
                List list = this.getChildren();
                int i = 0;
                int size = list.size();
                while (i < size) {
                    try {
                        ((FlowFigure)((Object)list.get(i))).setOriginalFlowContext((FlowContext)manager);
                    }
                    catch (ClassCastException classcastexception) {
                        _log.error("Error.CSSFigure.0", (Throwable)classcastexception);
                    }
                    ++i;
                }
            }
        }
        super.setLayoutManager(manager);
    }

    protected CSSLayout regetLayout(LayoutManager old) {
        if (this._fixedLayout != null) {
            return this._fixedLayout;
        }
        CSSLayout layout = DisplayToLayout.displayToLayout(this, this.getCSSStyle().getDisplay(), old);
        if (layout != null) {
            return layout;
        }
        return new CSSInlineFlowLayout(this);
    }

    public boolean containsPoint(int x, int y) {
        if (!super.containsPoint(x, y)) {
            return false;
        }
        List frags = this.getFragmentsForRead();
        if (frags != null) {
            int i = 0;
            while (i < frags.size()) {
                FlowBox box = (FlowBox)frags.get(i);
                if (box != null && box.containsPoint(x, y)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public List getFragmentsForRead() {
        CSSLayout layout = (CSSLayout)this.getLayoutManager();
        return layout.getFragmentsForRead();
    }

    public Rectangle[] getFragmentsBounds() {
        List list = this.getFragmentsForRead();
        if (list == null || list.size() == 0) {
            return new Rectangle[]{this.getBounds()};
        }
        Rectangle[] ret = new Rectangle[list.size()];
        int i = 0;
        int size = list.size();
        while (i < size) {
            FlowBox box = (FlowBox)list.get(i);
            ret[i] = new Rectangle(box._x, box._y, box.getWidth(), box.getHeight());
            ++i;
        }
        return ret;
    }

    public void setBounds(Rectangle r) {
        if (this.getBounds().equals((Object)r)) {
            return;
        }
        boolean invalidate = this.getBounds().width != r.width || this.getBounds().height != r.height;
        super.setBounds(r);
        CSSLayout layout = (CSSLayout)this.getLayoutManager();
        layout.setBoundsCalled(r, invalidate);
    }

    public void postValidate() {
        CSSLayout layout = (CSSLayout)this.getLayoutManager();
        layout.postValidateForAbsolute();
        layout.postValidate();
    }

    public void validate() {
        super.validate();
    }

    protected boolean useLocalCoordinates() {
        CSSLayout layout = (CSSLayout)this.getLayoutManager();
        if (layout == null) {
            return false;
        }
        return layout.useLocalCoordinates();
    }

    public void paint(Graphics graphics) {
        Object visibility;
        ICSSStyle style = this.getCSSStyle();
        if (style != null && "hidden".equals(visibility = style.getStyleProperty("visibility"))) {
            return;
        }
        CSSLayout layout = (CSSLayout)this.getLayoutManager();
        graphics.pushState();
        try {
            this.paintFigure(graphics);
            graphics.restoreState();
            this.paintClientArea(graphics);
            if (layout instanceof ICSSPainter2) {
                if (this.useLocalCoordinates()) {
                    graphics.translate(this.getBounds().x + this.getInsets().left, this.getBounds().y + this.getInsets().top);
                    ((ICSSPainter2)((Object)layout)).paintFigurePostClientArea(graphics);
                    graphics.restoreState();
                } else {
                    ((ICSSPainter2)((Object)layout)).paintFigurePostClientArea(graphics);
                }
            }
            this.paintBorder(graphics);
        }
        finally {
            graphics.popState();
        }
    }

    protected void paintFigure(Graphics g) {
        LayoutManager layout;
        Color rgbColor = null;
        boolean fillArea = false;
        Object bg = this.getCSSStyle().getBackgroundColor();
        if (bg instanceof RGB) {
            rgbColor = new Color(null, (RGB)bg);
            g.setBackgroundColor(rgbColor);
            fillArea = true;
        } else if (bg instanceof Color) {
            g.setBackgroundColor((Color)bg);
            fillArea = true;
        }
        if (fillArea) {
            List fragments = this.getFragmentsForRead();
            int i = 0;
            int n = fragments.size();
            while (i < n) {
                Object obj = fragments.get(i);
                if (obj instanceof FlowBox) {
                    FlowBox box = (FlowBox)obj;
                    g.fillRectangle(box._x, box._y, box.getWidth(), box.getHeight());
                }
                ++i;
            }
        }
        if (rgbColor != null) {
            rgbColor.dispose();
        }
        g.restoreState();
        Object bgImage = this.getCSSStyle().getStyleProperty("background-image");
        if (bgImage instanceof Image) {
            g.setClip(this.bounds);
            g.drawImage((Image)bgImage, this.bounds.x, this.bounds.y);
            g.restoreState();
        }
        if ((layout = this.getLayoutManager()) instanceof ICSSPainter) {
            if (this.useLocalCoordinates()) {
                g.translate(this.getBounds().x + this.getInsets().left, this.getBounds().y + this.getInsets().top);
                ((ICSSPainter)layout).paintFigure(g);
                g.restoreState();
            } else {
                ((ICSSPainter)layout).paintFigure(g);
            }
        }
        this.paintSelection(g);
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        Object overflow = "visible";
        ICSSStyle style = this.getCSSStyle();
        if (style != null) {
            overflow = style.getStyleProperty("overflow");
        }
        boolean optimizeClip = "visible".equals(overflow);
        if (this.useLocalCoordinates()) {
            graphics.translate(this.getBounds().x + this.getInsets().left, this.getBounds().y + this.getInsets().top);
            if (!optimizeClip) {
                graphics.clipRect(this.getClientArea(PRIVATE_RECT));
            }
            graphics.pushState();
            this.paintChildren(graphics);
            graphics.popState();
            graphics.restoreState();
        } else if (optimizeClip) {
            this.paintChildren(graphics);
        } else {
            graphics.clipRect(this.getClientArea(PRIVATE_RECT));
            graphics.pushState();
            this.paintChildren(graphics);
            graphics.popState();
            graphics.restoreState();
        }
    }

    protected void paintSelection(Graphics g) {
        ITagEditInfo editInfo;
        ICSSStyle style = this.getCSSStyle();
        if (style != null && style.isInSelection() && (editInfo = (ITagEditInfo)style.getAdapter(ITagEditInfo.class)) != null && editInfo.isWidget()) {
            BorderUtil.maskFigure(this, g);
        }
    }

    protected void paintBorder(Graphics graphics) {
        CSSLayout layout = (CSSLayout)this.getLayoutManager();
        if (layout != null && !layout.handlingBorderForBlock()) {
            return;
        }
        ICSSStyle style = this.getCSSStyle();
        if (style != null) {
            CSSBorder border1 = new CSSBorder(this.getCSSStyle());
            border1.paint(this, graphics, NO_INSETS);
            ITagEditInfo editInfo = (ITagEditInfo)style.getAdapter(ITagEditInfo.class);
            if (editInfo != null && editInfo.needBorderDecorator()) {
                BorderUtil.drawBorderDecorator(this, graphics);
            }
        }
    }

    public Insets getInsets() {
        CSSLayout layout = (CSSLayout)this.getLayoutManager();
        if (layout != null && !layout.handlingBorderForBlock()) {
            return new Insets();
        }
        ICSSStyle style = this.getCSSStyle();
        if (style != null) {
            return style.getBorderInsets().getAdded(style.getPaddingInsets());
        }
        return new Insets();
    }

    public void invalidate2() {
        if (!this.isValid()) {
            return;
        }
        this.setValid(false);
    }
}

