/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.loaders;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.enablement.ingres.internal.loaders.LoaderHelper;
import org.eclipse.datatools.modelbase.sql.routines.Source;

public class IngresProcedureSourceLoader
extends JDBCBaseLoader {
    private static final String PROCEDURE_SOURCE_QUERY = "SELECT text_segment FROM iiprocedures WHERE procedure_name=? AND procedure_owner=? ORDER BY text_sequence";
    private static final String PROCEDURE_SOURCE_SEGMENT = "text_segment";

    public IngresProcedureSourceLoader() {
        this(null);
    }

    public IngresProcedureSourceLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public IngresProcedureSourceLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
    }

    public void loadSource(String procedureOwner, String procedureName, Source source) {
        block6: {
            ResultSet rs = null;
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = this.getCatalogObject().getConnection().prepareStatement(PROCEDURE_SOURCE_QUERY);
                    stmt.setString(1, procedureName);
                    stmt.setString(2, procedureOwner);
                    rs = stmt.executeQuery();
                    StringBuffer sourceBuf = new StringBuffer();
                    while (rs.next()) {
                        sourceBuf.append(rs.getString(PROCEDURE_SOURCE_SEGMENT));
                    }
                    source.setBody(sourceBuf.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LoaderHelper.close(rs);
                    LoaderHelper.close(stmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                LoaderHelper.close(rs);
                LoaderHelper.close(stmt);
                throw throwable;
            }
            LoaderHelper.close(rs);
            LoaderHelper.close(stmt);
        }
    }
}

