/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.phrase.EscapePhraseModifier;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;

public class ParagraphBlock
extends Block {
    private static final Pattern ESCAPE_PHRASE_MODIFIER_PATTERN = Pattern.compile(new EscapePhraseModifier().getPattern(0));
    private static final Pattern NESTED_BLOCK_START_PATTERN = Pattern.compile("<!--", 2);
    private static final int NESTED_BLOCK_START_GROUP = 0;
    private int blockLineCount = 0;
    private boolean newlinesCauseLineBreak = false;
    private final boolean testPreformattedBlocks;
    private int nestedStartOffset = -1;
    private int nestedLineNumber = -1;
    private int lastLineNumber = -1;

    public ParagraphBlock(boolean testPreformattedBlocks) {
        this.testPreformattedBlocks = testPreformattedBlocks;
    }

    public boolean isNewlinesCauseLineBreak() {
        return this.newlinesCauseLineBreak;
    }

    public void setNewlinesCauseLineBreak(boolean newlinesCauseLineBreak) {
        this.newlinesCauseLineBreak = newlinesCauseLineBreak;
    }

    public int processLineContent(String line, int offset) {
        this.nestedStartOffset = -1;
        this.nestedLineNumber = -1;
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, attributes);
        }
        if (this.markupLanguage.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        MediaWikiLanguage dialect = (MediaWikiLanguage)this.getMarkupLanguage();
        for (Block block : dialect.getParagraphBreakingBlocks()) {
            if (!block.canStart(line, offset)) continue;
            this.setClosed(true);
            return offset;
        }
        this.nestedStartOffset = ParagraphBlock.calculateNestedStartOffset(line, offset);
        if (this.nestedStartOffset != -1) {
            this.nestedLineNumber = this.getState().getLineNumber();
        }
        ++this.blockLineCount;
        if (this.testPreformattedBlocks && offset == 0 && line.length() > 0 && line.charAt(0) == ' ') {
            this.setClosed(true);
            return 0;
        }
        if (this.blockLineCount != 1 && this.nestedStartOffset == -1 && this.lastLineNumber != this.getState().getLineNumber()) {
            if (this.newlinesCauseLineBreak) {
                this.builder.lineBreak();
            } else {
                this.builder.characters("\n");
            }
        }
        if (this.nestedStartOffset > 0) {
            line = line.substring(0, this.nestedStartOffset);
        }
        if (this.nestedStartOffset != offset) {
            dialect.emitMarkupLine(this.getParser(), this.state, line, offset);
        }
        this.lastLineNumber = this.getState().getLineNumber();
        return this.nestedStartOffset;
    }

    private static int calculateNestedStartOffset(String line, int offset) {
        int nestedStartOffset = -1;
        Matcher nestedStartMatcher = NESTED_BLOCK_START_PATTERN.matcher(line);
        if (offset > 0) {
            nestedStartMatcher.region(offset, line.length());
        }
        if (nestedStartMatcher.find() && ParagraphBlock.isEscaped(line, offset, nestedStartOffset = nestedStartMatcher.start(0))) {
            nestedStartOffset = -1;
        }
        return nestedStartOffset;
    }

    private static boolean isEscaped(String line, int lineOffset, int offset) {
        Matcher matcher = ESCAPE_PHRASE_MODIFIER_PATTERN.matcher(line);
        if (lineOffset > 0) {
            matcher.region(lineOffset, line.length());
        }
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (start > offset || end < offset) continue;
            return true;
        }
        return false;
    }

    public boolean beginNesting() {
        return this.nestedStartOffset != -1;
    }

    public int findCloseOffset(String line, int lineOffset) {
        return -1;
    }

    public boolean canResume(String line, int lineOffset) {
        return this.getState().getLineNumber() != this.nestedLineNumber || lineOffset != this.nestedStartOffset;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        return true;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

