/// <reference types="node" />
import { URL } from 'url';
import { Readable } from 'stream';
import { Adapter, AdapterOption, Bucket, Domain, Object, SetObjectHeader, ObjectGetResult, ObjectHeader, ObjectInfo, TransferObject, PartialObjectError, BatchCallback, FrozenInfo, ListObjectsOption, ListedObjects, PutObjectOption, InitPartsOutput, UploadPartOutput, Part, GetObjectStreamOption } from './adapter';
export declare const USER_AGENT: string;
export declare class Kodo implements Adapter {
    private adapterOption;
    private static readonly httpClient;
    private readonly client;
    private readonly bucketDomainsCache;
    private readonly bucketDomainsCacheLock;
    private readonly regionService;
    constructor(adapterOption: AdapterOption);
    createBucket(s3RegionId: string, bucket: string): Promise<void>;
    deleteBucket(_region: string, bucket: string): Promise<void>;
    getBucketLocation(bucket: string): Promise<string>;
    listBuckets(): Promise<Array<Bucket>>;
    listDomains(s3RegionId: string, bucket: string): Promise<Array<Domain>>;
    _listDomains(s3RegionId: string, bucket: string): Promise<Array<Domain>>;
    listBucketIdNames(): Promise<Array<BucketIdName>>;
    isExists(s3RegionId: string, object: Object): Promise<boolean>;
    deleteObject(s3RegionId: string, object: Object): Promise<void>;
    putObject(s3RegionId: string, object: Object, data: Buffer, originalFileName: string, header?: SetObjectHeader, option?: PutObjectOption): Promise<void>;
    getObject(s3RegionId: string, object: Object, domain?: Domain): Promise<ObjectGetResult>;
    getObjectStream(s3RegionId: string, object: Object, domain?: Domain, option?: GetObjectStreamOption): Promise<Readable>;
    getObjectURL(s3RegionId: string, object: Object, domain?: Domain, deadline?: Date): Promise<URL>;
    getObjectInfo(s3RegionId: string, object: Object): Promise<ObjectInfo>;
    getObjectHeader(s3RegionId: string, object: Object, domain?: Domain): Promise<ObjectHeader>;
    moveObject(s3RegionId: string, transferObject: TransferObject): Promise<void>;
    copyObject(s3RegionId: string, transferObject: TransferObject): Promise<void>;
    moveObjects(s3RegionId: string, transferObjects: Array<TransferObject>, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    copyObjects(s3RegionId: string, transferObjects: Array<TransferObject>, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    private moveOrCopyObjects;
    deleteObjects(s3RegionId: string, bucket: string, keys: Array<string>, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    freeze(s3RegionId: string, object: Object): Promise<void>;
    getFrozenInfo(s3RegionId: string, object: Object): Promise<FrozenInfo>;
    unfreeze(s3RegionId: string, object: Object, days: number): Promise<void>;
    listObjects(s3RegionId: string, bucket: string, prefix: string, option?: ListObjectsOption): Promise<ListedObjects>;
    private _listObjects;
    createMultipartUpload(s3RegionId: string, object: Object, _originalFileName: string, _header?: SetObjectHeader): Promise<InitPartsOutput>;
    uploadPart(s3RegionId: string, object: Object, uploadId: string, partNumber: number, data: Buffer, option?: PutObjectOption): Promise<UploadPartOutput>;
    completeMultipartUpload(s3RegionId: string, object: Object, uploadId: string, parts: Array<Part>, originalFileName: string, header?: SetObjectHeader): Promise<void>;
    clearCache(): void;
}
export interface BucketIdName {
    id: string;
    name: string;
}
//# sourceMappingURL=kodo.d.ts.map