export declare class Semaphore {
    private readonly _maxSemaphores;
    private _currentSemaphores;
    private _waitingCallers;
    /**
     * Creates a new semaphore container.
     * @param count Number of available semaphores
     */
    constructor(count: number);
    tryAcquire(): () => void;
    /**
     * Acquire a new semaphore.
     * The returned promise resolves as soon as a semaphore is available and returns a function `release`
     * which has to be used to release the acquired promise.
     * @return {Promise<Function>}
     */
    acquire(): Promise<() => void>;
    /**
     * Release the given semaphore.
     * This is usually done from inside the resolve callback because the ID is only known there.
     */
    release(id: Symbol): void;
    private readonly hasAvailableSemaphores;
    /**
     * @param id ID of the semaphore which is released when calling this function
     */
    private createReleaseFunction;
    /**
     * When a semaphore is requested, the request is added to a queue.
     * The queue is processed by this function.
     */
    private treatPendingCallers;
}
