/// <reference types="node" />
import { RegionRequestOptions } from './region';
import { RegionService } from './region_service';
import { URL } from 'url';
import { Readable } from 'stream';
import { HttpClientResponse } from 'urllib';
import { Adapter, AdapterOption, Bucket, Domain, Object, SetObjectHeader, ObjectGetResult, ObjectHeader, ObjectInfo, TransferObject, PartialObjectError, BatchCallback, FrozenInfo, ListObjectsOption, ListedObjects, PutObjectOption, InitPartsOutput, UploadPartOutput, StorageClass, Part, GetObjectStreamOption } from './adapter';
import { KodoHttpClient, RequestOptions } from './kodo-http-client';
import { URLRequestOptions } from './http-client';
import { UplogEntry } from './uplog';
export declare const USER_AGENT: string;
export declare class Kodo implements Adapter {
    protected adapterOption: AdapterOption;
    protected readonly client: KodoHttpClient;
    protected readonly regionService: RegionService;
    private readonly bucketDomainsCache;
    private readonly bucketDomainsCacheLock;
    constructor(adapterOption: AdapterOption);
    enter<T>(sdkApiName: string, f: (scope: Adapter, options: RegionRequestOptions) => Promise<T>): Promise<T>;
    createBucket(s3RegionId: string, bucket: string): Promise<void>;
    deleteBucket(_region: string, bucket: string): Promise<void>;
    getBucketLocation(bucket: string): Promise<string>;
    listBuckets(): Promise<Array<Bucket>>;
    listDomains(s3RegionId: string, bucket: string): Promise<Array<Domain>>;
    private _listDomains;
    listBucketIdNames(): Promise<Array<BucketIdName>>;
    isExists(s3RegionId: string, object: Object): Promise<boolean>;
    deleteObject(s3RegionId: string, object: Object): Promise<void>;
    putObject(s3RegionId: string, object: Object, data: Buffer, originalFileName: string, header?: SetObjectHeader, option?: PutObjectOption): Promise<void>;
    getObject(s3RegionId: string, object: Object, domain?: Domain): Promise<ObjectGetResult>;
    getObjectStream(s3RegionId: string, object: Object, domain?: Domain, option?: GetObjectStreamOption): Promise<Readable>;
    getObjectURL(s3RegionId: string, object: Object, domain?: Domain, deadline?: Date): Promise<URL>;
    getObjectInfo(s3RegionId: string, object: Object): Promise<ObjectInfo>;
    getObjectHeader(s3RegionId: string, object: Object, domain?: Domain): Promise<ObjectHeader>;
    moveObject(s3RegionId: string, transferObject: TransferObject): Promise<void>;
    copyObject(s3RegionId: string, transferObject: TransferObject): Promise<void>;
    moveObjects(s3RegionId: string, transferObjects: Array<TransferObject>, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    copyObjects(s3RegionId: string, transferObjects: Array<TransferObject>, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    deleteObjects(s3RegionId: string, bucket: string, keys: Array<string>, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    setObjectsStorageClass(s3RegionId: string, bucket: string, keys: Array<string>, storageClass: StorageClass, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    restoreObjects(s3RegionId: string, bucket: string, keys: Array<string>, days: number, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    private batchOps;
    getFrozenInfo(s3RegionId: string, object: Object): Promise<FrozenInfo>;
    restoreObject(s3RegionId: string, object: Object, days: number): Promise<void>;
    setObjectStorageClass(s3RegionId: string, object: Object, storageClass: StorageClass): Promise<void>;
    listObjects(s3RegionId: string, bucket: string, prefix: string, option?: ListObjectsOption): Promise<ListedObjects>;
    private _listObjects;
    createMultipartUpload(s3RegionId: string, object: Object, _originalFileName: string, _header?: SetObjectHeader): Promise<InitPartsOutput>;
    uploadPart(s3RegionId: string, object: Object, uploadId: string, partNumber: number, data: Buffer, option?: PutObjectOption): Promise<UploadPartOutput>;
    completeMultipartUpload(s3RegionId: string, object: Object, uploadId: string, parts: Array<Part>, originalFileName: string, header?: SetObjectHeader): Promise<void>;
    clearCache(): void;
    protected call<T = any>(options: RequestOptions): Promise<HttpClientResponse<T>>;
    protected callUrl<T = any>(urls: Array<string>, options: URLRequestOptions): Promise<HttpClientResponse<T>>;
    protected getRegionRequestOptions(): RegionRequestOptions;
    protected log(entry: UplogEntry): Promise<void>;
}
export interface BucketIdName {
    id: string;
    name: string;
}
//# sourceMappingURL=kodo.d.ts.map