/// <reference types="node" />
import { URL } from 'url';
import { Readable } from 'stream';
import { Kodo } from './kodo';
import { Adapter, Bucket, Domain, Object, SetObjectHeader, ObjectGetResult, ObjectHeader, ObjectInfo, TransferObject, PartialObjectError, BatchCallback, FrozenInfo, ListedObjects, ListObjectsOption, PutObjectOption, InitPartsOutput, UploadPartOutput, StorageClass, Part, GetObjectStreamOption } from './adapter';
import { RequestStats } from './http-client';
import { RegionRequestOptions } from './region';
export declare const USER_AGENT: string;
interface RequestOptions {
    stats?: RequestStats;
}
export declare class S3 extends Kodo {
    private readonly bucketNameToIdCache;
    private readonly bucketIdToNameCache;
    private readonly clients;
    private readonly bucketNameToIdCacheLock;
    private readonly clientsLock;
    private getClient;
    fromKodoBucketNameToS3BucketId(bucketName: string): Promise<string>;
    fromS3BucketIdToKodoBucketName(bucketId: string): Promise<string>;
    enter<T>(sdkApiName: string, f: (scope: Adapter, options: RegionRequestOptions) => Promise<T>): Promise<T>;
    private sendS3Request;
    createBucket(s3RegionId: string, bucket: string): Promise<void>;
    deleteBucket(s3RegionId: string, bucket: string): Promise<void>;
    getBucketLocation(bucket: string): Promise<string>;
    private _getBucketLocation;
    listBuckets(): Promise<Array<Bucket>>;
    listDomains(_s3RegionId: string, _bucket: string): Promise<Array<Domain>>;
    isExists(s3RegionId: string, object: Object): Promise<boolean>;
    deleteObject(s3RegionId: string, object: Object): Promise<void>;
    putObject(s3RegionId: string, object: Object, data: Buffer, originalFileName: string, header?: SetObjectHeader, option?: PutObjectOption): Promise<void>;
    getObject(s3RegionId: string, object: Object, _domain?: Domain): Promise<ObjectGetResult>;
    getObjectStream(s3RegionId: string, object: Object, _domain?: Domain, option?: GetObjectStreamOption): Promise<Readable>;
    getObjectURL(s3RegionId: string, object: Object, _domain?: Domain, deadline?: Date): Promise<URL>;
    getObjectInfo(s3RegionId: string, object: Object): Promise<ObjectInfo>;
    getObjectHeader(s3RegionId: string, object: Object, _domain?: Domain): Promise<ObjectHeader>;
    moveObject(s3RegionId: string, transferObject: TransferObject): Promise<void>;
    copyObject(s3RegionId: string, transferObject: TransferObject): Promise<void>;
    private getObjectStorageClass;
    moveObjects(s3RegionId: string, transferObjects: Array<TransferObject>, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    copyObjects(s3RegionId: string, transferObjects: Array<TransferObject>, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    setObjectsStorageClass(s3RegionId: string, bucket: string, keys: Array<string>, storageClass: StorageClass, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    restoreObjects(s3RegionId: string, bucket: string, keys: Array<string>, days: number, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    private s3BatchOps;
    deleteObjects(s3RegionId: string, bucket: string, keys: Array<string>, callback?: BatchCallback): Promise<Array<PartialObjectError>>;
    getFrozenInfo(s3RegionId: string, object: Object): Promise<FrozenInfo>;
    restoreObject(s3RegionId: string, object: Object, days: number): Promise<void>;
    setObjectStorageClass(s3RegionId: string, object: Object, storageClass: StorageClass): Promise<void>;
    listObjects(s3RegionId: string, bucket: string, prefix: string, option?: ListObjectsOption): Promise<ListedObjects>;
    private _listS3Objects;
    createMultipartUpload(s3RegionId: string, object: Object, originalFileName: string, header?: SetObjectHeader): Promise<InitPartsOutput>;
    uploadPart(s3RegionId: string, object: Object, uploadId: string, partNumber: number, data: Buffer, option?: PutObjectOption): Promise<UploadPartOutput>;
    completeMultipartUpload(s3RegionId: string, object: Object, uploadId: string, parts: Array<Part>, _originalFileName: string, _header?: SetObjectHeader): Promise<void>;
    clearCache(): void;
    protected getRequestsOption(): RequestOptions;
}
export {};
//# sourceMappingURL=s3.d.ts.map