/// <reference types="node" />
export interface UplogOption {
    appName?: string;
    appVersion?: string;
    bufferSize?: number;
    onBufferFull?: (buffer: Buffer) => Promise<void>;
}
export interface UplogEntry {
    log_type: LogType;
    os_name?: string;
    os_version?: string;
    sdk_name?: string;
    sdk_version?: string;
    http_client?: string;
    http_client_version?: string;
    up_time?: number;
}
export interface RequestUplogEntry extends UplogEntry {
    status_code?: number;
    req_id?: string;
    host: string;
    port: number;
    method: string;
    path: string;
    remote_ip?: string;
    total_elapsed_time: number;
    bytes_sent?: number;
    error_type?: ErrorType;
    error_description?: string;
}
export interface SdkApiUplogEntry extends UplogEntry {
    api_name: string;
    total_elapsed_time: number;
    requests_count: number;
    error_type?: ErrorType;
    error_description?: string;
}
export declare enum LogType {
    Request = "request",
    SdkApi = "sdkapi"
}
export declare enum ErrorType {
    UnknownError = "unknown_error",
    NetworkError = "network_error",
    Timeout = "timeout",
    UnknownHost = "unknown_host",
    CannotConnectToHost = "cannot_connect_to_host",
    TransmissionError = "transmission_error",
    ProxyError = "proxy_error",
    SslError = "ssl_error",
    ResponseError = "response_error",
    ParseError = "parse_error",
    MaliciousResponse = "malicious_response",
    UserCanceled = "user_canceled",
    BadRequest = "bad_request",
    UnexpectedSyscallError = "unexpected_syscall_error"
}
export declare const UplogBufferFilePath: string;
export declare const UplogBufferFileLockPath: string;
export declare class UplogBuffer {
    private readonly option;
    private static uploadBufferedEntries;
    private static uploadBufferFd;
    constructor(option: UplogOption);
    log(entry: UplogEntry): Promise<void>;
    private flushBufferToLogFile;
    private exportLogs;
    private convertUplogEntryToJSON;
    private lockOptions;
}
export declare const getErrorTypeFromStatusCode: (statusCode: number) => ErrorType;
export declare const getErrorTypeFromRequestError: (err: any) => ErrorType;
export declare const getErrorTypeFromS3Error: (err: any) => ErrorType;
//# sourceMappingURL=uplog.d.ts.map