"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Path = void 0;
const path_1 = __importDefault(require("path"));
class Path {
    constructor(sep, root, base, ext, dirSegments, isDir) {
        this.sep = sep;
        this.root = root;
        this.base = base;
        this.ext = ext;
        this.dirSegments = dirSegments;
        this.isDir = isDir;
    }
    basename() { return this.base; }
    extname() { return this.ext; }
    directoryBasename() {
        if (this.dirSegments.length > 0) {
            return this.dirSegments[this.dirSegments.length - 1];
        }
        else {
            return undefined;
        }
    }
    directory() {
        if (this.dirSegments.length > 0) {
            return `${this.root}${this.dirSegments.join(this.sep)}${this.sep}`;
        }
        else {
            return this.root;
        }
    }
    toString() {
        let fullPath = this.directory();
        if (this.basename()) {
            fullPath += this.basename();
        }
        return fullPath;
    }
    parentDirectoryPath() {
        if (this.isDir) {
            const dirSegments = this.dirSegments.slice(0, this.dirSegments.length - 1);
            return new Path(this.sep, this.root, undefined, undefined, dirSegments, true);
        }
        else {
            return new Path(this.sep, this.root, undefined, undefined, this.dirSegments, true);
        }
    }
    joinFile(pathStr) {
        while (pathStr.endsWith(this.sep)) {
            pathStr = pathStr.slice(0, pathStr.length - 1);
        }
        return this.join(pathStr);
    }
    joinFolder(pathStr) {
        if (!pathStr.endsWith(this.sep)) {
            pathStr += this.sep;
        }
        return this.join(pathStr);
    }
    join(pathStr) {
        if (this.isDir) {
            const segments = pathStr.split(this.sep);
            let isDir = false;
            let base = undefined;
            let ext = undefined;
            if (pathStr.endsWith(this.sep)) {
                segments.pop();
                isDir = true;
            }
            else {
                base = segments.pop();
                if (base) {
                    ext = path_1.default.extname(base);
                }
            }
            const dirSegments = this.dirSegments.concat(segments);
            return new Path(this.sep, this.root, base, ext, dirSegments, isDir);
        }
        else {
            throw new Error("Cannot join path for File");
        }
    }
}
exports.Path = Path;
//# sourceMappingURL=path.js.map