<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_auth_digest - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_auth_digest</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_auth_digest.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_auth_digest.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/mod/mod_auth_digest.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Authentification utilisateur utilisant les condenss
MD5</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>auth_digest_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_auth_digest.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module implmente l'authentification HTTP base sur les
    condenss MD5 (<a href="http://www.faqs.org/rfcs/rfc2617.html">RFC2617</a>), et
    fournit une alternative  <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code> en
    ne transmettant plus le mot de passe en clair. Cependant, cela ne
    suffit pas pour amliorer la scurit de manire significative par
    rapport  l'authentification basique. En outre, le stockage du mot
    de passe sur le serveur est encore moins sr dans le cas
    d'une authentification  base de condens que dans le cas d'une
    authentification basique. C'est pourquoi l'utilisation de
    l'authentification basique associe  un chiffrement de la connexion
    via <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> constitue une bien meilleure
    alternative.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#authdigestalgorithm">AuthDigestAlgorithm</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authdigestdomain">AuthDigestDomain</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authdigestnoncelifetime">AuthDigestNonceLifetime</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authdigestprovider">AuthDigestProvider</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authdigestqop">AuthDigestQop</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authdigestshmemsize">AuthDigestShmemSize</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#using">Utilisation de l'authentification  base de
condenss</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="directive"><a href="../mod/mod_authn_core.html#authname">AuthName</a></code></li>
<li><code class="directive"><a href="../mod/mod_authn_core.html#authtype">AuthType</a></code></li>
<li><code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code></li>
<li><a href="../howto/auth.html">Mode d'emploi de
l'authentification</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="using" id="using">Utilisation de l'authentification  base de
condenss</a></h2>

    <p>Pour utiliser l'authentification  base de condenss MD5, vous
    devez simplement remplacer <code>AuthType Basic</code> et <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code> respectivement
    par <code>AuthType Digest</code> et <code class="directive"><a href="#authdigestprovider">AuthDigestProvider</a></code> lorsque vous
    configurez l'authentification, puis ajouter une directive <code class="directive"><a href="#authdigestdomain">AuthDigestDomain</a></code> contenant au
    moins la(les) URI(s) racine(s) de la zone  protger.</p>

    <p>On peut crer les fichiers utilisateur appropris (au format
    texte)  l'aide de l'outil <code class="program"><a href="../programs/htdigest.html">htdigest</a></code>.</p>

    <div class="example"><h3>Exemple :</h3><pre class="prettyprint lang-config">&lt;Location /private/&gt;
    AuthType Digest
    AuthName "private area"
    AuthDigestDomain /private/ http://mirror.my.dom/private2/
    
    AuthDigestProvider file
    AuthUserFile /web/auth/.digest_pw
    Require valid-user
&lt;/Location&gt;</pre>
</div>

    <div class="note"><h3>Note</h3>
    <p>L'authentification  base de condens a t conue pour amliorer
    la scurit par rapport  l'authentification basique, mais il
    s'avre que ce but n'a pas t atteint. Un attaquant de type
    "man-in-the-middle" peut facilement forcer le navigateur  revenir 
    une authentification basique. Mme une oreille indiscrte passive
    peut retrouver le mot de passe par force brute avec les moyens
    modernes, car l'algorithme de hashage utilis par l'authentification
     base de condens est trop rapide. Autre problme, le stockage des
    mots de passe sur le serveur n'est pas sr. Le contenu d'un fichier
    htdigest vol peut tre utilis directement pour l'authentification
     base de condens. Il est donc fortement recommand d'utiliser
    <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> pour chiffrer la connexion.</p>
    <p><code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code> ne fonctionne correctement que
    sur les plates-formes o APR supporte la mmoire partage.</p>
    </div>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthDigestAlgorithm" id="AuthDigestAlgorithm">AuthDigestAlgorithm</a> <a name="authdigestalgorithm" id="authdigestalgorithm">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Slectionne l'algorithme utilis pour calculer les
condenss du dfit et de sa rponse</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthDigestAlgorithm MD5|MD5-sess</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthDigestAlgorithm MD5</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_digest</td></tr>
</table>
    <p>La directive <code class="directive">AuthDigestAlgorithm</code> permet de
    slectionner l'algorithme utilis pour calculer les condenss du
    dfit et de sa rponse.</p>

    <div class="note">
      <code>MD5-sess</code> n'est pas encore correctement implment.
    </div>
    

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthDigestDomain" id="AuthDigestDomain">AuthDigestDomain</a> <a name="authdigestdomain" id="authdigestdomain">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Les URIs qui se trouvent dans le mme espace de protection
concernant l'authentification  base de condenss</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthDigestDomain <var>URI</var> [<var>URI</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_digest</td></tr>
</table>
    <p>La directive <code class="directive">AuthDigestDomain</code> vous permet
    de spcifier un ou plusieurs URIs se trouvant dans le mme
    espace de protection (c'est  dire utilisant le mme utilisateur/mot
    de passe et se trouvant dans le mme domaine). Les URIs spcifis
    sont des prfixes ; le client doit savoir que tous les URIs situs
    sous ces prfixes seront protgs par le mme utilisateur/mot de
    passe. Les URIs peuvent tre soit des URIs absolus (c'est  dire
    avec protocole, nom serveur, port, etc...), soit des URIs
    relatifs.</p>

    <p>Cette directive doit toujours tre prsente et contenir au moins
    le(s) URI(s) racine(s) pour cet espace. Dans le cas contraire, le
    client va envoyer un en-tte d'autorisation avec <em>chaque
    requte</em>  destination de ce serveur.</p>

    <p>Les URIs spcifis peuvent aussi rfrencer diffrents serveurs,
    auquel cas les clients (qui sont  mme de le comprendre) vont
    partager l'utilisateur/mot de passe entre plusieurs serveurs sans le
    demander  l'utilisateur  chaque fois.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthDigestNonceLifetime" id="AuthDigestNonceLifetime">AuthDigestNonceLifetime</a> <a name="authdigestnoncelifetime" id="authdigestnoncelifetime">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dure de validit du nombre  valeur unique du
serveur (nonce)</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthDigestNonceLifetime <var>secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthDigestNonceLifetime 300</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_digest</td></tr>
</table>
    <p>La directive <code class="directive">AuthDigestNonceLifetime</code>
    permet de contrler la dure de validit du nombre  valeur unique
    du serveur (nonce). Lorsque le client contacte le serveur en
    utilisant un nonce dont la validit a expir, le serveur renvoie un
    code d'erreur 401 avec <code>stale=true</code>. Si
    <var>secondes</var> est suprieur  0, il spcifie la dure de
    validit du nonce ; il est en gnral dconseill d'affecter  cet
    argument une valeur infrieure  10 secondes. Si
    <var>secondes</var> est infrieur  0, le nonce n'expire jamais.
    
    </p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthDigestProvider" id="AuthDigestProvider">AuthDigestProvider</a> <a name="authdigestprovider" id="authdigestprovider">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit le(s) fournisseurs(s) d'authentification pour la
zone du site web concerne</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthDigestProvider <var>nom fournisseur</var>
[<var>nom fournisseur</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthDigestProvider file</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_digest</td></tr>
</table>
    <p>La directive <code class="directive">AuthDigestProvider</code> permet de
    dfinir quel fournisseur d'authentification sera utilis pour
    authentifier les utilisateurs pour la zone du site web concerne.
    Assurez-vous que le module implmentant le fournisseur
    d'authentification choisi soit bien prsent dans le serveur. Le
    fournisseur par dfaut <code>file</code> est implment par le
    module <code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code>.</p>

    <p>Voir <code class="module"><a href="../mod/mod_authn_dbm.html">mod_authn_dbm</a></code>,
    <code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code>, <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code> et
    <code class="module"><a href="../mod/mod_authn_socache.html">mod_authn_socache</a></code>
    pour la liste des fournisseurs disponibles.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthDigestQop" id="AuthDigestQop">AuthDigestQop</a> <a name="authdigestqop" id="authdigestqop">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine le niveau de protection fourni par
l'authentification  base de condens</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthDigestQop none|auth|auth-int [auth|auth-int]</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthDigestQop auth</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_digest</td></tr>
</table>
    <p>La directive <code class="directive">AuthDigestQop</code> permet de
    dfinir le <dfn>niveau de protection</dfn> fourni. <code>auth</code>
    ne fournit que l'authentification (nom utilisateur/mot de passe) ;
    <code>auth-int</code> fournit l'authentification plus un contrle
    d'intgrit (un condens MD5 de l'entit est aussi calcul et
    vrifi) ; avec <code>none</code>, le module va utiliser l'ancien
    algorithme de condenss RFC-2069 (qui n'effectue pas de contrle
    d'intgrit). On peut spcifier  la fois <code>auth</code> et
    <code>auth-int</code>, auquel cas c'est le navigateur qui va choisir
    lequel des deux utiliser. <code>none</code> ne doit tre utilis que
    dans le cas o le navigateur ne serait pas  mme (pour une raison
    ou pour une autre) de relever le dfit qu'il recevrait si un autre
    niveau de protection tait dfini.</p>

    <div class="note">
      <code>auth-int</code> n'est pas encore implment.
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthDigestShmemSize" id="AuthDigestShmemSize">AuthDigestShmemSize</a> <a name="authdigestshmemsize" id="authdigestshmemsize">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>La quantit de mmoire partage  allouer afin de conserver
les informations  propos des clients</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthDigestShmemSize <var>taille</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthDigestShmemSize 1000</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_auth_digest</td></tr>
</table>
    <p>La directive <code class="directive">AuthDigestShmemSize</code> permet de
    dfinir la quantit de mmoire partage  allouer au dmarrage du
    serveur afin de conserver les informations  propos des clients.
    Notez que le segment de mmoire partage ne peut pas tre dfini 
    une taille infrieure  l'espace ncessaire pour conserver les
    informations  propos d'<em>un</em> client. Cette valeur dpend de
    votre systme. Si vous voulez en dterminer la valeur exacte, vous
    pouvez simplement dfinir <code class="directive">AuthDigestShmemSize</code>
     <code>0</code> et consulter le message d'erreur que renverra le
    serveur lorsqu'on essaiera de le dmarrer.</p>

    <p>L'argument <var>size</var> s'exprime par dfaut en octets, mais
    vous pouvez suffixer le nombre par un <code>K</code> ou un
    <code>M</code> pour spcifier respectivement des KiloOctets ou des
    MgaOctets. Par exemple, les directives qui suivent sont toutes
    quivalentes :</p>

    <pre class="prettyprint lang-config">AuthDigestShmemSize 1048576
AuthDigestShmemSize 1024K
AuthDigestShmemSize 1M</pre>


</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_auth_digest.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_auth_digest.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/mod/mod_auth_digest.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_auth_digest.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2014 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>