/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.macos;

import com.github.weisj.darklaf.platform.NativeUtil;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MacOSLibrary {
    private static final Logger LOGGER = LogUtil.getLogger(MacOSLibrary.class);
    private static boolean loaded;
    private static boolean attemptedLoad;

    public static void updateLibrary() {
        if (!loaded && !attemptedLoad) {
            MacOSLibrary.loadLibrary();
        }
    }

    private static void loadLibrary() {
        attemptedLoad = true;
        if (!SystemInfo.isMacOSYosemite || loaded) {
            return;
        }
        try {
            if (SystemInfo.isX64) {
                NativeUtil.loadLibraryFromJar((String)"/com/github/weisj/darklaf/platform/darklaf-macos/macos-x86-64/libdarklaf-macos.dylib");
                loaded = true;
                LOGGER.info("Loaded libdarklaf-macos.dylib. Native features are enabled.");
            } else {
                LOGGER.warning("JRE model '" + SystemInfo.jreArchitecture + "' not supported. Native features will be disabled");
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Could not load decorations library libdarklaf-macos.dylib. Native features will be disabled", e);
        }
    }

    public static boolean isLoaded() {
        return loaded;
    }
}

