/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.function.ArgumentConstraint;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.ArgumentError;
import io.burt.jmespath.function.ArityException;
import io.burt.jmespath.function.Function;
import io.burt.jmespath.function.FunctionArgument;
import io.burt.jmespath.function.FunctionConfigurationException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseFunction
implements Function {
    private final ArgumentConstraint argumentConstraints;
    private final String name;
    private static final Pattern CAMEL_CASE_COMPONENT_RE = Pattern.compile("[A-Z][^A-Z]+");

    public BaseFunction(ArgumentConstraint argumentConstraints) {
        this((String)null, argumentConstraints);
    }

    public BaseFunction(ArgumentConstraint ... argumentConstraints) {
        this((String)null, ArgumentConstraints.listOf(argumentConstraints));
    }

    public BaseFunction(String name, ArgumentConstraint ... argumentConstraints) {
        this(name, ArgumentConstraints.listOf(argumentConstraints));
    }

    public BaseFunction(String name, ArgumentConstraint argumentConstraints) {
        this.name = name == null ? this.classNameToFunctionName() : name;
        this.argumentConstraints = argumentConstraints;
    }

    private String classNameToFunctionName() {
        String piece;
        String n = this.getClass().getName();
        n = n.indexOf(36) > -1 ? n.substring(n.lastIndexOf(36) + 1) : n.substring(n.lastIndexOf(46) + 1);
        if (!n.endsWith("Function")) {
            throw new FunctionConfigurationException(String.format("The function defined by %s must either pass a name to the Function constructor or the class name must end with \"Function\"", this.getClass().getName()));
        }
        Matcher m = CAMEL_CASE_COMPONENT_RE.matcher(n);
        int offset = 0;
        StringBuilder snakeCaseName = new StringBuilder();
        while (m.find(offset) && !(piece = n.substring(m.start(), m.end()).toLowerCase()).equals("function")) {
            snakeCaseName.append(piece);
            snakeCaseName.append('_');
            offset = m.end();
        }
        snakeCaseName.deleteCharAt(snakeCaseName.length() - 1);
        return snakeCaseName.toString();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ArgumentConstraint argumentConstraints() {
        return this.argumentConstraints;
    }

    @Override
    public <T> T call(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        Iterator<FunctionArgument<T>> argumentIterator = arguments.iterator();
        Iterator<ArgumentError> maybeError = this.argumentConstraints.check(runtime, argumentIterator, true);
        if (!maybeError.hasNext()) {
            return this.callFunction(runtime, arguments);
        }
        ArgumentError error = maybeError.next();
        if (error instanceof ArgumentError.ArgumentTypeError) {
            ArgumentError.ArgumentTypeError e = (ArgumentError.ArgumentTypeError)error;
            return runtime.handleArgumentTypeError(this, e.expectedType(), e.actualType());
        }
        if (error instanceof ArgumentError.ArityError) {
            throw new IllegalStateException(ArityException.createMessage(this, arguments.size(), true));
        }
        throw new IllegalStateException(String.format("Unexpected error while type checking arguments to \"%s\": %s", this.name(), error.getClass().getName()));
    }

    protected abstract <T> T callFunction(Adapter<T> var1, List<FunctionArgument<T>> var2);
}

