/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.dashboard;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.jmeter.report.core.JsonUtil;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.ResultData;
import org.apache.jmeter.report.processor.ResultDataVisitor;
import org.apache.jmeter.report.processor.ValueResultData;

public class JsonizerVisitor
implements ResultDataVisitor<String> {
    @Override
    public String visitListResult(ListResultData listResult) {
        String result = "";
        if (listResult != null) {
            int count = listResult.getSize();
            String[] items = new String[count];
            for (int i = 0; i < count; ++i) {
                items[i] = listResult.get(i).accept(this);
            }
            result = JsonUtil.toJsonArray(items);
        }
        return result;
    }

    @Override
    public String visitMapResult(MapResultData mapResult) {
        String result = "";
        if (mapResult != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<String, ResultData> entry : mapResult.entrySet()) {
                map.put(entry.getKey(), entry.getValue().accept(this));
            }
            result = JsonUtil.toJsonObject(map);
        }
        return result;
    }

    @Override
    public String visitValueResult(ValueResultData valueResult) {
        String result = "";
        if (valueResult != null) {
            Object value = valueResult.getValue();
            result = String.valueOf(value);
            if (value instanceof String) {
                result = '\"' + StringEscapeUtils.escapeEcmaScript((String)result.replace('\"', '\'')) + '\"';
            }
        }
        return result;
    }
}

