/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.PercentileAggregatorFactory;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.report.processor.graph.AbstractGraphConsumer;
import org.apache.jmeter.report.processor.graph.ElapsedTimeValueSelector;
import org.apache.jmeter.report.processor.graph.GraphKeysSelector;
import org.apache.jmeter.report.processor.graph.GroupInfo;
import org.apache.jmeter.report.processor.graph.IndexedNameSelector;
import org.apache.jmeter.report.processor.graph.StaticSeriesSelector;
import org.apache.jmeter.util.JMeterUtils;

public class ResponseTimePerSampleGraphConsumer
extends AbstractGraphConsumer {
    private static final String RESPONSE_TIME_PER_SAMPLE_SERIES_FORMAT = "%dth percentile";

    @Override
    public void initialize() {
        super.initialize();
        this.setRevertKeysAndValues(true);
    }

    @Override
    protected final GraphKeysSelector createKeysSelector() {
        return new IndexedNameSelector();
    }

    private GroupInfo createGroupInfo(String propertyKey, int defaultValue) {
        int property = JMeterUtils.getPropDefault(propertyKey, defaultValue);
        PercentileAggregatorFactory factory = new PercentileAggregatorFactory();
        factory.setPercentileIndex(property);
        StaticSeriesSelector seriesSelector = new StaticSeriesSelector();
        seriesSelector.setSeriesName(String.format(RESPONSE_TIME_PER_SAMPLE_SERIES_FORMAT, property));
        return new GroupInfo(factory, seriesSelector, new ElapsedTimeValueSelector(false), false, false);
    }

    @Override
    protected Map<String, GroupInfo> createGroupInfos() {
        HashMap<String, GroupInfo> groupInfos = new HashMap<String, GroupInfo>(6);
        groupInfos.put("aggregate_rpt_pct1", this.createGroupInfo("aggregate_rpt_pct1", 90));
        groupInfos.put("aggregate_rpt_pct2", this.createGroupInfo("aggregate_rpt_pct2", 95));
        groupInfos.put("aggregate_rpt_pct3", this.createGroupInfo("aggregate_rpt_pct3", 99));
        return groupInfos;
    }

    @Override
    protected void initializeExtraResults(MapResultData parentResult) {
        ListResultData samples = new ListResultData();
        IndexedNameSelector indexedNameSelector = (IndexedNameSelector)this.getKeysSelector();
        int size = indexedNameSelector.getNames().size();
        for (int i = 0; i < size; ++i) {
            samples.addResult(new ValueResultData(indexedNameSelector.getNames().get(i)));
        }
        parentResult.setResult("sampleNames", samples);
    }
}

