/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.ChannelConnector;
import org.neo4j.driver.internal.async.pool.ExtendedChannelPool;
import org.neo4j.driver.internal.async.pool.NettyChannelTracker;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelHealthChecker;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.FixedChannelPool;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;

public class NettyChannelPool
extends FixedChannelPool
implements ExtendedChannelPool {
    private static final int MAX_PENDING_ACQUIRES = Integer.MAX_VALUE;
    private static final boolean RELEASE_HEALTH_CHECK = false;
    private final BoltServerAddress address;
    private final ChannelConnector connector;
    private final NettyChannelTracker handler;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public NettyChannelPool(BoltServerAddress address, ChannelConnector connector, Bootstrap bootstrap, NettyChannelTracker handler, ChannelHealthChecker healthCheck, long acquireTimeoutMillis, int maxConnections) {
        super(bootstrap, handler, healthCheck, FixedChannelPool.AcquireTimeoutAction.FAIL, acquireTimeoutMillis, maxConnections, Integer.MAX_VALUE, false);
        this.address = Objects.requireNonNull(address);
        this.connector = Objects.requireNonNull(connector);
        this.handler = Objects.requireNonNull(handler);
    }

    @Override
    protected ChannelFuture connectChannel(Bootstrap bootstrap) {
        ListenerEvent creatingEvent = this.handler.channelCreating(this.address);
        ChannelFuture channelFuture = this.connector.connect(this.address, bootstrap);
        channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (future.isSuccess()) {
                Channel channel = channelFuture.channel();
                this.handler.channelCreated(channel, creatingEvent);
            } else {
                this.handler.channelFailedToCreate(this.address);
            }
        }));
        return channelFuture;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            super.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }
}

