/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.color;

import com.github.weisj.darklaf.color.DarkColorModel;
import com.github.weisj.darklaf.util.LazyValue;
import java.awt.Color;

public class DarkColorModelRGB
extends DarkColorModel {
    private static final LazyValue<DarkColorModelRGB> instance = new LazyValue(DarkColorModelRGB::new);

    public static DarkColorModelRGB getInstance() {
        return (DarkColorModelRGB)instance.get();
    }

    public DarkColorModelRGB() {
        super("rgb", "Red", "Green", "Blue");
    }

    @Override
    public int getMinimum(int index) {
        return 0;
    }

    @Override
    public int getMaximum(int index) {
        return 255;
    }

    @Override
    public String toString() {
        return "RGB";
    }

    @Override
    public char[] getLabelDescriptorsBefore() {
        return new char[]{'R', 'G', 'B'};
    }

    @Override
    public char[] getLabelDescriptorsAfter() {
        return new char[]{'\u0000', '\u0000', '\u0000', '\u0000'};
    }

    @Override
    public int[] getValuesFromColor(Color color) {
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    @Override
    public Color getColorFromValues(int[] values) {
        return new Color(values[0], values[1], values[2]);
    }
}

