/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.PropertyLoader;
import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.icons.StateIcon;
import com.github.weisj.darklaf.task.AccentColorAdjustmentTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.ui.togglebutton.radiobutton.DarkRadioButtonUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class ColoredRadioButton
extends JRadioButton {
    public static final Color DEFAULT_FILLED = new Color(0);
    private Color color;

    public ColoredRadioButton(String text, Color color) {
        super(text, null, false);
        this.setColor(color);
    }

    public ColoredRadioButton(String text, boolean selected, Color color) {
        super(text, null, selected);
        this.setColor(color);
    }

    public void setColor(Color color) {
        this.color = color;
        ButtonUI ui = this.getUI();
        if (ui instanceof ColoredRadioButtonUI) {
            ((ColoredRadioButtonUI)ui).setColor(color);
        }
        SwingUtilities.invokeLater(this::updateUI);
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void updateUI() {
        this.setUI(new ColoredRadioButtonUI(this.color));
    }

    protected static class ColoredRadioButtonUI
    extends DarkRadioButtonUI {
        private static final String[] PROPERTIES = new String[]{"Icons.RadioButton.activeFillColor", "Icons.RadioButton.activeBorderColor", "Icons.RadioButtonDisabled.inactiveFillColor", "Icons.RadioButtonDisabled.inactiveBorderColor", "Icons.RadioButtonFocused.activeFillColor", "Icons.RadioButtonFocused.focusBorderColor", "Icons.RadioButtonFocused.glowFocus", "Icons.RadioButtonFocused.glowOpacity", "Icons.RadioButtonSelected.selectedFillColor", "Icons.RadioButtonSelected.selectedBorderColor", "Icons.RadioButtonSelected.selectionSelectedColor", "Icons.RadioButtonSelectedDisabled.inactiveFillColor", "Icons.RadioButtonSelectedDisabled.inactiveBorderColor", "Icons.RadioButtonSelectedDisabled.selectionDisabledColor", "Icons.RadioButtonSelectedFocused.selectedFillColor", "Icons.RadioButtonSelectedFocused.focusSelectedBorderColor", "Icons.RadioButtonSelectedFocused.selectionFocusSelectedColor", "Icons.RadioButtonSelectedFocused.glowFocus", "Icons.RadioButtonSelectedFocused.glowOpacity"};
        private static final String[] COLOR_PROPERTIES = new String[]{"Icons.RadioButton.activeFillColor", "Icons.RadioButton.activeBorderColor", "Icons.RadioButtonFocused.activeFillColor", "Icons.RadioButtonFocused.focusBorderColor", "Icons.RadioButtonSelected.selectedFillColor", "Icons.RadioButtonSelected.selectedBorderColor", "Icons.RadioButtonSelectedFocused.selectedFillColor", "Icons.RadioButtonSelectedFocused.focusSelectedBorderColor"};
        private Properties propertyMap;
        private Icon stateIcon;
        private final Color color;
        private static final AccentColorAdjustmentTask adjustment = new AccentColorAdjustmentTask();

        public ColoredRadioButtonUI(Color color) {
            this.color = color;
        }

        @Override
        protected void installIcons() {
            super.installIcons();
            this.setColor(this.color);
        }

        public void setColor(Color color) {
            if (color == null) {
                return;
            }
            IconLoader loader = DarkUIUtil.ICON_LOADER;
            Theme theme = LafManager.getTheme();
            Properties props = new Properties();
            UIDefaults defaults = UIManager.getLookAndFeelDefaults();
            theme.loadDefaults(props, defaults);
            Color c = color == DEFAULT_FILLED ? (Color)props.get("widgetFillDefault") : color;
            adjustment.applyColors(LafManager.getTheme(), props, c, null);
            PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(DarkLaf.class, (String)"radioButton", (String)"properties/ui/"), (Properties)props, (UIDefaults)defaults);
            PropertyLoader.putProperties((Properties)PropertyLoader.loadProperties(DarkLaf.class, (String)"radioButton", (String)"properties/icons/"), (Properties)props, (UIDefaults)defaults);
            this.propertyMap = new Properties();
            for (String prop : PROPERTIES) {
                this.propertyMap.put(prop, props.get(prop));
            }
            for (String prop : COLOR_PROPERTIES) {
                this.propertyMap.put(prop, c);
            }
            this.stateIcon = new StateIcon(new Icon[]{this.load(loader, "control/radio.svg"), this.load(loader, "control/radioDisabled.svg"), this.load(loader, "control/radioFocused.svg"), this.load(loader, "control/radioSelected.svg"), this.load(loader, "control/radioSelectedDisabled.svg"), this.load(loader, "control/radioSelectedFocused.svg")});
        }

        private Icon load(IconLoader loader, String name) {
            return loader.loadSVGIcon(name, 19, 19, true, (Map)this.propertyMap);
        }

        @Override
        protected Icon getStateIcon(AbstractButton b) {
            return this.color != null ? this.stateIcon : super.getStateIcon(b);
        }
    }
}

